/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.MutableProperty;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.CodePageUtil;
import org.apache.poi.util.LittleEndian;

public class Section {
    private Map<Long, String> dictionary;
    private ClassID formatID;
    private boolean dirty = true;
    private byte[] sectionBytes;
    private long offset = -1L;
    private int size;
    private final Map<Long, Property> properties = new TreeMap<Long, Property>();
    private boolean wasNull;

    public Section() {
    }

    public Section(Section s2) {
        this.setFormatID(s2.getFormatID());
        for (Property p : s2.properties.values()) {
            this.properties.put(p.getID(), new MutableProperty(p));
        }
        this.setDictionary(s2.getDictionary());
    }

    public Section(byte[] src, int offset) throws UnsupportedEncodingException {
        long off;
        int o1 = offset;
        this.formatID = new ClassID(src, o1);
        this.offset = LittleEndian.getUInt(src, o1 += 16);
        o1 = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, o1);
        int propertyCount = (int)LittleEndian.getUInt(src, o1 += 4);
        int pass1Offset = o1 += 4;
        long cpOffset = -1L;
        TreeBidiMap<Long, Long> offset2Id = new TreeBidiMap<Long, Long>();
        for (int i = 0; i < propertyCount; ++i) {
            long id2 = LittleEndian.getUInt(src, pass1Offset);
            off = LittleEndian.getUInt(src, pass1Offset += 4);
            pass1Offset += 4;
            offset2Id.put(off, id2);
            if (id2 != 1L) continue;
            cpOffset = off;
        }
        int codepage = -1;
        if (cpOffset != -1L) {
            long o = this.offset + cpOffset;
            long type = LittleEndian.getUInt(src, (int)o);
            o += 4L;
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = LittleEndian.getUShort(src, (int)o);
        }
        for (Map.Entry me : offset2Id.entrySet()) {
            Property p;
            off = (Long)me.getKey();
            long id3 = (Long)me.getValue();
            if (id3 == 1L) {
                p = new Property(1L, 2L, codepage);
            } else {
                int pLen = Section.propLen(offset2Id, off, this.size);
                long o = this.offset + off;
                p = new Property(id3, src, o, pLen, codepage);
            }
            this.properties.put(id3, p);
        }
        this.dictionary = (Map)this.getProperty(0L);
    }

    private static int propLen(TreeBidiMap<Long, Long> offset2Id, Long entryOffset, long maxSize) {
        Long nextKey = offset2Id.nextKey(entryOffset);
        long begin = entryOffset;
        long end = nextKey != null ? nextKey : maxSize;
        return (int)(end - begin);
    }

    public ClassID getFormatID() {
        return this.formatID;
    }

    public void setFormatID(ClassID formatID) {
        this.formatID = formatID;
    }

    public void setFormatID(byte[] formatID) {
        ClassID fid = this.getFormatID();
        if (fid == null) {
            fid = new ClassID();
            this.setFormatID(fid);
        }
        fid.setBytes(formatID);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Property[] getProperties() {
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    public void setProperties(Property[] properties) {
        this.properties.clear();
        for (Property p : properties) {
            this.properties.put(p.getID(), p);
        }
        this.dirty = true;
    }

    public Object getProperty(long id2) {
        this.wasNull = !this.properties.containsKey(id2);
        return this.wasNull ? null : this.properties.get(id2).getValue();
    }

    public void setProperty(int id2, String value) {
        this.setProperty(id2, 31L, value);
    }

    public void setProperty(int id2, int value) {
        this.setProperty(id2, 3L, value);
    }

    public void setProperty(int id2, long value) {
        this.setProperty(id2, 20L, value);
    }

    public void setProperty(int id2, boolean value) {
        this.setProperty(id2, 11L, value);
    }

    public void setProperty(int id2, long variantType, Object value) {
        this.setProperty(new Property(id2, variantType, value));
    }

    public void setProperty(Property p) {
        Property old = this.properties.get(p.getID());
        if (old == null || !old.equals(p)) {
            this.properties.put(p.getID(), p);
            this.dirty = true;
        }
    }

    public void setProperty(int id2, Object value) {
        if (value instanceof String) {
            this.setProperty(id2, (String)value);
        } else if (value instanceof Long) {
            this.setProperty(id2, (Long)value);
        } else if (value instanceof Integer) {
            this.setProperty(id2, (Integer)value);
        } else if (value instanceof Short) {
            this.setProperty(id2, ((Short)value).intValue());
        } else if (value instanceof Boolean) {
            this.setProperty(id2, (Boolean)value);
        } else if (value instanceof Date) {
            this.setProperty(id2, 64L, value);
        } else {
            throw new HPSFRuntimeException("HPSF does not support properties of type " + value.getClass().getName() + ".");
        }
    }

    protected int getPropertyIntValue(long id2) {
        Object o = this.getProperty(id2);
        if (o == null) {
            return 0;
        }
        if (!(o instanceof Long) && !(o instanceof Integer)) {
            throw new HPSFRuntimeException("This property is not an integer type, but " + o.getClass().getName() + ".");
        }
        Number i = (Number)o;
        return i.intValue();
    }

    protected boolean getPropertyBooleanValue(int id2) {
        Boolean b = (Boolean)this.getProperty(id2);
        if (b == null) {
            return false;
        }
        return b;
    }

    protected void setPropertyBooleanValue(int id2, boolean value) {
        this.setProperty(id2, 11L, value);
    }

    public int getSize() {
        if (this.dirty) {
            try {
                this.size = this.calcSize();
                this.dirty = false;
            }
            catch (HPSFRuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new HPSFRuntimeException(ex);
            }
        }
        return this.size;
    }

    private int calcSize() throws WritingNotSupportedException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out);
        out.close();
        this.sectionBytes = Util.pad4(out.toByteArray());
        return this.sectionBytes.length;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(long pid) {
        String s2 = null;
        if (this.dictionary != null) {
            s2 = this.dictionary.get(pid);
        }
        if (s2 == null) {
            s2 = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        return s2;
    }

    public void clear() {
        Property[] properties = this.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Property p = properties[i];
            this.removeProperty(p.getID());
        }
    }

    public void setCodepage(int codepage) {
        this.setProperty(1, 2L, codepage);
    }

    public boolean equals(Object o) {
        long id2;
        int i;
        if (o == null || !(o instanceof Section)) {
            return false;
        }
        Section s2 = (Section)o;
        if (!s2.getFormatID().equals(this.getFormatID())) {
            return false;
        }
        Object[] pa1 = new Property[this.getProperties().length];
        Object[] pa2 = new Property[s2.getProperties().length];
        System.arraycopy(this.getProperties(), 0, pa1, 0, pa1.length);
        System.arraycopy(s2.getProperties(), 0, pa2, 0, pa2.length);
        Property p10 = null;
        Property p20 = null;
        for (i = 0; i < pa1.length; ++i) {
            id2 = pa1[i].getID();
            if (id2 == 0L) {
                p10 = pa1[i];
                pa1 = this.remove((Property[])pa1, i);
                --i;
            }
            if (id2 != 1L) continue;
            pa1 = this.remove((Property[])pa1, i);
            --i;
        }
        for (i = 0; i < pa2.length; ++i) {
            id2 = pa2[i].getID();
            if (id2 == 0L) {
                p20 = pa2[i];
                pa2 = this.remove((Property[])pa2, i);
                --i;
            }
            if (id2 != 1L) continue;
            pa2 = this.remove((Property[])pa2, i);
            --i;
        }
        if (pa1.length != pa2.length) {
            return false;
        }
        boolean dictionaryEqual = true;
        if (p10 != null && p20 != null) {
            dictionaryEqual = p10.getValue().equals(p20.getValue());
        } else if (p10 != null || p20 != null) {
            dictionaryEqual = false;
        }
        if (dictionaryEqual) {
            return Util.equals(pa1, pa2);
        }
        return false;
    }

    public void removeProperty(long id2) {
        this.dirty |= this.properties.remove(id2) != null;
    }

    private Property[] remove(Property[] pa, int i) {
        Property[] h = new Property[pa.length - 1];
        if (i > 0) {
            System.arraycopy(pa, 0, h, 0, i);
        }
        System.arraycopy(pa, i + 1, h, i, h.length - i);
        return h;
    }

    public int write(OutputStream out) throws WritingNotSupportedException, IOException {
        if (!this.dirty && this.sectionBytes != null) {
            out.write(this.sectionBytes);
            return this.sectionBytes.length;
        }
        ByteArrayOutputStream propertyStream = new ByteArrayOutputStream();
        ByteArrayOutputStream propertyListStream = new ByteArrayOutputStream();
        int position = 0;
        position += 8 + this.getPropertyCount() * 2 * 4;
        int codepage = -1;
        if (this.getProperty(0L) != null) {
            Object p1 = this.getProperty(1L);
            if (p1 != null) {
                if (!(p1 instanceof Integer)) {
                    throw new IllegalPropertySetDataException("The codepage property (ID = 1) must be an Integer object.");
                }
            } else {
                this.setProperty(1, 2L, 1200);
            }
            codepage = this.getCodepage();
        }
        for (Property p : this.properties.values()) {
            long id2 = p.getID();
            TypeWriter.writeUIntToStream(propertyListStream, p.getID());
            TypeWriter.writeUIntToStream(propertyListStream, position);
            if (id2 != 0L) {
                position += p.write(propertyStream, this.getCodepage());
                continue;
            }
            if (codepage == -1) {
                throw new IllegalPropertySetDataException("Codepage (property 1) is undefined.");
            }
            position += Section.writeDictionary(propertyStream, this.dictionary, codepage);
        }
        propertyStream.close();
        propertyListStream.close();
        byte[] pb1 = propertyListStream.toByteArray();
        byte[] pb2 = propertyStream.toByteArray();
        TypeWriter.writeToStream(out, 8 + pb1.length + pb2.length);
        TypeWriter.writeToStream(out, this.getPropertyCount());
        out.write(pb1);
        out.write(pb2);
        int streamLength = 8 + pb1.length + pb2.length;
        return streamLength;
    }

    private static int writeDictionary(OutputStream out, Map<Long, String> dictionary, int codepage) throws IOException {
        int length = TypeWriter.writeUIntToStream(out, dictionary.size());
        for (Map.Entry<Long, String> ls : dictionary.entrySet()) {
            Long key = ls.getKey();
            String value = ls.getValue();
            if (codepage == 1200) {
                int sLength = value.length() + 1;
                if ((sLength & 1) == 1) {
                    ++sLength;
                }
                length += TypeWriter.writeUIntToStream(out, key);
                length += TypeWriter.writeUIntToStream(out, sLength);
                byte[] ca = CodePageUtil.getBytesInCodePage(value, codepage);
                for (int j = 2; j < ca.length; j += 2) {
                    out.write(ca[j + 1]);
                    out.write(ca[j]);
                    length += 2;
                }
                sLength -= value.length();
                while (sLength > 0) {
                    out.write(0);
                    out.write(0);
                    length += 2;
                    --sLength;
                }
                continue;
            }
            length += TypeWriter.writeUIntToStream(out, key);
            length += TypeWriter.writeUIntToStream(out, (long)value.length() + 1L);
            byte[] ba = CodePageUtil.getBytesInCodePage(value, codepage);
            for (int j = 0; j < ba.length; ++j) {
                out.write(ba[j]);
                ++length;
            }
            out.write(0);
            ++length;
        }
        return length;
    }

    public void setDictionary(Map<Long, String> dictionary) throws IllegalPropertySetDataException {
        if (dictionary != null) {
            this.dictionary = dictionary;
            this.setProperty(0, -1L, dictionary);
            Integer codepage = (Integer)this.getProperty(1L);
            if (codepage == null) {
                this.setProperty(1, 2L, 1200);
            }
        } else {
            this.removeProperty(0L);
        }
    }

    public int hashCode() {
        long hashCode = 0L;
        hashCode += (long)this.getFormatID().hashCode();
        Property[] pa = this.getProperties();
        for (int i = 0; i < pa.length; ++i) {
            hashCode += (long)pa[i].hashCode();
        }
        int returnHashCode = (int)(hashCode & 0xFFFFFFFFL);
        return returnHashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Property[] pa = this.getProperties();
        b.append(this.getClass().getName());
        b.append('[');
        b.append("formatID: ");
        b.append(this.getFormatID());
        b.append(", offset: ");
        b.append(this.getOffset());
        b.append(", propertyCount: ");
        b.append(this.getPropertyCount());
        b.append(", size: ");
        b.append(this.getSize());
        b.append(", properties: [\n");
        for (int i = 0; i < pa.length; ++i) {
            b.append(pa[i].toString());
            b.append(",\n");
        }
        b.append(']');
        b.append(']');
        return b.toString();
    }

    public Map<Long, String> getDictionary() {
        return this.dictionary;
    }

    public int getCodepage() {
        Integer codepage = (Integer)this.getProperty(1L);
        if (codepage == null) {
            return -1;
        }
        int cp = codepage;
        return cp;
    }
}

