/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.dev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RecordGenerator {
    public static void main(String[] args2) throws Exception {
        Class.forName("org.apache.poi.generator.FieldIterator");
        if (args2.length != 4) {
            System.out.println("Usage:");
            System.out.println("  java org.apache.poi.hssf.util.RecordGenerator RECORD_DEFINTIONS RECORD_STYLES DEST_SRC_PATH TEST_SRC_PATH");
        } else {
            RecordGenerator.generateRecords(args2[0], args2[1], args2[2], args2[3]);
        }
    }

    private static void generateRecords(String defintionsDir, String recordStyleDir, String destSrcPathDir, String testSrcPathDir) throws Exception {
        File[] definitionsFiles = new File(defintionsDir).listFiles();
        if (definitionsFiles == null) {
            System.err.println(defintionsDir + " is not a directory.");
            return;
        }
        for (File file : definitionsFiles) {
            if (!file.isFile() || !file.getName().endsWith("_record.xml") && !file.getName().endsWith("_type.xml")) continue;
            DocumentBuilderFactory factory = XMLHelper.getDocumentBuilderFactory();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            Element record = document.getDocumentElement();
            String extendstg = record.getElementsByTagName("extends").item(0).getFirstChild().getNodeValue();
            String suffix = record.getElementsByTagName("suffix").item(0).getFirstChild().getNodeValue();
            String recordName = record.getAttributes().getNamedItem("name").getNodeValue();
            String packageName = record.getAttributes().getNamedItem("package").getNodeValue();
            packageName = packageName.replace('.', '/');
            String destinationPath = destSrcPathDir + "/" + packageName;
            File destinationPathFile = new File(destinationPath);
            if (!destinationPathFile.mkdirs()) {
                throw new IOException("Could not create directory " + destinationPathFile);
            }
            System.out.println("Created destination directory: " + destinationPath);
            String destinationFilepath = destinationPath + "/" + recordName + suffix + ".java";
            RecordGenerator.transform(file, new File(destinationFilepath), new File(recordStyleDir + "/" + extendstg.toLowerCase(Locale.ROOT) + ".xsl"));
            System.out.println("Generated " + suffix + ": " + destinationFilepath);
            destinationPath = testSrcPathDir + "/" + packageName;
            destinationPathFile = new File(destinationPath);
            if (!destinationPathFile.mkdirs()) {
                throw new IOException("Could not create directory " + destinationPathFile);
            }
            System.out.println("Created destination directory: " + destinationPath);
            destinationFilepath = destinationPath + "/Test" + recordName + suffix + ".java";
            if (!new File(destinationFilepath).exists()) {
                String temp = recordStyleDir + "/" + extendstg.toLowerCase(Locale.ROOT) + "_test.xsl";
                RecordGenerator.transform(file, new File(destinationFilepath), new File(temp));
                System.out.println("Generated test: " + destinationFilepath);
                continue;
            }
            System.out.println("Skipped test generation: " + destinationFilepath);
        }
    }

    private static void transform(File in, File out, File xslt) throws FileNotFoundException, TransformerException {
        Transformer t;
        StreamSource ss = new StreamSource(xslt);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            t = tf.newTransformer(ss);
        }
        catch (TransformerException ex) {
            System.err.println("Error compiling XSL style sheet " + xslt);
            throw ex;
        }
        Properties p = new Properties();
        p.setProperty("method", "text");
        t.setOutputProperties(p);
        StreamResult result2 = new StreamResult(out);
        t.transform(new StreamSource(in), result2);
    }
}

