/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIDocument
implements Closeable {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    private DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized;
    private static final String[] encryptedStreamNames = new String[]{"EncryptedSummary"};

    protected POIDocument(DirectoryNode dir) {
        this.directory = dir;
    }

    protected POIDocument(OPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(POIFSFileSystem fs) {
        this(fs.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet ps = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (ps instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "DocumentSummaryInformation property set came back with wrong class - ", ps.getClass());
        } else {
            logger.log(5, "DocumentSummaryInformation property set came back as null");
        }
        ps = this.getPropertySet("\u0005SummaryInformation");
        if (ps instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "SummaryInformation property set came back with wrong class - ", ps.getClass());
        } else {
            logger.log(5, "SummaryInformation property set came back as null");
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String setName) {
        return this.getPropertySet(setName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected PropertySet getPropertySet(String setName, EncryptionInfo encryptionInfo) {
        PropertySet propertySet;
        DocumentInputStream dis;
        String step;
        NPOIFSFileSystem encPoifs;
        block23: {
            DirectoryNode dirNode;
            block21: {
                String encryptedStream;
                block22: {
                    dirNode = this.directory;
                    encPoifs = null;
                    step = "getting";
                    if (encryptionInfo != null) {
                        step = "getting encrypted";
                        encryptedStream = null;
                        for (String s2 : encryptedStreamNames) {
                            if (!dirNode.hasEntry(s2)) continue;
                            encryptedStream = s2;
                        }
                        if (encryptedStream == null) {
                            throw new EncryptedDocumentException("can't find matching encrypted property stream");
                        }
                        CryptoAPIDecryptor dec = (CryptoAPIDecryptor)encryptionInfo.getDecryptor();
                        encPoifs = dec.getSummaryEntries(dirNode, encryptedStream);
                        dirNode = encPoifs.getRoot();
                    }
                    if (dirNode != null && dirNode.hasEntry(setName)) break block21;
                    encryptedStream = null;
                    if (encPoifs == null) break block22;
                    try {
                        encPoifs.close();
                    }
                    catch (IOException e) {
                        logger.log(5, "Error closing encrypted property poifs", e);
                    }
                }
                return encryptedStream;
            }
            step = "getting";
            dis = dirNode.createDocumentInputStream(dirNode.getEntry(setName));
            step = "creating";
            propertySet = PropertySetFactory.create(dis);
            dis.close();
            if (encPoifs == null) break block23;
            try {
                encPoifs.close();
            }
            catch (IOException e) {
                logger.log(5, "Error closing encrypted property poifs", e);
            }
        }
        return propertySet;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.log(5, "Error " + step + " property set with name " + setName, e);
                        propertySet = null;
                        if (encPoifs != null) {
                            try {
                                encPoifs.close();
                            }
                            catch (IOException e2) {
                                logger.log(5, "Error closing encrypted property poifs", e2);
                            }
                        }
                        return propertySet;
                    }
                }
                catch (Throwable throwable2) {
                    if (encPoifs != null) {
                        try {
                            encPoifs.close();
                        }
                        catch (IOException e) {
                            logger.log(5, "Error closing encrypted property poifs", e);
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    protected void writeProperties() throws IOException {
        this.validateInPlaceWritePossible();
        this.writeProperties(this.directory.getFileSystem(), null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        DocumentSummaryInformation dsi;
        SummaryInformation si = this.getSummaryInformation();
        if (si != null) {
            this.writePropertySet("\u0005SummaryInformation", si, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if ((dsi = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", dsi, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String name, PropertySet set, NPOIFSFileSystem outFS) throws IOException {
        try {
            PropertySet mSet = new PropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createOrUpdateDocument(bIn, name);
            logger.log(3, "Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            logger.log(7, "Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }

    protected void validateInPlaceWritePossible() throws IllegalStateException {
        if (this.directory == null) {
            throw new IllegalStateException("Newly created Document, cannot save in-place");
        }
        if (this.directory.getParent() != null) {
            throw new IllegalStateException("This is not the root Document, cannot save embedded resource in-place");
        }
        if (this.directory.getFileSystem() == null || !this.directory.getFileSystem().isInPlaceWriteable()) {
            throw new IllegalStateException("Opened read-only or via an InputStream, a Writeable File is required");
        }
    }

    public abstract void write() throws IOException;

    public abstract void write(File var1) throws IOException;

    public abstract void write(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.directory != null && this.directory.getNFileSystem() != null) {
            this.directory.getNFileSystem().close();
            this.clearDirectory();
        }
    }

    @Internal
    public DirectoryNode getDirectory() {
        return this.directory;
    }

    @Internal
    protected void clearDirectory() {
        this.directory = null;
    }

    @Internal
    protected boolean initDirectory() {
        if (this.directory == null) {
            this.directory = new NPOIFSFileSystem().getRoot();
            return true;
        }
        return false;
    }

    @Internal
    protected DirectoryNode replaceDirectory(DirectoryNode newDirectory) {
        DirectoryNode dn = this.directory;
        this.directory = newDirectory;
        return dn;
    }
}

