/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTimestampWithTimeZone;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPTZ
extends Datum
implements OracleTimestampWithTimeZone {
    static final long serialVersionUID = 6708361144588335769L;
    static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int SECOND_MILLISECOND = 1000;
    private static int HOUR_SECOND = 3600;
    private static int MINUTE_SECOND = 60;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] timestamptz) {
        super(timestamptz);
    }

    public TIMESTAMPTZ(Connection conn, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
    }

    public TIMESTAMPTZ(Connection conn, Date date, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date, cal));
    }

    public TIMESTAMPTZ(Connection conn, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time));
    }

    public TIMESTAMPTZ(Connection conn, Time time, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time, cal));
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp2) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp2));
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp2, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp2, cal));
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp2, ZoneId tzid) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp2, tzid));
    }

    public TIMESTAMPTZ(Connection conn, DATE date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
    }

    public TIMESTAMPTZ(Connection conn, String str) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str));
    }

    public TIMESTAMPTZ(Connection conn, String str, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str, cal));
    }

    public TIMESTAMPTZ(OffsetDateTime odt) throws SQLException {
        super(TIMESTAMPTZ.toBytes(odt));
    }

    public TIMESTAMPTZ(ZonedDateTime zdt) throws SQLException {
        super(TIMESTAMPTZ.toBytes(zdt));
    }

    public TIMESTAMPTZ(Connection conn, LocalDateTime ldt) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, ldt));
    }

    public TIMESTAMPTZ(OffsetTime ot) throws SQLException {
        super(TIMESTAMPTZ.toBytes(ot));
    }

    public static Date toDate(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        OracleConnection intConn = conn.unwrap(OracleConnection.class);
        try (Monitor.CloseableLock lock = intConn.acquireCloseableLock();){
            for (int i = 0; i < 13; ++i) {
                result2[i] = timestamptz[i] & 0xFF;
            }
            int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
            Calendar cal = Calendar.getInstance();
            cal.set(1, year2);
            cal.set(2, result2[2] - 1);
            cal.set(5, result2[3]);
            cal.set(11, result2[4] - 1);
            cal.set(12, result2[5] - 1);
            cal.set(13, result2[6] - 1);
            int tsmillis = TIMESTAMP.getNanos(timestamptz, 7) / 1000000;
            cal.set(14, tsmillis);
            if ((result2[11] & REGIONIDBIT) != 0) {
                int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
                TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12]))) {
                    tzTab.updateTable(conn, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                cal.add(10, offset / HOUR_MILLISECOND);
                cal.add(12, offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            } else {
                cal.add(10, result2[11] - OFFSET_HOUR);
                cal.add(12, result2[12] - OFFSET_MINUTE);
            }
            long millis = cal.getTime().getTime();
            Date date = new Date(millis);
            return date;
        }
    }

    public static Date toDate2(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar cal = (Calendar)CAL_GMT_US.clone();
        cal.set(1, year2);
        cal.set(2, result2[2] - 1);
        cal.set(5, result2[3]);
        cal.set(11, result2[4] - 1);
        cal.set(12, result2[5] - 1);
        cal.set(13, result2[6] - 1);
        int tsmillis = TIMESTAMP.getNanos(timestamptz, 7) / 1000000;
        cal.set(14, tsmillis);
        long millis = cal.getTime().getTime();
        return new Date(millis);
    }

    public static Time toTime(Connection conn, byte[] timestamptz) throws SQLException {
        int hour2 = timestamptz[4] & 0xFF;
        int minute2 = timestamptz[5] & 0xFF;
        int second2 = timestamptz[6] & 0xFF;
        Calendar cal = (Calendar)CAL_GMT_US.clone();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, hour2 - 1);
        cal.set(12, minute2 - 1);
        cal.set(13, second2 - 1);
        cal.set(14, 0);
        return new Time(cal.getTimeInMillis());
    }

    public static DATE toDATE(Connection conn, byte[] timestamptz) throws SQLException {
        return new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, timestamptz));
    }

    public static TIMESTAMP toTIMESTAMP(Connection conn, byte[] timestamptz) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, timestamptz));
    }

    public static Timestamp toTimestamp(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        OracleConnection intConn = conn.unwrap(OracleConnection.class);
        try (Monitor.CloseableLock lock = intConn.acquireCloseableLock();){
            for (int i = 0; i < 13; ++i) {
                result2[i] = timestamptz[i] & 0xFF;
            }
            Calendar cal = Calendar.getInstance();
            Calendar gcal = (Calendar)CAL_GMT_US.clone();
            Calendar cal1 = Calendar.getInstance();
            int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
            cal.set(1, year2);
            cal.set(2, result2[2] - 1);
            cal.set(5, result2[3]);
            cal.set(11, result2[4] - 1);
            cal.set(12, result2[5] - 1);
            cal.set(13, result2[6] - 1);
            cal.set(14, 0);
            gcal.set(1, year2);
            gcal.set(2, result2[2] - 1);
            gcal.set(5, result2[3]);
            gcal.set(11, result2[4] - 1);
            gcal.set(12, result2[5] - 1);
            gcal.set(13, result2[6] - 1);
            gcal.set(14, 0);
            long timeInMillis = cal.getTime().getTime();
            if ((result2[11] & REGIONIDBIT) != 0) {
                int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
                TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12]))) {
                    tzTab.updateTable(conn, regionID);
                }
                int offset = tzTab.getOffset(gcal, regionID);
                TimeZone calTZ = cal.getTimeZone();
                TimeZone cal1TZ = cal1.getTimeZone();
                if (!calTZ.inDaylightTime(cal.getTime()) && cal1TZ.inDaylightTime(new Timestamp(timeInMillis += (long)offset))) {
                    timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis -= (long)((SimpleTimeZone)cal1TZ).getDSTSavings()) : (timeInMillis -= (long)HOUR_MILLISECOND);
                }
                if (calTZ.inDaylightTime(cal.getTime()) && !cal1TZ.inDaylightTime(new Timestamp(timeInMillis))) {
                    timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis += (long)((SimpleTimeZone)calTZ).getDSTSavings()) : (timeInMillis += (long)HOUR_MILLISECOND);
                }
            } else {
                cal.add(10, result2[11] - OFFSET_HOUR);
                cal.add(12, result2[12] - OFFSET_MINUTE);
                timeInMillis = cal.getTime().getTime();
            }
            Timestamp ts = new Timestamp(timeInMillis);
            long milliGMT = gcal.getTime().getTime();
            Calendar tcal = Calendar.getInstance();
            tcal.setTimeInMillis(milliGMT);
            Calendar tcal2 = Calendar.getInstance();
            tcal2.setTime(ts);
            boolean dst1 = tcal.getTimeZone().inDaylightTime(tcal.getTime());
            boolean dst2 = tcal2.getTimeZone().inDaylightTime(tcal2.getTime());
            if (dst1 && !dst2) {
                ts = new Timestamp(timeInMillis - (long)tcal.getTimeZone().getDSTSavings());
            } else if (!dst1 && dst2) {
                ts = new Timestamp(timeInMillis + (long)tcal2.getTimeZone().getDSTSavings());
            }
            int nanos = TIMESTAMP.getNanos(timestamptz, 7);
            ts.setNanos(nanos);
            Timestamp timestamp2 = ts;
            return timestamp2;
        }
    }

    public static Timestamp toTimestamp2(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        gmtCal.clear();
        gmtCal.set(1, year2);
        gmtCal.set(2, result2[2] - 1);
        gmtCal.set(5, result2[3]);
        gmtCal.set(11, result2[4] - 1);
        gmtCal.set(12, result2[5] - 1);
        gmtCal.set(13, result2[6] - 1);
        gmtCal.set(14, 0);
        long milliSec = gmtCal.getTime().getTime();
        Timestamp ts = new Timestamp(milliSec);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ts.setNanos(nanos);
        return ts;
    }

    static Timestamp toTimestampInSessionTimezone(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        gmtCal.clear();
        gmtCal.set(1, year2);
        gmtCal.set(2, result2[2] - 1);
        gmtCal.set(5, result2[3]);
        gmtCal.set(11, result2[4] - 1);
        gmtCal.set(12, result2[5] - 1);
        gmtCal.set(13, result2[6] - 1);
        gmtCal.set(14, 0);
        Calendar sesscal = TIMESTAMPLTZ.getSessCalendar(conn);
        TIMESTAMPLTZ.TimeZoneAdjust(conn, gmtCal, sesscal);
        long milliSec = sesscal.getTime().getTime();
        Timestamp ts = new Timestamp(milliSec);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ts.setNanos(nanos);
        return ts;
    }

    public static String toString(Connection conn, byte[] timestamptz) throws SQLException {
        OracleConnection intConn = conn.unwrap(OracleConnection.class);
        try (Monitor.CloseableLock lock = intConn.acquireCloseableLock();){
            Object regname;
            int[] result2 = new int[13];
            for (int i = 0; i < 13; ++i) {
                result2[i] = timestamptz[i] & 0xFF;
            }
            Calendar calUTC = (Calendar)CAL_GMT_US.clone();
            int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
            calUTC.set(1, year2);
            calUTC.set(2, result2[2] - 1);
            calUTC.set(5, result2[3]);
            calUTC.set(11, result2[4] - 1);
            calUTC.set(12, result2[5] - 1);
            calUTC.set(13, result2[6] - 1);
            calUTC.set(14, 0);
            if ((result2[11] & REGIONIDBIT) != 0) {
                int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
                TIMEZONETAB tzTab = intConn.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12]))) {
                    tzTab.updateTable(intConn, regionID);
                }
                regname = ZONEIDMAP.getRegion(regionID);
                int offset_gmt = tzTab.getOffset(calUTC, regionID);
                calUTC.add(14, offset_gmt);
            } else {
                int off_hour = result2[11] - OFFSET_HOUR;
                int off_minute = result2[12] - OFFSET_MINUTE;
                regname = off_hour + ":";
                regname = off_minute == 0 ? (String)regname + "00" : (String)regname + off_minute;
                calUTC.add(10, off_hour);
                calUTC.add(12, off_minute);
            }
            year2 = calUTC.get(1);
            if (calUTC.get(0) == 0) {
                year2 = -(year2 - 1);
            }
            int month2 = calUTC.get(2) + 1;
            int date = calUTC.get(5);
            int hour2 = calUTC.get(11);
            int minute2 = calUTC.get(12);
            int second2 = calUTC.get(13);
            int nanos = TIMESTAMP.getNanos(timestamptz, 7);
            String string = TIMESTAMPTZ.toString(year2, month2, date, hour2, minute2, second2, nanos, (String)regname);
            return string;
        }
    }

    public static OffsetDateTime toOffsetDateTime(Connection conn, byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        OffsetDateTime odtUTC = OffsetDateTime.of(year2, result2[2], result2[3], result2[4] - 1, result2[5] - 1, result2[6] - 1, nanos, ZoneOffset.UTC);
        ZoneOffset zOffset = null;
        if ((result2[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
            OracleConnection intConn = conn.unwrap(OracleConnection.class);
            TIMEZONETAB tzTab = intConn.getTIMEZONETAB();
            if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12]))) {
                tzTab.updateTable(intConn, regionID);
            }
            int offset_gmt = tzTab.getOffset(odtUTC.toInstant().toEpochMilli(), regionID);
            zOffset = ZoneOffset.ofTotalSeconds(offset_gmt / SECOND_MILLISECOND);
        } else {
            int off_hour = result2[11] - OFFSET_HOUR;
            int off_minute = result2[12] - OFFSET_MINUTE;
            zOffset = ZoneOffset.ofHoursMinutes(off_hour, off_minute);
        }
        OffsetDateTime retval = odtUTC.withOffsetSameInstant(zOffset);
        return retval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OffsetDateTime toOffsetDateTime(byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        OffsetDateTime odtUTC = OffsetDateTime.of(year2, result2[2], result2[3], result2[4] - 1, result2[5] - 1, result2[6] - 1, nanos, ZoneOffset.UTC);
        ZoneOffset zOffset = null;
        if ((result2[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
            String tzName = ZONEIDMAP.getRegion(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12]));
            ZoneId tzid = ZoneId.of(tzName);
            ZoneRules zRule = tzid.getRules();
            if (!zRule.isFixedOffset()) throw new SQLException("Timezone not supported: " + tzName);
            zOffset = zRule.getOffset(odtUTC.toInstant());
            return odtUTC.withOffsetSameInstant(zOffset);
        } else {
            int off_hour = result2[11] - OFFSET_HOUR;
            int off_minute = result2[12] - OFFSET_MINUTE;
            zOffset = ZoneOffset.ofHoursMinutes(off_hour, off_minute);
        }
        return odtUTC.withOffsetSameInstant(zOffset);
    }

    public static final String toString(int year2, int month2, int day2, int hours, int minutes, int seconds, int nanos, String regionName) {
        String stringRep = year2 + "-" + TIMESTAMPTZ.toStr(month2) + "-" + TIMESTAMPTZ.toStr(day2) + " " + TIMESTAMPTZ.toStr(hours) + ":" + TIMESTAMPTZ.toStr(minutes) + ":" + TIMESTAMPTZ.toStr(seconds);
        if (nanos >= 0) {
            int i;
            String nanoString = String.format("%09d", nanos);
            char[] nanoChars = nanoString.toCharArray();
            for (i = nanoChars.length; i > 1 && nanoChars[i - 1] == '0'; --i) {
            }
            nanoString = nanoString.substring(0, i);
            stringRep = stringRep + "." + nanoString;
        }
        if (regionName != null) {
            stringRep = stringRep + " " + regionName;
        }
        return stringRep;
    }

    private static final String toStr(int x) {
        return x < 10 ? "0" + x : Integer.toString(x);
    }

    public Timestamp timestampValue(Connection conn) throws SQLException {
        if (conn.unwrap(OracleConnection.class).getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toTimestamp2(conn, this.getBytes());
        }
        return TIMESTAMPTZ.toTimestamp(conn, this.getBytes());
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection conn, Date date) throws SQLException {
        return TIMESTAMPTZ.toBytes(conn, date, null);
    }

    public static byte[] toBytes(Connection conn, Date date, Calendar cal) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, cal);
        cal1.setTime(date);
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
        }
        Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result2);
        int year2 = TIMESTAMP.getOracleYear(cal2);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal2.get(2) + 1);
        result2[3] = (byte)cal2.get(5);
        result2[4] = (byte)(cal2.get(11) + 1);
        result2[5] = (byte)(cal2.get(12) + 1);
        result2[6] = (byte)(cal2.get(13) + 1);
        result2[7] = 0;
        result2[8] = 0;
        result2[9] = 0;
        result2[10] = 0;
        return result2;
    }

    public static byte[] toBytes(Connection conn, Time time) throws SQLException {
        return TIMESTAMPTZ.toBytes(conn, time, (Calendar)null);
    }

    public static byte[] toBytes(Connection conn, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, cal);
        cal1.setTime(time);
        int defaultYear = conn.unwrap(OracleConnection.class).getUse1900AsYearForTime() ? 1900 : 1970;
        cal1.set(1, defaultYear);
        cal1.set(2, 0);
        cal1.set(5, 1);
        Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result2);
        int year2 = TIMESTAMP.getOracleYear(cal2);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal2.get(2) + 1);
        result2[3] = (byte)cal2.get(5);
        result2[4] = (byte)(cal2.get(11) + 1);
        result2[5] = (byte)(cal2.get(12) + 1);
        result2[6] = (byte)(cal2.get(13) + 1);
        result2[7] = 0;
        result2[8] = 0;
        result2[9] = 0;
        result2[10] = 0;
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Connection conn, Time time, ZoneId tzid) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        gmtCal.setTime(time);
        int defaultYear = conn.unwrap(OracleConnection.class).getUse1900AsYearForTime() ? 1900 : 1970;
        gmtCal.set(1, defaultYear);
        gmtCal.set(2, 0);
        gmtCal.set(5, 1);
        Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, gmtCal, result2);
        int year2 = TIMESTAMP.getOracleYear(cal2);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal2.get(2) + 1);
        result2[3] = (byte)cal2.get(5);
        result2[4] = (byte)(cal2.get(11) + 1);
        result2[5] = (byte)(cal2.get(12) + 1);
        result2[6] = (byte)(cal2.get(13) + 1);
        result2[7] = 0;
        result2[8] = 0;
        result2[9] = 0;
        result2[10] = 0;
        String timeZone = tzid.getId();
        int regionId = ZONEIDMAP.getID(timeZone);
        if (!ZONEIDMAP.isValidID(regionId)) {
            ZoneRules zRule = tzid.getRules();
            if (!zRule.isFixedOffset()) throw new SQLException("Timezone not supported: " + timeZone);
            ZoneOffset zOff = zRule.getOffset(time.toInstant());
            int offset = zOff.getTotalSeconds();
            result2[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
            result2[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return result2;
        } else {
            result2[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
            result2[11] = (byte)(result2[11] | REGIONIDBIT);
            result2[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
        }
        return result2;
    }

    public static byte[] toBytes(Connection conn, Timestamp timestamp2) throws SQLException {
        return TIMESTAMPTZ.toBytes(conn, timestamp2, (Calendar)null);
    }

    public static byte[] toBytes(Connection conn, Timestamp timestamp2, Calendar cal) throws SQLException {
        if (timestamp2 == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, cal);
        cal1.setTime(timestamp2);
        Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result2);
        int year2 = TIMESTAMP.getOracleYear(cal2);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal2.get(2) + 1);
        result2[3] = (byte)cal2.get(5);
        result2[4] = (byte)(cal2.get(11) + 1);
        result2[5] = (byte)(cal2.get(12) + 1);
        result2[6] = (byte)(cal2.get(13) + 1);
        int nanos = timestamp2.getNanos();
        result2[7] = (byte)(nanos >> 24);
        result2[8] = (byte)(nanos >> 16 & 0xFF);
        result2[9] = (byte)(nanos >> 8 & 0xFF);
        result2[10] = (byte)(nanos & 0xFF);
        return result2;
    }

    public static byte[] toBytes(Connection conn, Timestamp timestamp2, ZoneId tzid) throws SQLException {
        return TIMESTAMPTZ.toBytes(timestamp2, tzid, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Timestamp timestamp2, ZoneId tzid, boolean useZoneCal) throws SQLException {
        byte[] result2 = new byte[13];
        Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
        if (useZoneCal) {
            Calendar zoneCal = Calendar.getInstance(TimeZone.getTimeZone(tzid));
            zoneCal.setTime(timestamp2);
            gmtCal.setTime(zoneCal.getTime());
        } else {
            gmtCal.setTime(timestamp2);
        }
        int year2 = TIMESTAMP.getOracleYear(gmtCal);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(gmtCal.get(2) + 1);
        result2[3] = (byte)gmtCal.get(5);
        result2[4] = (byte)(gmtCal.get(11) + 1);
        result2[5] = (byte)(gmtCal.get(12) + 1);
        result2[6] = (byte)(gmtCal.get(13) + 1);
        result2[7] = (byte)(timestamp2.getNanos() >> 24);
        result2[8] = (byte)(timestamp2.getNanos() >> 16 & 0xFF);
        result2[9] = (byte)(timestamp2.getNanos() >> 8 & 0xFF);
        result2[10] = (byte)(timestamp2.getNanos() & 0xFF);
        String timeZone = tzid.getId();
        int regionId = ZONEIDMAP.getID(timeZone);
        if (!ZONEIDMAP.isValidID(regionId)) {
            ZoneRules zRule = tzid.getRules();
            if (!zRule.isFixedOffset()) throw new SQLException("Timezone not supported: " + timeZone);
            ZoneOffset zOff = zRule.getOffset(timestamp2.toInstant());
            int offset = zOff.getTotalSeconds();
            result2[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
            result2[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return result2;
        } else {
            result2[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
            result2[11] = (byte)(result2[11] | REGIONIDBIT);
            result2[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
        }
        return result2;
    }

    public static byte[] toBytes(Connection conn, DATE date) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        Calendar cal = TIMESTAMPTZ.getWorkCal(conn, null);
        cal.setTime(DATE.toDate(date.toBytes()));
        Calendar cal1 = TIMESTAMPTZ.doCalWork(conn, cal, result2);
        int year2 = TIMESTAMP.getOracleYear(cal1);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal1.get(2) + 1);
        result2[3] = (byte)cal1.get(5);
        result2[4] = (byte)(cal1.get(11) + 1);
        result2[5] = (byte)(cal1.get(12) + 1);
        result2[6] = (byte)(cal1.get(13) + 1);
        result2[7] = 0;
        result2[8] = 0;
        result2[9] = 0;
        result2[10] = 0;
        return result2;
    }

    public static byte[] toBytes(Connection conn, String str) throws SQLException {
        byte[] result2;
        try {
            result2 = TIMESTAMPTZ.toBytes(conn, Timestamp.valueOf(str));
        }
        catch (IllegalArgumentException ia) {
            result2 = TIMESTAMPTZ.parseTimestampTz(conn, str);
        }
        return result2;
    }

    public static byte[] toBytes(Connection conn, String str, Calendar cal) throws SQLException {
        Calendar local = (Calendar)CAL_GMT_US.clone();
        Timestamp ts = TIMESTAMPTZ.parseTimestamp(str);
        local.setTime(ts);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.set(1, local.get(1));
        cal1.set(2, local.get(2));
        cal1.set(5, local.get(5));
        cal1.set(11, local.get(11));
        cal1.set(12, local.get(12));
        cal1.set(13, local.get(13));
        cal1.set(14, local.get(14));
        int nano = ts.getNanos();
        ts = new Timestamp(cal1.getTime().getTime());
        ts.setNanos(nano);
        return TIMESTAMPTZ.toBytes(conn, ts, cal);
    }

    @Override
    public String stringValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toString(conn, this.getBytes());
    }

    public static byte[] toBytes(OffsetDateTime odt) throws SQLException {
        if (odt == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        OffsetDateTime odtutc = odt.withOffsetSameInstant(ZoneOffset.UTC);
        int year2 = TIMESTAMP.getOracleYear(odtutc.getYear());
        int month2 = odtutc.getMonthValue();
        int date = odtutc.getDayOfMonth();
        int hour2 = odtutc.getHour();
        int minute2 = odtutc.getMinute();
        int second2 = odtutc.getSecond();
        int nanos = odtutc.getNano();
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)month2;
        result2[3] = (byte)date;
        result2[4] = (byte)(hour2 + 1);
        result2[5] = (byte)(minute2 + 1);
        result2[6] = (byte)(second2 + 1);
        result2[7] = (byte)(nanos >> 24);
        result2[8] = (byte)(nanos >> 16 & 0xFF);
        result2[9] = (byte)(nanos >> 8 & 0xFF);
        result2[10] = (byte)(nanos & 0xFF);
        int offset = odt.getOffset().getTotalSeconds();
        result2[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
        result2[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toBytes(ZonedDateTime zdt) throws SQLException {
        if (zdt == null) {
            return null;
        }
        byte[] result2 = new byte[13];
        OffsetDateTime odtutc = zdt.toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        int year2 = TIMESTAMP.getOracleYear(odtutc.getYear());
        int month2 = odtutc.getMonthValue();
        int date = odtutc.getDayOfMonth();
        int hour2 = odtutc.getHour();
        int minute2 = odtutc.getMinute();
        int second2 = odtutc.getSecond();
        int nanos = odtutc.getNano();
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)month2;
        result2[3] = (byte)date;
        result2[4] = (byte)(hour2 + 1);
        result2[5] = (byte)(minute2 + 1);
        result2[6] = (byte)(second2 + 1);
        result2[7] = (byte)(nanos >> 24);
        result2[8] = (byte)(nanos >> 16 & 0xFF);
        result2[9] = (byte)(nanos >> 8 & 0xFF);
        result2[10] = (byte)(nanos & 0xFF);
        ZoneId tzid = zdt.getZone();
        String timeZone = tzid.getId();
        int regionId = ZONEIDMAP.getID(timeZone);
        if (!ZONEIDMAP.isValidID(regionId)) {
            ZoneRules zRule = tzid.getRules();
            if (!zRule.isFixedOffset()) throw new SQLException("Timezone not supported: " + timeZone);
            ZoneOffset zOff = zRule.getOffset(zdt.toInstant());
            int offset = zOff.getTotalSeconds();
            result2[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
            result2[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return result2;
        } else {
            result2[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
            result2[11] = (byte)(result2[11] | REGIONIDBIT);
            result2[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
        }
        return result2;
    }

    public static byte[] toBytes(Connection conn, LocalDateTime ldt) throws SQLException {
        if (ldt == null) {
            return null;
        }
        ZoneId zId = null;
        zId = conn.unwrap(OracleConnection.class).getSessionZoneId();
        if (zId == null) {
            zId = ZoneId.systemDefault();
        }
        return TIMESTAMPTZ.toBytes(ZonedDateTime.of(ldt, zId));
    }

    public static byte[] toBytes(OffsetTime ot) throws SQLException {
        if (ot == null) {
            return null;
        }
        return TIMESTAMPTZ.toBytes(ot.atDate(LocalDate.of(1970, 1, 1)));
    }

    public OffsetDateTime offsetDateTimeValue() throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(this.getBytes());
    }

    public OffsetDateTime offsetDateTimeValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(conn, this.getBytes());
    }

    public ZonedDateTime zonedDateTimeValue() throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(this.getBytes());
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        return TIMESTAMPTZ.toLocalDateTime(this.getBytes());
    }

    public Date dateValue(Connection conn) throws SQLException {
        if (conn.unwrap(OracleConnection.class).getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toDate2(conn, this.getBytes());
        }
        return TIMESTAMPTZ.toDate(conn, this.getBytes());
    }

    public Time timeValue(Connection conn) throws SQLException {
        return TIMESTAMPTZ.toTime(conn, this.getBytes());
    }

    public TimeZone getTimeZone() throws SQLException {
        return TIMESTAMPTZ.getTimeZone(this.shareBytes());
    }

    private static TimeZone getTimeZone(byte[] bits) throws SQLException {
        Object tzname;
        if ((bits[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(bits[11]);
            tzname = ZONEIDMAP.getRegion(regionID += TIMESTAMPTZ.getLowOrderbits(bits[12]));
        } else {
            int off_hour = bits[11] - OFFSET_HOUR;
            int off_minute = bits[12] - OFFSET_MINUTE;
            String regname = off_hour + ":";
            regname = off_minute == 0 ? regname + "00" : regname + off_minute;
            tzname = "GMT" + (off_hour >= 0 ? "+" : "") + regname;
        }
        return TimeZone.getTimeZone((String)tzname);
    }

    public static TIMESTAMPTZ of(ZonedDateTime zdt) throws SQLException {
        return new TIMESTAMPTZ(TIMESTAMPTZ.toBytes(zdt));
    }

    public ZonedDateTime toZonedDateTime() throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(this.getBytes());
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        return TIMESTAMPTZ.toLocalDateTime(this.getBytes());
    }

    public static LocalDateTime toLocalDateTime(byte[] timestamptz) throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(timestamptz).toLocalDateTime();
    }

    public static ZonedDateTime toZonedDateTime(byte[] timestamptz) throws SQLException {
        int[] result2 = new int[13];
        for (int i = 0; i < 13; ++i) {
            result2[i] = timestamptz[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int nanos = TIMESTAMP.getNanos(timestamptz, 7);
        ZonedDateTime zdtUTC = ZonedDateTime.of(year2, result2[2], result2[3], result2[4] - 1, result2[5] - 1, result2[6] - 1, nanos, ZoneId.of("UTC"));
        ZoneId zId = null;
        if ((result2[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result2[11]);
            zId = ZoneId.of(ZONEIDMAP.getRegion(regionID += TIMESTAMPTZ.getLowOrderbits(result2[12])));
        } else {
            int off_hour = result2[11] - OFFSET_HOUR;
            int off_minute = result2[12] - OFFSET_MINUTE;
            zId = ZoneId.of(ZoneOffset.ofHoursMinutes(off_hour, off_minute).toString());
        }
        ZonedDateTime retval = zdtUTC.withZoneSameInstant(zId);
        return retval;
    }

    public OffsetTime toOffsetTime() throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(this.getBytes()).toOffsetTime();
    }

    public static TIMESTAMPTZ of(OffsetDateTime odt) throws SQLException {
        return new TIMESTAMPTZ(odt);
    }

    public static TIMESTAMPTZ of(Connection conn, LocalDateTime ldt) throws SQLException {
        return new TIMESTAMPTZ(conn, ldt);
    }

    public OffsetDateTime toOffsetDateTime() throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(this.getBytes());
    }

    private static Calendar getWorkCal(Connection conn, Calendar cal) {
        String locTimeZone;
        Calendar cal1 = cal == null ? ((locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone()) != null ? Calendar.getInstance(TimeZone.getTimeZone(locTimeZone)) : Calendar.getInstance()) : Calendar.getInstance(cal.getTimeZone());
        return cal1;
    }

    private static Calendar doCalWork(Connection conn, Calendar cal, byte[] result2) throws SQLException {
        OracleConnection intConn = conn.unwrap(OracleConnection.class);
        try (Monitor.CloseableLock lock = intConn.acquireCloseableLock();){
            int offset;
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result2[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result2[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionId = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionId)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        throw new SQLException("Timezone not supported: " + timeZone);
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result2[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result2[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionId)) {
                        tzTab.updateTable(conn, regionId);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset(cal, regionId, trans_data);
                    offset = trans_data.getOFFSET();
                    boolean overlap = cal.getTimeZone().inDaylightTime(cal.getTime());
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            throw new SQLException();
                        }
                    }
                    result2[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
                    result2[11] = (byte)(result2[11] | REGIONIDBIT);
                    result2[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
                }
            }
            Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
            gmtCal.set(0, cal.get(0));
            gmtCal.set(1, cal.get(1));
            gmtCal.set(2, cal.get(2));
            gmtCal.set(5, cal.get(5));
            gmtCal.set(11, cal.get(11));
            gmtCal.set(12, cal.get(12));
            gmtCal.set(13, cal.get(13));
            gmtCal.add(14, -1 * offset);
            Calendar calendar = gmtCal;
            return calendar;
        }
    }

    private static byte[] initTimestamptz() {
        byte[] tmp = new byte[13];
        Calendar cal = Calendar.getInstance();
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        tmp[7] = 0;
        tmp[8] = 0;
        tmp[9] = 0;
        tmp[10] = 0;
        String timeZone = cal.getTimeZone().getID();
        tmp[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
        tmp[11] = (byte)(tmp[11] | REGIONIDBIT);
        tmp[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
        return tmp;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.time.LocalDateTime") == 0 || cls.getName().compareTo("java.time.OffsetDateTime") == 0 || cls.getName().compareTo("java.time.OffsetTime") == 0 || cls.getName().compareTo("java.time.ZonedDateTime") == 0 || cls.getName().compareTo("java.lang.String") == 0;
    }

    private static Timestamp parseTimestamp(String timeStr) throws SQLException {
        int second2;
        String sTime;
        if (timeStr == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String sTemp = timeStr.trim();
        int spacePos = sTemp.indexOf(32);
        if (spacePos == -1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String sDate = sTemp.substring(0, spacePos).trim();
        if (sDate == null | (sTime = sTemp.substring(spacePos + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int posH1 = sDate.indexOf(45);
        int posH2 = sDate.indexOf(45, posH1 + 1);
        if (posH1 < 1 || posH2 < 1 || posH2 == sDate.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String sYear = sDate.substring(0, posH1);
        String sMonth = sDate.substring(posH1 + 1, posH2);
        String sDay = sDate.substring(posH2 + 1);
        if (sYear.length() != 4 || sMonth.length() != 2 || sDay.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int year2 = Integer.parseInt(sYear);
        int month2 = Integer.parseInt(sMonth) - 1;
        int day2 = Integer.parseInt(sDay);
        int posC1 = sTime.indexOf(58);
        int posC2 = sTime.indexOf(58, posC1 + 1);
        if (posC1 < 1 || posC2 < 1 || posC2 == sTime.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String sHour = sTime.substring(0, posC1);
        String sMinute = sTime.substring(posC1 + 1, posC2);
        if (sHour.length() != 2 || sMinute.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int hour2 = Integer.parseInt(sHour);
        int minute2 = Integer.parseInt(sMinute);
        int nanos = 0;
        int posDot = sTime.indexOf(46, posC2 + 1);
        if (posDot == -1) {
            second2 = Integer.parseInt(sTime.substring(posC2 + 1));
        } else if (posDot > 0 && posDot < sTime.length() - 1) {
            second2 = Integer.parseInt(sTime.substring(posC2 + 1, posDot));
            Object sNanos = sTime.substring(posDot + 1);
            String zeroes = "000000000";
            if (((String)sNanos).length() > zeroes.length() || !Character.isDigit(((String)sNanos).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            sNanos = (String)sNanos + zeroes.substring(0, zeroes.length() - ((String)sNanos).length());
            nanos = Integer.parseInt((String)sNanos);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        Calendar cal = (Calendar)CAL_GMT_US.clone();
        cal.set(1, year2);
        cal.set(2, month2);
        cal.set(5, day2);
        cal.set(11, hour2);
        cal.set(12, minute2);
        cal.set(13, second2);
        cal.set(14, 0);
        Timestamp result2 = new Timestamp(cal.getTime().getTime());
        result2.setNanos(nanos);
        return result2;
    }

    private static byte[] parseTimestampTz(Connection conn, String timeStr) throws SQLException {
        int second2;
        Object sTz;
        String sTime;
        if (timeStr == null) {
            throw (SQLException)DatabaseError.createSqlException(68, "The value is null.").fillInStackTrace();
        }
        String sTemp = timeStr.trim();
        int spacePos = sTemp.indexOf(32);
        if (spacePos == -1) {
            throw (SQLException)DatabaseError.createSqlException(68, "There is a space expected after date. (yyyy-mm-dd hh:mm:ss[.fffffffff])").fillInStackTrace();
        }
        String sDate = sTemp.substring(0, spacePos).trim();
        if (sDate == null | (sTime = sTemp.substring(spacePos + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68, "The value of date/time is null.").fillInStackTrace();
        }
        boolean nYear = false;
        if (sDate.charAt(0) == '-') {
            nYear = true;
            if (sDate.length() > 1) {
                sDate = sDate.substring(1);
            } else {
                throw (SQLException)DatabaseError.createSqlException(68, "The date value is invalid.").fillInStackTrace();
            }
        }
        int posH1 = sDate.indexOf(45);
        int posH2 = sDate.indexOf(45, posH1 + 1);
        if (posH1 < 1 || posH2 < 1 || posH2 == sDate.length()) {
            throw (SQLException)DatabaseError.createSqlException(68, "The date should have two hyphens and the expected format is yyyy-mm-dd.").fillInStackTrace();
        }
        String sYear = sDate.substring(0, posH1);
        String sMonth = sDate.substring(posH1 + 1, posH2);
        String sDay = sDate.substring(posH2 + 1);
        if (sYear.length() != 4 || sMonth.length() != 2 || sDay.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68, "The value of year/month/date is wrong. The format must be yyyy-mm-dd.").fillInStackTrace();
        }
        int year2 = Integer.parseInt(sYear);
        int month2 = Integer.parseInt(sMonth) - 1;
        int day2 = Integer.parseInt(sDay);
        if (nYear) {
            year2 = -year2;
        }
        int posC1 = sTime.indexOf(58);
        int posC2 = sTime.indexOf(58, posC1 + 1);
        spacePos = sTime.indexOf(32);
        if (spacePos != -1) {
            sTz = sTime.substring(spacePos + 1).trim();
            sTime = sTime.substring(0, spacePos).trim();
        } else {
            sTz = null;
        }
        if (posC1 < 1 || posC2 < 1 || posC2 == sTime.length()) {
            throw (SQLException)DatabaseError.createSqlException(68, "The format of time is expected to be hh:mm:ss[.fffffffff]").fillInStackTrace();
        }
        String sHour = sTime.substring(0, posC1);
        String sMinute = sTime.substring(posC1 + 1, posC2);
        if (sHour.length() != 2 || sMinute.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68, "The value of hour/minute is wrong. The format must be hh:mm:ss").fillInStackTrace();
        }
        int hour2 = Integer.parseInt(sHour);
        int minute2 = Integer.parseInt(sMinute);
        int nanos = 0;
        int posDot = sTime.indexOf(46, posC2 + 1);
        if (posDot == -1) {
            second2 = Integer.parseInt(sTime.substring(posC2 + 1));
        } else if (posDot > 0 && posDot < sTime.length() - 1) {
            second2 = Integer.parseInt(sTime.substring(posC2 + 1, posDot));
            Object sNanos = sTime.substring(posDot + 1);
            String zeroes = "000000000";
            if (((String)sNanos).length() > zeroes.length() || !Character.isDigit(((String)sNanos).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68, "The number of digits of nanoseconds is more than 9 or it has non-numeric character.").fillInStackTrace();
            }
            sNanos = (String)sNanos + zeroes.substring(0, zeroes.length() - ((String)sNanos).length());
            nanos = Integer.parseInt((String)sNanos);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68, "The number of digits of nanoseconds is zero.").fillInStackTrace();
        }
        Calendar cal2 = null;
        if (sTz != null) {
            char cTz = ((String)sTz).charAt(0);
            if (cTz == '-') {
                sTz = "GMT" + (String)sTz;
            } else if (Character.isDigit(cTz)) {
                sTz = "GMT+" + (String)sTz;
            }
            cal2 = Calendar.getInstance(TimeZone.getTimeZone((String)sTz));
        }
        Calendar cal = cal2 == null ? (Calendar)CAL_GMT_US.clone() : cal2;
        cal.set(1, year2);
        cal.set(2, month2);
        cal.set(5, day2);
        cal.set(11, hour2);
        cal.set(12, minute2);
        cal.set(13, second2);
        cal.set(14, 0);
        Timestamp result2 = new Timestamp(cal.getTime().getTime());
        result2.setNanos(nanos);
        return TIMESTAMPTZ.toBytes(conn, result2, cal2);
    }

    private static int setHighOrderbits(int ID2) {
        return (ID2 & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int ID2) {
        return (ID2 & 0x3F) << 2;
    }

    private static int getHighOrderbits(int hour2) {
        return (hour2 & 0x7F) << 6;
    }

    private static int getLowOrderbits(int minute2) {
        return (minute2 & 0xFC) >> 2;
    }

    static TIMEZONETAB getTIMEZONETAB(Connection conn) throws SQLException {
        OracleConnection oconn = conn.unwrap(OracleConnection.class);
        return oconn.getTIMEZONETAB();
    }
}

