/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleTimestamp;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class TIMESTAMP
extends Datum
implements Serializable,
OracleTimestamp {
    static final int CENTURY_DEFAULT = 119;
    static final int DECADE_DEFAULT = 100;
    static final int MONTH_DEFAULT = 1;
    static final int DAY_DEFAULT = 1;
    static final int DECADE_INIT = 170;
    static final int JAVA_YEAR = 1970;
    static final int JAVA_MONTH = 0;
    static final int JAVA_DATE = 1;
    public static final int SIZE_DATE = 7;
    public static final int SIZE_TIMESTAMP = 11;
    public static final int SIZE_TIMESTAMP_NOFRAC = 7;
    static final int SIZE_TIMESTAMPTZ = 13;
    static final int MINYEAR = -4712;
    static final int MAXYEAR = 9999;
    static final int JANMONTH = 1;
    static final int DECMONTH = 12;
    static final int MINDAYS = 1;
    static final int MAXDAYS = 31;
    static final int MINHOURS = 1;
    static final int MAXHOURS = 24;
    static final int MINMINUTES = 1;
    static final int MAXMINUTES = 60;
    static final int MINSECONDS = 1;
    static final int MAXSECONDS = 60;
    static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final long serialVersionUID = -7964732752952728545L;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(byte[] timestamp2) {
        super(timestamp2);
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp2) {
        super(TIMESTAMP.toBytes(timestamp2));
    }

    public TIMESTAMP(Timestamp timestamp2, Calendar cal) {
        super(TIMESTAMP.toBytes(timestamp2, cal));
    }

    public TIMESTAMP(DATE date) {
        super(TIMESTAMP.toBytes(date));
    }

    public static final int getNanos(byte[] buffer, int off) {
        int nanos = (buffer[off] & 0xFF) << 24;
        nanos |= (buffer[off + 1] & 0xFF) << 16;
        nanos |= (buffer[off + 2] & 0xFF) << 8;
        return nanos |= buffer[off + 3] & 0xFF & 0xFF;
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
    }

    public TIMESTAMP(OffsetDateTime odt) {
        super(TIMESTAMP.toBytes(odt));
    }

    public TIMESTAMP(ZonedDateTime zdt) {
        super(TIMESTAMP.toBytes(zdt));
    }

    public TIMESTAMP(LocalDateTime ldt) {
        super(TIMESTAMP.toBytes(ldt));
    }

    public TIMESTAMP(LocalTime lt) {
        super(TIMESTAMP.toBytes(lt));
    }

    public TIMESTAMP(LocalDate ld) {
        super(TIMESTAMP.toBytes(ld));
    }

    public TIMESTAMP(OffsetTime ot) {
        super(TIMESTAMP.toBytes(ot));
    }

    public static Date toDate(byte[] timestamp2) throws SQLException {
        int arrlength = timestamp2.length;
        int[] result2 = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp2.length; ++i) {
            result2[i] = timestamp2[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year2);
        cal.set(2, result2[2] - 1);
        cal.set(5, result2[3]);
        cal.set(11, result2[4] - 1);
        cal.set(12, result2[5] - 1);
        cal.set(13, result2[6] - 1);
        int tsmillis = 0;
        if (arrlength == 11) {
            tsmillis = TIMESTAMP.getNanos(timestamp2, 7) / 1000000;
        }
        cal.set(14, tsmillis);
        long millis = cal.getTimeInMillis();
        return new Date(millis);
    }

    public static Time toTime(byte[] timestamp2) throws SQLException {
        int hour2 = timestamp2[4] & 0xFF;
        int minute2 = timestamp2[5] & 0xFF;
        int second2 = timestamp2[6] & 0xFF;
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, hour2 - 1);
        cal.set(12, minute2 - 1);
        cal.set(13, second2 - 1);
        cal.set(14, 0);
        return new Time(cal.getTime().getTime());
    }

    public static Timestamp toTimestamp(byte[] timestamp2) throws SQLException {
        return TIMESTAMP.toTimestamp(timestamp2, null);
    }

    public static Timestamp toTimestamp(byte[] timestamp2, Calendar cal) throws SQLException {
        int arrlength = timestamp2.length;
        if (arrlength == 0) {
            return null;
        }
        int[] result2 = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp2.length; ++i) {
            result2[i] = timestamp2[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.set(1, year2);
        cal1.set(2, result2[2] - 1);
        cal1.set(5, result2[3]);
        cal1.set(11, result2[4] - 1);
        cal1.set(12, result2[5] - 1);
        cal1.set(13, result2[6] - 1);
        cal1.set(14, 0);
        long millis = cal1.getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp2, 7);
        }
        ts.setNanos(nanos);
        return ts;
    }

    public static DATE toDATE(byte[] timestamp2) throws SQLException {
        byte[] date = new byte[7];
        System.arraycopy(timestamp2, 0, date, 0, 7);
        return new DATE(date);
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    @Override
    public Timestamp timestampValue(Calendar cal) throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes(), cal);
    }

    public static String toString(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        int[] result2 = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result2[i] = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int month2 = result2[2];
        int day2 = result2[3];
        int hours = result2[4] - 1;
        int minutes = result2[5] - 1;
        int seconds = result2[6] - 1;
        int nanos = 0;
        if (bytes.length > 7) {
            nanos = TIMESTAMP.getNanos(bytes, 7);
        }
        return TIMESTAMPTZ.toString(year2, month2, day2, hours, minutes, seconds, nanos, null);
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int nanos = cal.get(14) * 1000000;
        byte[] result2 = new byte[nanos > 0 ? 11 : 7];
        result2[0] = 119;
        result2[1] = -86;
        result2[2] = 1;
        result2[3] = 1;
        result2[4] = (byte)(cal.get(11) + 1);
        result2[5] = (byte)(cal.get(12) + 1);
        result2[6] = (byte)(cal.get(13) + 1);
        if (nanos > 0) {
            result2[7] = (byte)(nanos >> 24);
            result2[8] = (byte)(nanos >> 16 & 0xFF);
            result2[9] = (byte)(nanos >> 8 & 0xFF);
            result2[10] = (byte)(nanos & 0xFF);
        }
        return result2;
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] result2 = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year2 = TIMESTAMP.getOracleYear(cal);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal.get(2) + 1);
        result2[3] = (byte)cal.get(5);
        if (!OracleDriver.getSystemPropertyDateZeroTime()) {
            result2[4] = (byte)(cal.get(11) + 1);
            result2[5] = (byte)(cal.get(12) + 1);
            result2[6] = (byte)(cal.get(13) + 1);
        } else {
            result2[4] = 1;
            result2[5] = 1;
            result2[6] = 1;
        }
        return result2;
    }

    public static byte[] toBytes(Timestamp timestamp2) {
        return TIMESTAMP.toBytes(timestamp2, null);
    }

    public static byte[] toBytes(Timestamp timestamp2, Calendar cal) {
        if (timestamp2 == null) {
            return null;
        }
        int nanos = timestamp2.getNanos();
        byte[] result2 = nanos == 0 ? new byte[7] : new byte[11];
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.setTime(timestamp2);
        int year2 = TIMESTAMP.getOracleYear(cal1);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal1.get(2) + 1);
        result2[3] = (byte)cal1.get(5);
        result2[4] = (byte)(cal1.get(11) + 1);
        result2[5] = (byte)(cal1.get(12) + 1);
        result2[6] = (byte)(cal1.get(13) + 1);
        if (nanos != 0) {
            result2[7] = (byte)(nanos >> 24);
            result2[8] = (byte)(nanos >> 16 & 0xFF);
            result2[9] = (byte)(nanos >> 8 & 0xFF);
            result2[10] = (byte)(nanos & 0xFF);
        }
        return result2;
    }

    public static byte[] toBytes(DATE date) {
        if (date == null) {
            return null;
        }
        byte[] result2 = new byte[7];
        System.arraycopy(date.getBytes(), 0, result2, 0, 7);
        return result2;
    }

    public static byte[] toBytes(String str) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(str));
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls == Date.class || cls == Time.class || cls == Timestamp.class || cls == LocalDateTime.class || cls == LocalDate.class || cls == LocalTime.class || cls == String.class;
    }

    public static TIMESTAMP TimeZoneConvert(Connection conn, TIMESTAMP tstamp, TimeZone tz1, TimeZone tz2) throws SQLException {
        byte[] timestamp2 = tstamp.getBytes();
        int arrlength = timestamp2.length;
        int[] result2 = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < arrlength; ++i) {
            result2[i] = timestamp2[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int month2 = result2[2] - 1;
        int day2 = result2[3];
        int hours = result2[4] - 1;
        int minutes = result2[5] - 1;
        int seconds = result2[6] - 1;
        Calendar cal1 = Calendar.getInstance(tz1);
        cal1.set(1, year2);
        cal1.set(2, month2);
        cal1.set(5, day2);
        cal1.set(11, hours);
        cal1.set(12, minutes);
        cal1.set(13, seconds);
        cal1.set(14, 0);
        long millis = cal1.getTimeInMillis();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp2, 7);
        }
        ts.setNanos(nanos);
        Calendar cal2 = Calendar.getInstance(tz2);
        return new TIMESTAMP(ts, cal2);
    }

    @Override
    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    public static int getOracleYear(Calendar cal) {
        int year2 = cal.get(1);
        if (cal.get(0) == 0) {
            year2 = -year2;
        }
        if (year2 < -4712 || year2 > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        return year2;
    }

    public static int getOracleYear(int jYear) {
        return jYear <= 0 ? jYear - 1 : jYear;
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMP.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMP.toTime(this.getBytes());
    }

    public static int getJavaYear(int cent, int decade) {
        int year2 = (cent - 100) * 100 + (decade - 100);
        if (year2 < 0) {
            ++year2;
        }
        return year2;
    }

    public static TIMESTAMP of(LocalDateTime ldt) throws SQLException {
        return new TIMESTAMP(ldt);
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        return TIMESTAMP.toLocalDateTime(this.getBytes());
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        return TIMESTAMP.toLocalDateTime(this.getBytes());
    }

    public static TIMESTAMP of(OffsetDateTime odt) {
        return new TIMESTAMP(odt);
    }

    public static LocalDateTime toLocalDateTime(byte[] timestamp2) throws SQLException {
        int arrlength = timestamp2.length;
        int[] result2 = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp2.length; ++i) {
            result2[i] = timestamp2[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp2, 7);
        }
        LocalDateTime ldt = LocalDateTime.of(year2, result2[2], result2[3], result2[4] - 1, result2[5] - 1, result2[6] - 1, nanos);
        return ldt;
    }

    public static LocalTime toLocalTime(byte[] timestamp2) throws SQLException {
        return TIMESTAMP.toLocalDateTime(timestamp2).toLocalTime();
    }

    public static LocalDate toLocalDate(byte[] timestamp2) throws SQLException {
        return TIMESTAMP.toLocalDateTime(timestamp2).toLocalDate();
    }

    public static TIMESTAMP of(ZonedDateTime zdt) {
        return new TIMESTAMP(zdt);
    }

    public static TIMESTAMP of(OffsetTime ot) {
        return new TIMESTAMP(ot);
    }

    public static TIMESTAMP of(LocalTime lt) throws SQLException {
        return new TIMESTAMP(lt);
    }

    public LocalTime toLocalTime() throws SQLException {
        return TIMESTAMP.toLocalTime(this.getBytes());
    }

    public LocalTime localTimeValue() throws SQLException {
        return TIMESTAMP.toLocalTime(this.getBytes());
    }

    public static TIMESTAMP of(LocalDate ld) throws SQLException {
        return new TIMESTAMP(ld);
    }

    public LocalDate toLocalDate() throws SQLException {
        return TIMESTAMP.toLocalDate(this.getBytes());
    }

    public LocalDate localDateValue() throws SQLException {
        return TIMESTAMP.toLocalDate(this.getBytes());
    }

    public static byte[] toBytes(OffsetDateTime odt) {
        if (odt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(odt.toLocalDateTime());
    }

    public static byte[] toBytes(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(zdt.toLocalDateTime());
    }

    public static byte[] toBytes(OffsetTime ot) {
        if (ot == null) {
            return null;
        }
        return TIMESTAMP.toBytes(ot.toLocalTime().atDate(LocalDate.of(1970, 1, 1)));
    }

    public static byte[] toBytes(LocalDate ld) {
        if (ld == null) {
            return null;
        }
        return TIMESTAMP.toBytes(ld.atTime(0, 0, 0));
    }

    public static byte[] toBytes(LocalDateTime ldt) {
        byte[] result2;
        if (ldt == null) {
            return null;
        }
        int year2 = TIMESTAMP.getOracleYear(ldt.getYear());
        int month2 = ldt.getMonthValue();
        int date = ldt.getDayOfMonth();
        int hour2 = ldt.getHour();
        int minute2 = ldt.getMinute();
        int second2 = ldt.getSecond();
        int nanos = ldt.getNano();
        if (nanos != 0) {
            result2 = new byte[11];
            result2[7] = (byte)(nanos >> 24);
            result2[8] = (byte)(nanos >> 16 & 0xFF);
            result2[9] = (byte)(nanos >> 8 & 0xFF);
            result2[10] = (byte)(nanos & 0xFF);
        } else {
            result2 = new byte[]{(byte)(year2 / 100 + 100), (byte)(year2 % 100 + 100), (byte)month2, (byte)date, (byte)(hour2 + 1), (byte)(minute2 + 1), (byte)(second2 + 1)};
        }
        return result2;
    }

    public static byte[] toBytes(LocalTime lt) {
        if (lt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(lt.atDate(LocalDate.of(1970, 1, 1)));
    }

    private static byte[] initTimestamp() {
        byte[] tmp = new byte[11];
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        return tmp;
    }

    private boolean isLeapYear(int y) {
        return y % 4 == 0 && (y <= 1582 ? y != -4712 : y % 100 != 0 || y % 400 == 0);
    }

    private boolean isValid() {
        byte[] ts = this.getBytes();
        if (ts.length != 11 && ts.length != 7) {
            return false;
        }
        int year2 = ((ts[0] & 0xFF) - 100) * 100 + ((ts[1] & 0xFF) - 100);
        if (year2 < -4712 || year2 > 9999) {
            return false;
        }
        if (year2 == 0) {
            return false;
        }
        int month2 = ts[2] & 0xFF;
        if (month2 < 1 || month2 > 12) {
            return false;
        }
        int day2 = ts[3] & 0xFF;
        if (day2 < 1 || day2 > 31) {
            return false;
        }
        if (!(day2 <= daysInMonth[month2 - 1] || this.isLeapYear(year2) && month2 == 2 && day2 == 29)) {
            return false;
        }
        if (year2 == 1582 && month2 == 10 && day2 >= 5 && day2 < 15) {
            return false;
        }
        int hour2 = ts[4] & 0xFF;
        if (hour2 < 1 || hour2 > 24) {
            return false;
        }
        int minutes = ts[5] & 0xFF;
        if (minutes < 1 || minutes > 60) {
            return false;
        }
        int seconds = ts[6] & 0xFF;
        return seconds >= 1 && seconds <= 60;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }
}

