/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.sql.ARRAY;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OracleSQLOutput;
import oracle.sql.StructDescriptor;

public class STRUCT
extends DatumWithConnection
implements OracleStruct,
OracleConcreteProxy {
    protected oracle.jdbc.driver.OracleStruct target = null;
    private OracleStruct ojiOracleStruct = null;

    public oracle.jdbc.driver.OracleStruct getTarget() {
        return this.target;
    }

    private void setTarget(oracle.jdbc.OracleConnection conn, oracle.jdbc.driver.OracleStruct s2, String typeName, Object[] attributes, boolean recordConstructor) {
        Class<TxnReplayableStruct> proxyClass = TxnReplayableStruct.class;
        this.ojiOracleStruct = ConcreteProxyUtil.getProxyObject(conn, s2, proxyClass, this);
        this.target = s2;
        this.setShareBytes(this.target.shareBytes());
        this.targetDatumWithConnection = this.target;
        this.targetDatum = this.target;
        if (this.ojiOracleStruct != null) {
            try {
                Object proxyObj = ConcreteProxyUtil.checkAndGetACProxyConnection(conn);
                if (proxyObj != null && recordConstructor) {
                    ((TxnReplayableConnection)proxyObj).STRUCTConstructorRecording(typeName, attributes, this);
                }
            }
            catch (SQLException sqe) {
                CommonDiagnosable.getInstance().debug(Level.FINE, SecurityLabel.UNKNOWN, "oracle/sql/STRUCT", "setTarget", sqe.getMessage(), null, null);
            }
            this.ojiOracleDatumWithConnection = this.ojiOracleStruct;
        } else {
            this.ojiOracleStruct = this.target;
        }
    }

    public void createAndSetShardingLobProxy(Class proxyClass, Object creator) {
        this.ojiOracleStruct = ConcreteProxyUtil.getProxyObject(this.ojiOracleStruct, proxyClass, creator);
        this.ojiOracleDatumWithConnection = this.ojiOracleStruct;
    }

    @Override
    public TxnReplayableBase getConcreteProxy() {
        if (this.ojiOracleStruct instanceof TxnReplayableBase) {
            return (TxnReplayableBase)((Object)this.ojiOracleStruct);
        }
        return null;
    }

    public STRUCT(StructDescriptor type, Connection conn, Object[] attributes) throws SQLException {
        oracle.jdbc.OracleConnection delegateConn = null;
        String typeNameByUser = type != null ? type.typeNameByUser : null;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate((oracle.jdbc.OracleConnection)conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        oracle.jdbc.driver.OracleStruct s2 = new oracle.jdbc.driver.OracleStruct(type, conn, attributes);
        this.setTarget((oracle.jdbc.OracleConnection)conn, s2, typeNameByUser, attributes, delegateConn != null);
    }

    public STRUCT(StructDescriptor type, Connection conn, Map attrList) throws SQLException {
        oracle.jdbc.OracleConnection delegateConn = null;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate((oracle.jdbc.OracleConnection)conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        oracle.jdbc.driver.OracleStruct s2 = new oracle.jdbc.driver.OracleStruct(type, conn, attrList);
        this.setTarget((oracle.jdbc.OracleConnection)conn, s2, null, null, delegateConn != null);
    }

    public STRUCT(StructDescriptor type, byte[] elements, Connection conn) throws SQLException {
        oracle.jdbc.OracleConnection delegateConn = null;
        delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate((oracle.jdbc.OracleConnection)conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        oracle.jdbc.driver.OracleStruct s2 = new oracle.jdbc.driver.OracleStruct(type, elements, conn);
        this.setTarget((oracle.jdbc.OracleConnection)conn, s2, null, null, delegateConn != null);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.ojiOracleStruct.getSQLTypeName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.ojiOracleStruct.getAttributes();
    }

    public Object[] getAttributes(Map map2) throws SQLException {
        return this.ojiOracleStruct.getAttributes(map2);
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.ojiOracleStruct.getOracleMetaData();
    }

    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        return this.ojiOracleStruct.getDescriptor();
    }

    @Override
    public void setDescriptor(StructDescriptor desc) {
        this.ojiOracleStruct.setDescriptor(desc);
    }

    @Override
    public Datum[] getOracleAttributes() throws SQLException {
        return this.ojiOracleStruct.getOracleAttributes();
    }

    public Map getMap() {
        return this.ojiOracleStruct.getMap();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        return this.ojiOracleStruct.toBytes();
    }

    @Override
    public void setDatumArray(Datum[] darray) {
        this.ojiOracleStruct.setDatumArray(darray);
    }

    @Override
    public Datum[] getDatumArray() {
        return this.ojiOracleStruct.getDatumArray();
    }

    @Override
    public void setNullDatumArray() {
        this.ojiOracleStruct.setNullDatumArray();
    }

    @Override
    public Object[] getObjectArray() {
        return this.ojiOracleStruct.getObjectArray();
    }

    @Override
    public void setNullObjectArray() {
        this.ojiOracleStruct.setNullObjectArray();
    }

    @Override
    public void setObjArray(Object[] oarray) throws SQLException {
        this.ojiOracleStruct.setObjArray(oarray);
    }

    public static STRUCT toSTRUCT(Object obj, oracle.jdbc.OracleConnection conn) throws SQLException {
        STRUCT s2 = null;
        if (obj != null) {
            if (obj instanceof STRUCT) {
                s2 = (STRUCT)obj;
            } else if (obj instanceof ORAData) {
                s2 = (STRUCT)((ORAData)obj).toDatum(conn);
            } else if (obj instanceof OracleData) {
                Object jdbcObject = ((OracleData)obj).toJDBCObject(conn);
                if (jdbcObject instanceof _Proxy_) {
                    final _Proxy_ proxiedJDBCObject = (_Proxy_)jdbcObject;
                    jdbcObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ProxyFactory.extractDelegate(proxiedJDBCObject);
                        }
                    });
                }
                s2 = (STRUCT)jdbcObject;
            } else if (obj instanceof CustomDatum) {
                s2 = (STRUCT)((OracleConnection)conn).toDatum((CustomDatum)obj);
            } else if (obj instanceof SQLData) {
                SQLData sqldataObj = (SQLData)obj;
                StructDescriptor desc = StructDescriptor.createDescriptor(sqldataObj.getSQLTypeName(), (Connection)conn);
                SQLOutput sqlOutput = desc.toJdbc2SQLOutput();
                sqldataObj.writeSQL(sqlOutput);
                s2 = ((OracleSQLOutput)sqlOutput).getSTRUCT();
            } else {
                throw (SQLException)DatabaseError.createSqlException(59, obj).fillInStackTrace();
            }
        }
        return s2;
    }

    @Override
    public Object toJdbc() throws SQLException {
        Map<String, Class<?>> map2 = this.ojiOracleStruct.getMap();
        return this.toJdbc((Map)map2);
    }

    public Object toJdbc(Map map2) throws SQLException {
        Class c;
        Object jdbcObject = this;
        if (map2 != null && (c = this.ojiOracleStruct.getDescriptor().getClass(map2)) != null) {
            jdbcObject = this.toClass(c, map2);
        }
        return jdbcObject;
    }

    public Object toClass(Class clazz) throws SQLException {
        return this.toClass(clazz, (Map)this.target.getMap());
    }

    public Object toClass(Class clazz, Map map2) throws SQLException {
        Object obj;
        block8: {
            obj = null;
            try {
                if (clazz == null || clazz == STRUCT.class || clazz == Struct.class || clazz == oracle.jdbc.OracleStruct.class || clazz == OracleStruct.class) {
                    obj = this;
                    break block8;
                }
                Object i = clazz.newInstance();
                if (i instanceof SQLData) {
                    ((SQLData)i).readSQL(this.target.getDescriptor().toJdbc2SQLInput(this, this, map2), this.target.getDescriptor().getName());
                    obj = i;
                    break block8;
                }
                if (i instanceof ORADataFactory) {
                    ORADataFactory f2 = (ORADataFactory)i;
                    obj = f2.create(this, 2002);
                    break block8;
                }
                if (i instanceof OracleDataFactory) {
                    OracleDataFactory f3 = (OracleDataFactory)i;
                    obj = f3.create(this, 2002);
                    break block8;
                }
                if (i instanceof CustomDatumFactory) {
                    CustomDatumFactory f4 = (CustomDatumFactory)i;
                    obj = f4.create(this, 2002);
                    break block8;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.target.getDescriptor().getName()).fillInStackTrace();
            }
            catch (InstantiationException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage()).fillInStackTrace();
            }
            catch (IllegalAccessException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage()).fillInStackTrace();
            }
        }
        return obj;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return this.ojiOracleStruct.isConvertibleTo(jClass);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return this.ojiOracleStruct.makeJdbcArray(arraySize);
    }

    @Override
    public void setAutoBuffering(boolean enable) throws SQLException {
        this.ojiOracleStruct.setAutoBuffering(enable);
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        return this.ojiOracleStruct.getAutoBuffering();
    }

    @Override
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        this.ojiOracleStruct.setImage(image, offset, length);
    }

    @Override
    public void setImageLength(long length) throws SQLException {
        this.ojiOracleStruct.setImageLength(length);
    }

    @Override
    public long getImageOffset() {
        return this.ojiOracleStruct.getImageOffset();
    }

    @Override
    public long getImageLength() {
        return this.ojiOracleStruct.getImageLength();
    }

    public CustomDatumFactory getFactory(Hashtable map2, String classname) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getFactory(map2, classname);
    }

    public ORADataFactory getORADataFactory(Hashtable map2, String classname) throws SQLException {
        return this.ojiOracleStruct.getORADataFactory(map2, classname);
    }

    public OracleDataFactory getOracleDataFactory(Hashtable map2, String classname) throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.getOracleDataFactory(map2, classname);
    }

    public String debugString() {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return this.target.debugString();
    }

    @Override
    public boolean isInHierarchyOf(String checkThisName) throws SQLException {
        return this.ojiOracleStruct.isInHierarchyOf(checkThisName);
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return this.ojiOracleStruct.getJavaSqlConnection();
    }

    public String dump() throws SQLException {
        ConcreteProxyUtil.checkAndDisableReplay(this);
        return STRUCT.dump(this);
    }

    public static String dump(Object o) throws SQLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        STRUCT.dump(o, pw);
        return sw.getBuffer().substring(0);
    }

    public static void dump(Object o, PrintStream ps) throws SQLException {
        STRUCT.dump(o, new PrintWriter(ps, true));
    }

    public static void dump(Object o, PrintWriter pw) throws SQLException {
        STRUCT.dump(o, pw, 0);
    }

    static void dump(Object o, PrintWriter pw, int indent) throws SQLException {
        if (o instanceof STRUCT) {
            STRUCT.dump((STRUCT)o, pw, indent);
            return;
        }
        if (o instanceof ARRAY) {
            ARRAY.dump((ARRAY)o, pw, indent);
            return;
        }
        if (o == null) {
            pw.println("null");
        } else {
            pw.println(o.toString());
        }
    }

    static void dump(OracleStruct x, PrintWriter pw, int indent) throws SQLException {
        int i;
        StructDescriptor desc = x.getDescriptor();
        ResultSetMetaData md = desc.getMetaData();
        for (i = 0; i < indent; ++i) {
            pw.print(' ');
        }
        pw.println("name = " + desc.getName());
        for (i = 0; i < indent; ++i) {
            pw.print(' ');
        }
        int length = desc.getLength();
        pw.println("length = " + length);
        Object[] attr = x.getAttributes();
        for (i = 0; i < length; ++i) {
            for (int j = 0; j < indent; ++j) {
                pw.print(' ');
            }
            pw.print(md.getColumnName(i + 1) + " = ");
            STRUCT.dump(attr[i], pw, indent + 1);
        }
    }

    @Override
    public void setACProxy(Object w) {
        this.ojiOracleStruct.setACProxy(w);
    }

    @Override
    public Object getACProxy() {
        return this.ojiOracleStruct.getACProxy();
    }
}

