/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class SQLName
implements Serializable,
Diagnosable {
    private static final String CLASS_NAME = SQLName.class.getName();
    static boolean DEBUG = false;
    static boolean s_parseAllFormat = false;
    static final long serialVersionUID = 2266340348729491526L;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z][\\.\\w]*");
    private static final Predicate<String> NEED_TO_QUOTE = s2 -> !IDENTIFIER_PATTERN.matcher((CharSequence)s2).matches();
    String name;
    String schema;
    String simple;
    int version;
    boolean synonym;

    protected SQLName() {
    }

    public SQLName(String name, oracle.jdbc.OracleConnection connection) throws SQLException {
        this.init(name, connection);
        this.version = 2;
        this.synonym = false;
    }

    public SQLName(String schema, String typename, oracle.jdbc.OracleConnection connection) throws SQLException {
        this.schema = SQLName.replaceQuotes(schema);
        this.simple = SQLName.replaceQuotes(typename);
        this.name = SQLName.getTypeName(schema, this.simple);
        this.version = 2;
        this.synonym = false;
    }

    public static final String getTypeName(String schemaName, String sqlName) {
        String typeName = null;
        typeName = NEED_TO_QUOTE.test(schemaName) || NEED_TO_QUOTE.test(sqlName) ? SQLName.getQuotedString(schemaName) + "." + SQLName.getQuotedString(sqlName) : schemaName + "." + sqlName;
        return typeName;
    }

    private static String getQuotedString(String str) {
        if (str != null && !((String)str).startsWith("\"")) {
            str = "\"" + (String)str + "\"";
        }
        return str;
    }

    private void init(String sql_name, oracle.jdbc.OracleConnection conn) throws SQLException {
        String[] _schema = new String[1];
        String[] _type = new String[1];
        if (SQLName.parse(sql_name, _schema, _type, true)) {
            this.schema = SQLName.replaceQuotes(_schema[0]);
            this.simple = SQLName.replaceQuotes(_type[0]);
        } else {
            this.schema = SQLName.replaceQuotes(conn.physicalConnectionWithin().getDefaultSchemaNameForNamedTypes());
            this.simple = SQLName.replaceQuotes(_type[0]);
        }
        this.name = SQLName.getTypeName(this.schema, this.simple);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "init", "sql_name={0}, schema{1}, simple={2}, name={3}", (String)null, null, (Object)sql_name, (Object)this.schema, (Object)this.simple, (Object)this.name);
    }

    public String getName() throws SQLException {
        return this.name;
    }

    public String getSchema() throws SQLException {
        return this.schema;
    }

    public String getSimpleName() throws SQLException {
        return this.simple;
    }

    public int getVersion() throws SQLException {
        return this.version;
    }

    public static boolean parse(String sql_name, String[] schema_name, String[] type_name) throws SQLException {
        return SQLName.parse(sql_name, schema_name, type_name, s_parseAllFormat);
    }

    public static boolean parse(String sql_name, String[] schema_name, String[] type_name, boolean l_parseAllFormat) throws SQLException {
        if (sql_name == null) {
            return false;
        }
        if (schema_name == null || schema_name.length < 1 || type_name == null || type_name.length < 1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        if (!l_parseAllFormat) {
            int idxDot = sql_name.indexOf(".");
            if (idxDot < 0) {
                type_name[0] = sql_name;
                return false;
            }
            schema_name[0] = sql_name.substring(0, idxDot);
            type_name[0] = sql_name.substring(idxDot + 1);
            return true;
        }
        int length = sql_name.length();
        int idxOpenQuote = sql_name.indexOf("\"");
        int idxCloseQuote = sql_name.indexOf("\"", idxOpenQuote + 1);
        int idxDot = -1;
        if (idxOpenQuote < 0) {
            idxDot = sql_name.indexOf(".");
            if (idxDot < 0) {
                type_name[0] = sql_name;
                return false;
            }
            schema_name[0] = sql_name.substring(0, idxDot);
            type_name[0] = sql_name.substring(idxDot + 1);
            return true;
        }
        if (idxOpenQuote == 0) {
            if (idxCloseQuote == length - 1) {
                type_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
                return false;
            }
            idxDot = sql_name.indexOf(".", idxCloseQuote);
            schema_name[0] = sql_name.substring(idxOpenQuote + 1, idxCloseQuote);
            idxOpenQuote = sql_name.indexOf("\"", idxDot);
            idxCloseQuote = sql_name.indexOf("\"", idxOpenQuote + 1);
            if (idxOpenQuote < 0) {
                type_name[0] = sql_name.substring(idxDot + 1);
                return true;
            }
            int idxDot2 = sql_name.indexOf(".", idxDot + 1);
            type_name[0] = idxDot2 == -1 ? sql_name.substring(idxOpenQuote + 1, idxCloseQuote) : SQLName.replaceQuotes(sql_name.substring(idxDot + 1));
            return true;
        }
        idxDot = sql_name.indexOf(".");
        schema_name[0] = sql_name.substring(0, idxDot);
        int idxDot2 = sql_name.indexOf(".", idxDot + 1);
        type_name[0] = idxDot2 == -1 ? sql_name.substring(idxOpenQuote + 1, idxCloseQuote) : SQLName.replaceQuotes(sql_name.substring(idxDot + 1));
        return true;
    }

    public static void setHandleDoubleQuote(boolean enable) throws SQLException {
        s_parseAllFormat = enable;
    }

    public static boolean getHandleDoubleQuote() throws SQLException {
        return s_parseAllFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLName)) {
            return false;
        }
        return ((SQLName)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name == null ? -1 : this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.schema);
        out.writeUTF(this.simple);
        out.writeInt(this.version);
        out.writeBoolean(this.synonym);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.schema = in.readUTF();
        this.simple = in.readUTF();
        this.version = in.readInt();
        this.synonym = in.readBoolean();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static String replaceQuotes(String str) {
        if (str.indexOf(34) == -1) {
            return str;
        }
        char[] inName = str.toCharArray();
        char[] outName = new char[inName.length];
        int j = 0;
        for (int i = 0; i < inName.length; ++i) {
            if (inName[i] == '\"') continue;
            outName[j++] = inName[i];
        }
        return String.valueOf(outName, 0, j);
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

