/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDate;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

public class DATE
extends Datum
implements OracleDate {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;

    public DATE() {
        super(DATE._initDate());
    }

    public DATE(byte[] date) {
        super(date);
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
    }

    public DATE(Timestamp timestamp2) {
        super(DATE.toBytes(timestamp2));
    }

    public DATE(Date date, Calendar cal) {
        super(DATE.toBytes(date, cal));
    }

    public DATE(Time time, Calendar cal) {
        super(DATE.toBytes(time, cal));
    }

    public DATE(Timestamp timestamp2, Calendar cal) {
        super(DATE.toBytes(timestamp2, cal));
    }

    public DATE(String str) {
        super(DATE.toBytes(str));
    }

    public DATE(String str, boolean lenient) throws ParseException {
        super(DATE.toBytes(str));
        if (!lenient) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            java.util.Date date = simpleDateFormat.parse(str);
        }
    }

    public DATE(String str, Calendar cal) {
        super(DATE.toBytes(str, cal));
    }

    public DATE(Object obj) throws SQLException {
        if (obj instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)obj));
        } else if (obj instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)obj));
        } else if (obj instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)obj));
        } else if (obj instanceof String) {
            this.setShareBytes(DATE.toBytes((String)obj));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(Object obj, Calendar cal) throws SQLException {
        if (obj instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)obj, cal));
        } else if (obj instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)obj, cal));
        } else if (obj instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)obj, cal));
        } else if (obj instanceof String) {
            this.setShareBytes(DATE.toBytes((String)obj, cal));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(LocalDate ld) throws SQLException {
        super(DATE.toBytes(ld));
    }

    public DATE(LocalDateTime ldt) throws SQLException {
        super(DATE.toBytes(ldt));
    }

    public DATE(LocalTime lt) throws SQLException {
        super(DATE.toBytes(lt));
    }

    public DATE(OffsetDateTime odt) throws SQLException {
        super(DATE.toBytes(odt));
    }

    public DATE(OffsetTime ot) throws SQLException {
        super(DATE.toBytes(ot));
    }

    public DATE(ZonedDateTime zdt) throws SQLException {
        super(DATE.toBytes(zdt));
    }

    public static Date toDate(byte[] date) {
        return DATE.toDate(date, null);
    }

    public static Time toTime(byte[] date) {
        return DATE.toTime(date, null);
    }

    public static Timestamp toTimestamp(byte[] date) {
        return DATE.toTimestamp(date, null);
    }

    public static Date toDate(byte[] date, Calendar cal) {
        int[] result2 = new int[7];
        for (int i = 0; i < 7; ++i) {
            result2[i] = date[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.set(1, year2);
        cal1.set(2, result2[2] - 1);
        cal1.set(5, result2[3]);
        if (!OracleDriver.getSystemPropertyDateZeroTimeExtra()) {
            cal1.set(11, result2[4] - 1);
            cal1.set(12, result2[5] - 1);
            cal1.set(13, result2[6] - 1);
        } else {
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
        }
        cal1.set(14, 0);
        Date newDate = new Date(cal1.getTime().getTime());
        return newDate;
    }

    public static Time toTime(byte[] date, Calendar cal) {
        int hour2 = date[4] & 0xFF;
        int minute2 = date[5] & 0xFF;
        int second2 = date[6] & 0xFF;
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.set(1, 1970);
        cal1.set(2, 0);
        cal1.set(5, 1);
        cal1.set(11, hour2 - 1);
        cal1.set(12, minute2 - 1);
        cal1.set(13, second2 - 1);
        cal1.set(14, 0);
        return new Time(cal1.getTime().getTime());
    }

    public static Timestamp toTimestamp(byte[] date, Calendar cal) {
        int[] result2 = new int[7];
        for (int i = 0; i < 7; ++i) {
            result2[i] = date[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.set(1, year2);
        cal1.set(2, result2[2] - 1);
        cal1.set(5, result2[3]);
        cal1.set(11, result2[4] - 1);
        cal1.set(12, result2[5] - 1);
        cal1.set(13, result2[6] - 1);
        cal1.set(14, 0);
        Timestamp newTimestamp = new Timestamp(cal1.getTime().getTime());
        return newTimestamp;
    }

    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new String();
        }
        int[] result2 = new int[7];
        for (int i = 0; i < 7; ++i) {
            result2[i] = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        int month2 = result2[2];
        int day2 = result2[3];
        int hours = result2[4] - 1;
        int minutes = result2[5] - 1;
        int seconds = result2[6] - 1;
        int nanos = -1;
        String sResult = TIMESTAMPTZ.toString(year2, month2, day2, hours, minutes, seconds, -1, null);
        return sResult;
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Date date) {
        return DATE.toBytes(date, null);
    }

    public static byte[] toBytes(Time time) {
        return DATE.toBytes(time, null);
    }

    public static byte[] toBytes(Timestamp timestamp2) {
        return DATE.toBytes(timestamp2, null);
    }

    public static byte[] toBytes(Date date, Calendar cal) {
        if (date == null) {
            return null;
        }
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.setTime(date);
        byte[] result2 = new byte[7];
        int year2 = TIMESTAMP.getOracleYear(cal1);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal1.get(2) + 1);
        result2[3] = (byte)cal1.get(5);
        if (!OracleDriver.getSystemPropertyDateZeroTime()) {
            result2[4] = (byte)(cal1.get(11) + 1);
            result2[5] = (byte)(cal1.get(12) + 1);
            result2[6] = (byte)(cal1.get(13) + 1);
        } else {
            result2[4] = 1;
            result2[5] = 1;
            result2[6] = 1;
        }
        return result2;
    }

    public static byte[] toBytes(Time time, Calendar cal) {
        if (time == null) {
            return null;
        }
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.setTime(time);
        byte[] result2 = new byte[]{119, -86, 1, 1, (byte)(cal1.get(11) + 1), (byte)(cal1.get(12) + 1), (byte)(cal1.get(13) + 1)};
        return result2;
    }

    public static byte[] toBytes(Timestamp timestamp2, Calendar cal) {
        if (timestamp2 == null) {
            return null;
        }
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.setTime(timestamp2);
        byte[] result2 = new byte[7];
        int year2 = TIMESTAMP.getOracleYear(cal1);
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)(cal1.get(2) + 1);
        result2[3] = (byte)cal1.get(5);
        result2[4] = (byte)(cal1.get(11) + 1);
        result2[5] = (byte)(cal1.get(12) + 1);
        result2[6] = (byte)(cal1.get(13) + 1);
        return result2;
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        byte[] result2 = DATE.toBytes(Timestamp.valueOf(str));
        return result2;
    }

    public static byte[] toBytes(String str, Calendar cal) {
        return DATE.toBytes(Timestamp.valueOf(str), cal);
    }

    @Override
    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    @Override
    public Timestamp timestampValue() {
        return DATE.toTimestamp(this.getBytes());
    }

    public Date dateValue(Calendar cal) {
        return DATE.toDate(this.getBytes(), cal);
    }

    @Override
    public Time timeValue(Calendar cal) {
        return DATE.toTime(this.getBytes(), cal);
    }

    @Override
    public Timestamp timestampValue(Calendar cal) {
        return DATE.toTimestamp(this.getBytes(), cal);
    }

    @Override
    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object toJdbc() {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls == Date.class || cls == Time.class || cls == Timestamp.class || cls == LocalDateTime.class || cls == LocalDate.class || cls == LocalTime.class || cls == String.class;
    }

    public DATE addJulianDays(int julianDay, int julianSec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), julianDay, julianSec));
    }

    public DATE addMonths(int months) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), months));
    }

    public DATE zeroTime() throws SQLException {
        byte[] tmpDate = this.toBytes();
        tmpDate[4] = 1;
        tmpDate[5] = 1;
        tmpDate[6] = 1;
        return new DATE(tmpDate);
    }

    public void diffInJulianDays(DATE date, int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxsub(this.shareBytes(), date.shareBytes(), julianDay, julianSec);
    }

    public NUMBER diffInMonths(DATE date) throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), date.shareBytes()));
    }

    public static DATE getCurrentDate() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxgdt());
    }

    public static int checkValidity(byte[] date) throws SQLException {
        return DATE._getLdxLib().ldxchk(date);
    }

    public static DATE fromJulianDays(int julianDay, int julianSec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxdfd(julianDay, julianSec));
    }

    public static DATE fromText(String datestr, String fmt, String lang) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxstd(datestr, fmt, lang));
    }

    public DATE lastDayOfMonth() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
    }

    public static void numberToJulianDays(NUMBER num, int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxftd(num.toBytes(), julianDay, julianSec);
    }

    public DATE round(String prec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), prec));
    }

    public DATE setDayOfWeek(int day2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), day2));
    }

    public void toJulianDays(int[] julianDay, int[] julianSec) throws SQLException {
        DATE._getLdxLib().ldxdtd(this.shareBytes(), julianDay, julianSec);
    }

    public NUMBER toNumber() throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
    }

    public String toText(String fmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), fmt, lang);
    }

    public String toText(byte[] pfmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), pfmt, lang);
    }

    public static byte[] parseFormat(String fmt, String lang) throws SQLException {
        return DATE._getLdxLib().ldxsto(fmt, lang);
    }

    public DATE truncate(String prec) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), prec));
    }

    public int compareTo(DATE date) {
        return DATE.compareBytes(this.shareBytes(), date.shareBytes());
    }

    private static byte[] _initDate() {
        byte[] tmp = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return tmp;
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            _sldxlib = new LdxLibThin();
        }
        return _sldxlib;
    }

    private static void _printBytes(byte[] date) {
        System.out.println(DATE.toString(date));
    }

    public static DATE of(LocalDate ld) throws SQLException {
        return new DATE(ld);
    }

    public LocalDate toLocalDate() throws SQLException {
        return DATE.toLocalDate(this.getBytes());
    }

    public LocalDate localDateValue() throws SQLException {
        return DATE.toLocalDate(this.getBytes());
    }

    public static DATE of(LocalDateTime ldt) throws SQLException {
        return new DATE(ldt);
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        return DATE.toLocalDateTime(this.getBytes());
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        return DATE.toLocalDateTime(this.getBytes());
    }

    public static DATE of(LocalTime lt) throws SQLException {
        return new DATE(lt);
    }

    public LocalTime toLocalTime() throws SQLException {
        return DATE.toLocalTime(this.getBytes());
    }

    public LocalTime localTimeValue() throws SQLException {
        return DATE.toLocalTime(this.getBytes());
    }

    public static DATE of(OffsetDateTime odt) throws SQLException {
        return new DATE(odt);
    }

    public static DATE of(OffsetTime ot) throws SQLException {
        return new DATE(ot);
    }

    public static DATE of(ZonedDateTime zdt) throws SQLException {
        return new DATE(zdt);
    }

    public static LocalDate toLocalDate(byte[] date) throws SQLException {
        return DATE.toLocalDateTime(date).toLocalDate();
    }

    public static LocalTime toLocalTime(byte[] date) throws SQLException {
        return DATE.toLocalDateTime(date).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(byte[] date) throws SQLException {
        int[] result2 = new int[7];
        for (int i = 0; i < 7; ++i) {
            result2[i] = date[i] & 0xFF;
        }
        int year2 = TIMESTAMP.getJavaYear(result2[0], result2[1]);
        LocalDateTime ldt = LocalDateTime.of(year2, result2[2], result2[3], result2[4] - 1, result2[5] - 1, result2[6] - 1);
        return ldt;
    }

    public static byte[] toBytes(LocalDate ld) {
        if (ld == null) {
            return null;
        }
        return DATE.toBytes(ld.atTime(0, 0, 0));
    }

    public static byte[] toBytes(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        byte[] result2 = new byte[7];
        int year2 = TIMESTAMP.getOracleYear(ldt.getYear());
        int month2 = ldt.getMonthValue();
        int date = ldt.getDayOfMonth();
        int hour2 = ldt.getHour();
        int minute2 = ldt.getMinute();
        int second2 = ldt.getSecond();
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)month2;
        result2[3] = (byte)date;
        result2[4] = (byte)(hour2 + 1);
        result2[5] = (byte)(minute2 + 1);
        result2[6] = (byte)(second2 + 1);
        return result2;
    }

    public static byte[] toBytes(LocalTime lt) {
        if (lt == null) {
            return null;
        }
        return DATE.toBytes(lt.atDate(LocalDate.of(1970, 1, 1)));
    }

    public static byte[] toBytes(OffsetDateTime odt) {
        if (odt == null) {
            return null;
        }
        byte[] result2 = new byte[7];
        OffsetDateTime odtutc = odt.withOffsetSameInstant(ZoneOffset.UTC);
        int year2 = TIMESTAMP.getOracleYear(odtutc.getYear());
        int month2 = odtutc.getMonthValue();
        int date = odtutc.getDayOfMonth();
        int hour2 = odtutc.getHour();
        int minute2 = odtutc.getMinute();
        int second2 = odtutc.getSecond();
        result2[0] = (byte)(year2 / 100 + 100);
        result2[1] = (byte)(year2 % 100 + 100);
        result2[2] = (byte)month2;
        result2[3] = (byte)date;
        result2[4] = (byte)(hour2 + 1);
        result2[5] = (byte)(minute2 + 1);
        result2[6] = (byte)(second2 + 1);
        return result2;
    }

    public static byte[] toBytes(OffsetTime ot) {
        if (ot == null) {
            return null;
        }
        return DATE.toBytes(ot.atDate(LocalDate.of(1970, 1, 1)));
    }

    public static byte[] toBytes(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return DATE.toBytes(zdt.toOffsetDateTime());
    }
}

