/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableBase;

public class ConcreteProxyUtil {
    public static boolean isThinDriverConnection(Object conn) {
        return conn != null && conn instanceof OracleConnection && !(conn instanceof T2CConnection);
    }

    public static TxnReplayableBase getTxnReplayableBaseOfConnection(oracle.jdbc.OracleConnection conn) {
        TxnReplayableBase connTxnReplayableBase = null;
        if (conn != null && conn instanceof ReplayableConnection) {
            try {
                if (conn instanceof TxnReplayableBase) {
                    connTxnReplayableBase = (TxnReplayableBase)((Object)conn);
                } else if (conn instanceof oracle.jdbc.replay.internal.ReplayableConnection) {
                    oracle.jdbc.internal.OracleConnection physicalConn;
                    Object proxy = ((oracle.jdbc.replay.internal.ReplayableConnection)((Object)conn)).getProxyObject();
                    if (proxy != null && proxy instanceof TxnReplayableBase) {
                        connTxnReplayableBase = (TxnReplayableBase)proxy;
                    } else if (conn instanceof LogicalConnection) {
                        oracle.jdbc.internal.OracleConnection physicalConn2 = ((LogicalConnection)conn).getPhysicalConnection();
                        if (physicalConn2 != null && physicalConn2 instanceof TxnReplayableBase) {
                            connTxnReplayableBase = (TxnReplayableBase)((Object)physicalConn2);
                        }
                    } else if (conn instanceof oracle.jdbc.OracleConnection && (physicalConn = conn.unwrap(oracle.jdbc.internal.OracleConnection.class)) != null && physicalConn instanceof TxnReplayableBase) {
                        connTxnReplayableBase = (TxnReplayableBase)((Object)physicalConn);
                    }
                }
            }
            catch (SQLException ex) {
                connTxnReplayableBase = null;
            }
        }
        return connTxnReplayableBase;
    }

    public static boolean isThinDriverReplayableConnection(oracle.jdbc.OracleConnection conn) {
        boolean isT4cReplayConn = false;
        TxnReplayableBase connTxnReplayableBase = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(conn);
        if (connTxnReplayableBase != null) {
            Object delegate2 = connTxnReplayableBase.getDelegateObj();
            isT4cReplayConn = ConcreteProxyUtil.isThinDriverConnection(delegate2);
        }
        return isT4cReplayConn;
    }

    public static oracle.jdbc.OracleConnection getThinDriverReplayableConnectionDelegate(oracle.jdbc.OracleConnection conn) {
        boolean isT4cReplayConn = false;
        Object delegate2 = null;
        TxnReplayableBase connTxnReplayableBase = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(conn);
        if (connTxnReplayableBase != null) {
            delegate2 = connTxnReplayableBase.getDelegateObj();
            isT4cReplayConn = ConcreteProxyUtil.isThinDriverConnection(delegate2);
        }
        return isT4cReplayConn ? (oracle.jdbc.OracleConnection)delegate2 : null;
    }

    public static Object checkAndGetACProxyConnection(oracle.jdbc.OracleConnection conn) {
        Object proxyObj = null;
        if (ConcreteProxyUtil.isThinDriverConnection(conn)) {
            OracleConnection t4cConn = (OracleConnection)conn;
            proxyObj = t4cConn.getACProxy();
            if (proxyObj == null || !(proxyObj instanceof ReplayableConnection)) {
                proxyObj = null;
            }
        } else if (ConcreteProxyUtil.isThinDriverReplayableConnection(conn)) {
            proxyObj = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(conn);
        }
        return proxyObj;
    }

    public static <T> T getProxyObject(oracle.jdbc.OracleConnection conn, T delegate2, Class proxyBaseClass, Object creator) {
        Object proxyObj;
        T internalOracleConcreteProxy = null;
        if ((ConcreteProxyUtil.isThinDriverConnection(conn) || ConcreteProxyUtil.isThinDriverReplayableConnection(conn)) && (proxyObj = ConcreteProxyUtil.checkAndGetACProxyConnection(conn)) != null) {
            ProxyFactory factory = null;
            factory = ProxyFactory.createProxyFactory(proxyBaseClass);
            internalOracleConcreteProxy = factory.proxyFor(delegate2, creator);
            TxnReplayableBase connTxnReplayableBase = (TxnReplayableBase)proxyObj;
            TxnReplayableBase lobTxnReplayableBase = (TxnReplayableBase)internalOracleConcreteProxy;
            lobTxnReplayableBase.setFailoverManager(connTxnReplayableBase.getFailoverManager());
        }
        return internalOracleConcreteProxy;
    }

    public static <T> T getProxyObject(T delegate2, Class proxyBaseClass, Object creator) {
        T internalOracleConcreteProxy = null;
        ProxyFactory factory = null;
        factory = ProxyFactory.createProxyFactory(proxyBaseClass);
        internalOracleConcreteProxy = factory.proxyFor(delegate2, creator);
        return internalOracleConcreteProxy;
    }

    public static oracle.jdbc.OracleConnection unwrapConnectionProxy(oracle.jdbc.OracleConnection conn) {
        oracle.jdbc.OracleConnection delegateConn = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(conn);
        if (delegateConn != null) {
            conn = delegateConn;
        }
        return conn;
    }

    public static void checkAndDisableReplay(OracleConcreteProxy concreteproxy) {
        try {
            TxnReplayableBase connTxnReplayableBase = concreteproxy.getConcreteProxy();
            if (connTxnReplayableBase != null) {
                connTxnReplayableBase.disableReplay();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

