/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetUTF;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetByte(int id2) {
        super(id2);
        this.rep = 1;
    }

    @Override
    public boolean isLossyFrom(CharacterSet from) {
        return from.rep != 1;
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        return source.rep <= 1024;
    }

    private String toString(byte[] bytes, int offset, int count2, char replacement) throws SQLException {
        try {
            return new String(bytes, offset, count2, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 183).fillInStackTrace();
        }
    }

    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count2) {
        try {
            return this.toString(bytes, offset, count2, '?');
        }
        catch (SQLException ex) {
            throw new Error("CharacterSetByte.toString");
        }
    }

    @Override
    public String toString(byte[] bytes, int offset, int count2) throws SQLException {
        return this.toString(bytes, offset, count2);
    }

    @Override
    public byte[] convert(String s2) throws SQLException {
        int sLength = s2.length();
        char[] chars = new char[s2.length()];
        s2.getChars(0, sLength, chars, 0);
        return CharacterSetByte.charsToBytes(chars, (byte)0);
    }

    @Override
    public byte[] convertWithReplacement(String s2) {
        int sLength = s2.length();
        char[] chars = new char[s2.length()];
        s2.getChars(0, sLength, chars, 0);
        try {
            return CharacterSetByte.charsToBytes(chars, (byte)63);
        }
        catch (SQLException ex) {
            return new byte[0];
        }
    }

    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count2) throws SQLException {
        byte[] result2;
        if (from.rep == 1) {
            result2 = CharacterSetByte.useOrCopy(source, offset, count2);
        } else if (from.rep == 2) {
            char[] chars = CharacterSetUTF.UTFToJavaChar(source, offset, count2);
            result2 = CharacterSetByte.charsToBytes(chars, (byte)0);
        } else {
            String s2 = from.toString(source, offset, count2);
            char[] chars = s2.toCharArray();
            result2 = CharacterSetByte.charsToBytes(chars, (byte)0);
        }
        return result2;
    }

    @Override
    int decode(CharacterWalker walker) {
        int c = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        return c;
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        CharacterSetByte.need(buffer, 1);
        if (c < 256) {
            buffer.bytes[buffer.next] = (byte)c;
            ++buffer.next;
        }
    }

    static byte[] charsToBytes(char[] chars, byte replacement) throws SQLException {
        byte[] bytes = new byte[chars.length];
        for (int x = 0; x < chars.length; ++x) {
            if (chars[x] > '\u00ff') {
                bytes[x] = replacement;
                if (replacement != 0) continue;
                CharacterSetByte.failCharacterConversion(CharacterSet.make(31));
                continue;
            }
            bytes[x] = (byte)chars[x];
        }
        return bytes;
    }
}

