/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16LE
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL16UTF16LE(int id2) {
        super(id2);
        this.rep = 5;
    }

    @Override
    public boolean isLossyFrom(CharacterSet from) {
        return !from.isUnicode();
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet source) {
        boolean ok = source.rep <= 1024;
        return ok;
    }

    @Override
    public boolean isUnicode() {
        return true;
    }

    @Override
    public String toStringWithReplacement(byte[] bytes, int offset, int count2) {
        try {
            char[] chars = new char[Math.min(bytes.length - offset >>> 1, count2 >>> 1)];
            int chars_len = CharacterSet.convertAL16UTF16LEBytesToJavaChars(bytes, offset, chars, 0, count2, true);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e) {
            return "";
        }
    }

    @Override
    public String toString(byte[] bytes, int offset, int count2) throws SQLException {
        try {
            char[] chars = new char[Math.min(bytes.length - offset >>> 1, count2 >>> 1)];
            int chars_len = CharacterSet.convertAL16UTF16LEBytesToJavaChars(bytes, offset, chars, 0, count2, false);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e) {
            CharacterSetAL16UTF16LE.failUTFConversion();
            return "";
        }
    }

    @Override
    public byte[] convert(String s2) throws SQLException {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s2);
    }

    @Override
    public byte[] convertWithReplacement(String s2) {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s2);
    }

    @Override
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count2) throws SQLException {
        byte[] result2;
        if (from.rep == 5) {
            result2 = CharacterSetAL16UTF16LE.useOrCopy(source, offset, count2);
        } else {
            String s2 = from.toString(source, offset, count2);
            result2 = CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s2);
        }
        return result2;
    }

    @Override
    int decode(CharacterWalker walker) throws SQLException {
        int char1;
        byte[] bytes = walker.bytes;
        int bytes_index = walker.next;
        int bytes_end = walker.end;
        if (bytes_index + 1 >= bytes_end) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        }
        byte c2 = bytes[bytes_index++];
        byte c1 = bytes[bytes_index++];
        int result2 = char1 = (int)(c1 << 8 | c2 & 0xFF);
        if (Character.isHighSurrogate((char)char1)) {
            if (bytes_index + 1 >= bytes_end) {
                CharacterSetAL16UTF16LE.failUTFConversion();
            }
            c2 = bytes[bytes_index++];
            c1 = bytes[bytes_index++];
            char char2 = (char)(c1 << 8 & 0xFF00 | c2 & 0xFF);
            result2 = Character.toCodePoint((char)char1, char2);
        }
        walker.next = bytes_index;
        return result2;
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        boolean isSup = Character.isSupplementaryCodePoint(c);
        if (c > 65535 && !isSup) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        } else if (!isSup) {
            CharacterSetAL16UTF16LE.need(buffer, 2);
            buffer.bytes[buffer.next++] = (byte)(c & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(c >> 8 & 0xFF);
        } else {
            CharacterSetAL16UTF16LE.need(buffer, 4);
            char[] chars = Character.toChars(c);
            buffer.bytes[buffer.next++] = (byte)(chars[0] & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(chars[0] >> 8 & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(chars[1] & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(chars[1] >> 8 & 0xFF);
        }
    }
}

