/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSet1Byte
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter1Byte";
    static Class m_charConvSuperclass;

    CharacterSet1Byte(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
    }

    static CharacterSet1Byte getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        if (charConverter.getGroupId() == 0) {
            return new CharacterSet1Byte(oracleId, charConverter);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker walker) throws SQLException {
        int c = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        return c;
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        CharacterSet1Byte.need(buffer, 1);
        if (c < 256) {
            buffer.bytes[buffer.next] = (byte)c;
            ++buffer.next;
        }
    }

    @Override
    public int toCharWithReplacement(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count2) throws SQLException {
        return this.m_converter.toUnicodeChars(srcChar, offset, dstChar, dstOffset, count2);
    }
}

