/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.Datum;

public class BINARY_FLOAT
extends Datum {
    static final long serialVersionUID = -4231112037190700631L;

    public BINARY_FLOAT() {
    }

    public BINARY_FLOAT(byte[] _bytes) {
        super(_bytes);
    }

    public BINARY_FLOAT(float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2));
    }

    public BINARY_FLOAT(Float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2.floatValue()));
    }

    public BINARY_FLOAT(String s2) throws SQLException {
        this(BINARY_FLOAT.stringToFloat(s2));
    }

    public BINARY_FLOAT(Boolean b) {
        this(b != false ? 1 : 0);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.lang.String") == 0 || class_name.compareTo("java.lang.Float") == 0;
    }

    @Override
    public String stringValue() {
        String ret = Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
        return ret;
    }

    @Override
    public float floatValue() throws SQLException {
        return BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes());
    }

    @Override
    public double doubleValue() throws SQLException {
        return this.floatValue();
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        return new BigDecimal(this.floatValue());
    }

    private static float stringToFloat(String s2) throws SQLException {
        try {
            return Float.valueOf(s2).floatValue();
        }
        catch (NumberFormatException ex) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new Float[arraySize];
    }

    static byte[] floatToCanonicalFormatBytes(float _f) {
        float f2 = _f;
        if (f2 == 0.0f) {
            f2 = 0.0f;
        } else if (f2 != f2) {
            f2 = Float.NaN;
        }
        int intBits = Float.floatToIntBits(f2);
        byte[] b = new byte[4];
        int b3 = intBits;
        int b2 = intBits >>= 8;
        int b1 = intBits >>= 8;
        int b0 = intBits >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
        }
        b[3] = (byte)b3;
        b[2] = (byte)b2;
        b[1] = (byte)b1;
        b[0] = (byte)b0;
        return b;
    }

    static float canonicalFormatBytesToFloat(byte[] b) {
        int b0 = b[0];
        int b1 = b[1];
        int b2 = b[2];
        int b3 = b[3];
        if ((b0 & 0x80) != 0) {
            b0 &= 0x7F;
            b1 &= 0xFF;
            b2 &= 0xFF;
            b3 &= 0xFF;
        } else {
            b0 = ~b0 & 0xFF;
            b1 = ~b1 & 0xFF;
            b2 = ~b2 & 0xFF;
            b3 = ~b3 & 0xFF;
        }
        int intBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return Float.intBitsToFloat(intBits);
    }
}

