/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static final String CLASS_NAME = ArrayDescriptor.class.getName();

    public static ArrayDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        return ArrayDescriptor.createDescriptor(name, conn, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompletionStage<ArrayDescriptor> createDescriptorAsync(String name, Connection conn) {
        if (name == null) return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace());
        if (name.length() == 0) return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace());
        if (conn == null) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace());
        }
        oracle.jdbc.OracleConnection unwrappedConn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
        OracleConnection physConn = unwrappedConn.physicalConnectionWithin();
        try (Monitor.CloseableLock lock = physConn.acquireCloseableLock();){
            SQLName sqlName = new SQLName(name, unwrappedConn);
            String qualifiedName = sqlName.getName();
            ArrayDescriptor cachedDescriptor = (ArrayDescriptor)((OracleConnection)unwrappedConn).doGetDescriptor(qualifiedName);
            if (cachedDescriptor != null) {
                CompletionStage<ArrayDescriptor> completionStage = CompletableFuture.completedStage(cachedDescriptor);
                return completionStage;
            }
            ArrayDescriptor descriptor2 = new ArrayDescriptor(name, unwrappedConn, false);
            CompletionStage<ArrayDescriptor> completionStage = descriptor2.initPicklerAsync().thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                unwrappedConn.putDescriptor(qualifiedName, descriptor2);
                return descriptor2;
            }));
            return completionStage;
        }
        catch (SQLException createDescriptorException) {
            return CompletableFuture.failedStage(createDescriptorException);
        }
    }

    public static ArrayDescriptor createDescriptor(String name, Connection conn, boolean recurse, boolean force) throws SQLException {
        if (name == null || name.length() == 0 || conn == null) {
            throw (SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace();
        }
        conn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
        OracleConnection physConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        try (Monitor.CloseableLock lock = physConn.acquireCloseableLock();){
            SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
            String qualifiedName = sqlName.getName();
            ArrayDescriptor descriptor2 = null;
            if (!force) {
                descriptor2 = (ArrayDescriptor)physConn.doGetDescriptor(qualifiedName);
            }
            if (descriptor2 == null) {
                short dbVersion = physConn.getVersionNumber();
                descriptor2 = dbVersion >= 12000 ? new ArrayDescriptor(name, conn) : new ArrayDescriptor(sqlName, conn);
                if (recurse) {
                    descriptor2.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor2);
            }
            ArrayDescriptor arrayDescriptor = descriptor2;
            return arrayDescriptor;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        return ArrayDescriptor.createDescriptor(sqlName, conn, false, false);
    }

    public static ArrayDescriptor createDescriptor(SQLName sqlName, Connection conn, boolean recurse, boolean force) throws SQLException {
        conn = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)conn);
        try (Monitor.CloseableLock lock = ((OracleConnection)conn).acquireCloseableLock();){
            String qualifiedName = sqlName.getName();
            ArrayDescriptor descriptor2 = null;
            if (!force) {
                descriptor2 = (ArrayDescriptor)((OracleConnection)conn).doGetDescriptor(qualifiedName);
            }
            if (descriptor2 == null) {
                descriptor2 = new ArrayDescriptor(sqlName, conn);
                if (recurse) {
                    descriptor2.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor2);
            }
            ArrayDescriptor arrayDescriptor = descriptor2;
            return arrayDescriptor;
        }
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION otype) throws SQLException {
        String fullName = otype.getFullName();
        OracleConnection conn = otype.getConnection();
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            ArrayDescriptor descriptor2 = (ArrayDescriptor)conn.doGetDescriptor(fullName);
            if (descriptor2 == null) {
                SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
                descriptor2 = new ArrayDescriptor(sqlName, otype, (Connection)conn);
                conn.putDescriptor(fullName, (Object)descriptor2);
            }
            ArrayDescriptor arrayDescriptor = descriptor2;
            return arrayDescriptor;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sqlName, byte[] typoid, int version2, byte[] tds, OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            OracleTypeADT interimPickler = new OracleTypeADT(sqlName, typoid, version2, tds, conn);
            interimPickler.init(tds, conn);
            OracleTypeCOLLECTION pickler = (OracleTypeCOLLECTION)interimPickler.cleanup();
            ArrayDescriptor arrayDescriptor = new ArrayDescriptor(sqlName, pickler, (Connection)conn);
            return arrayDescriptor;
        }
    }

    public ArrayDescriptor(String name, Connection conn) throws SQLException {
        this(name, conn, true);
    }

    private ArrayDescriptor(String name, Connection conn, boolean constructInitialized) throws SQLException {
        super((short)122, name, conn);
        if (constructInitialized) {
            this.initPickler();
        }
    }

    public ArrayDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        super((short)122, sqlName, conn);
        this.initPickler();
    }

    public ArrayDescriptor(SQLName sqlName, OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        super((short)122, sqlName, type, conn);
    }

    public ArrayDescriptor(OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        super((short)122, type, conn);
    }

    ArrayDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)122);
        this.toid = _toid;
        this.toidVersion = _toidVersion;
        this.setPhysicalConnectionOf(conn);
        this.initPickler();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.ARRAY;
    }

    @Override
    public int getBaseType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
    }

    @Override
    public String getBaseName() throws SQLException {
        Object ret = null;
        switch (this.getBaseType()) {
            case 12: {
                ret = "VARCHAR";
                break;
            }
            case 1: {
                ret = "CHAR";
                break;
            }
            case -9: {
                ret = "NVARCHAR";
                break;
            }
            case -15: {
                ret = "NCHAR";
                break;
            }
            case -2: {
                ret = "RAW";
                break;
            }
            case 6: {
                ret = "FLOAT";
                break;
            }
            case 2: {
                ret = "NUMBER";
                break;
            }
            case 8: {
                ret = "DOUBLE";
                break;
            }
            case 3: {
                ret = "DECIMAL";
                break;
            }
            case 91: {
                ret = "DATE";
                break;
            }
            case 93: {
                ret = "TIMESTAMP";
                break;
            }
            case -101: {
                ret = "TIMESTAMP WITH TIME ZONE";
                break;
            }
            case -102: {
                ret = "TIMESTAMP WITH LOCAL TIME ZONE";
                break;
            }
            case 2004: {
                ret = "BLOB";
                break;
            }
            case 2005: {
                ret = "CLOB";
                break;
            }
            case 2011: {
                ret = "NCLOB";
                break;
            }
            case -13: {
                ret = "BFILE";
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                ret = otype.getFullName();
                break;
            }
            case 2006: {
                OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                ret = "REF " + ((OracleTypeREF)otype).getFullName();
                break;
            }
            case 100: {
                ret = "BINARY_FLOAT";
                break;
            }
            case 101: {
                ret = "BINARY_DOUBLE";
                break;
            }
            case -104: {
                ret = "INTERVALDS";
                break;
            }
            case -103: {
                ret = "INTERVALYM";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        return (OracleTypeCOLLECTION)this.pickler;
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        return OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
    }

    public int getArrayType() throws SQLException {
        return ((OracleTypeCOLLECTION)this.pickler).getUserCode();
    }

    @Override
    public long getMaxLength() throws SQLException {
        return this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
    }

    public String descType() throws SQLException {
        StringBuffer strBuf = new StringBuffer();
        return this.descType(strBuf, 0);
    }

    String descType(StringBuffer strBuf, int level) throws SQLException {
        Object level_one = "";
        for (int i = 0; i < level; ++i) {
            level_one = (String)level_one + "  ";
        }
        String level_two = (String)level_one + "  ";
        strBuf.append((String)level_one);
        strBuf.append(this.getTypeName());
        strBuf.append("\n");
        int tcode = this.getBaseType();
        if (tcode == 2002 || tcode == 2008) {
            StructDescriptor adt_desc = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            adt_desc.descType(strBuf, level + 1);
        } else if (tcode == 2003) {
            ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            array_desc.descType(strBuf, level + 1);
        } else if (tcode == 2007) {
            OpaqueDescriptor opaque_desc = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            opaque_desc.descType(strBuf, level + 1);
        } else {
            strBuf.append(level_two);
            strBuf.append(this.getBaseName());
            strBuf.append("\n");
        }
        return strBuf.substring(0, strBuf.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int toLength(OracleArray array, Datum arrayDatum) throws SQLException {
        if (array.getNumElems() != -1) return array.getNumElems();
        if (array.getDatumArray() != null) {
            array.setLength(array.getDatumArray().length);
            return array.getNumElems();
        } else if (array.getObjArray() != null) {
            Object objArray = array.getObjArray();
            int numElems = array.getNumElems();
            if (objArray instanceof Object[]) {
                numElems = ((Object[])objArray).length;
            } else if (objArray instanceof int[]) {
                numElems = ((long[])objArray).length;
            } else if (objArray instanceof long[]) {
                numElems = ((float[])objArray).length;
            } else if (objArray instanceof float[]) {
                numElems = ((double[])objArray).length;
            } else if (objArray instanceof double[]) {
                numElems = ((boolean[])objArray).length;
            } else if (objArray instanceof boolean[]) {
                numElems = ((int[])objArray).length;
            } else if (objArray instanceof byte[]) {
                numElems = ((byte[])objArray).length;
            } else if (objArray instanceof short[]) {
                numElems = ((short[])objArray).length;
            } else if (objArray instanceof char[]) {
                numElems = ((char[])objArray).length;
            }
            array.setLength(numElems);
            return array.getNumElems();
        } else if (array.getLocator() != null) {
            array.setLength(this.toLengthFromLocator(array.getLocator()));
            return array.getNumElems();
        } else {
            if (array.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), arrayDatum, 0, null);
            if (array.getNumElems() != -1) return array.getNumElems();
            if (array.getLocator() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length").fillInStackTrace();
            array.setLength(this.toLengthFromLocator(array.getLocator()));
        }
        return array.getNumElems();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(OracleArray s2, Datum sDatum, boolean keepLocalCopy) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            byte[] bytes = s2.shareBytes();
            if (bytes == null) {
                if (s2.getDatumArray() != null || s2.getLocator() != null) {
                    bytes = this.pickler.linearize(sDatum);
                    if (!keepLocalCopy) {
                        s2.setShareBytes(null);
                    }
                } else {
                    if (s2.getObjArray() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                    s2.setDatumArray(this.toOracleArray(s2.getObjArray(), 1L, -1));
                    bytes = this.pickler.linearize(sDatum);
                    if (!keepLocalCopy) {
                        s2.setDatumArray(null);
                        s2.setShareBytes(null);
                    }
                }
            } else if (s2.getImageLength() != 0L) {
                long imageLength = s2.getImageLength();
                if (s2.getImageOffset() != 0L || imageLength != (long)bytes.length) {
                    byte[] image = new byte[(int)imageLength];
                    System.arraycopy(bytes, (int)s2.getImageOffset(), image, 0, (int)imageLength);
                    s2.setImage(image, 0L, 0L);
                    byte[] byArray = image;
                    return byArray;
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Datum[] toOracleArray(OracleArray s2, Datum sDatum, long beginIdx, int count2, boolean keepLocalCopy) throws SQLException {
        Datum[] datumArray = s2.getDatumArray();
        if (datumArray == null) {
            if (s2.getObjArray() != null) {
                datumArray = this.toOracleArray(s2.getObjArray(), beginIdx, count2);
            } else if (s2.getLocator() != null) {
                datumArray = this.toOracleArrayFromLocator(s2.getLocator(), beginIdx, count2, null);
            } else {
                if (s2.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.").fillInStackTrace();
                this.pickler.unlinearize(s2.shareBytes(), s2.getImageOffset(), sDatum, beginIdx, count2, 1, null);
                datumArray = s2.getLocator() != null ? this.toOracleArrayFromLocator(s2.getLocator(), beginIdx, count2, null) : s2.getDatumArray();
                if (!keepLocalCopy) {
                    s2.setDatumArray(null);
                }
            }
        } else {
            if (beginIdx > (long)datumArray.length) {
                return new Datum[0];
            }
            int length = (int)(count2 == -1 ? (long)datumArray.length - beginIdx + 1L : Math.min((long)datumArray.length - beginIdx + 1L, (long)count2));
            datumArray = new Datum[length];
            System.arraycopy(s2.getDatumArray(), (int)beginIdx - 1, datumArray, 0, length);
        }
        Datum[] ret = null;
        if (!keepLocalCopy) return datumArray;
        s2.setDatumArray(datumArray);
        return (Datum[])datumArray.clone();
    }

    public Object[] toJavaArray(OracleArray s2, Datum sDatum, long beginIdx, int count2, Map map2, boolean keepLocalCopy) throws SQLException {
        Object[] objArray = null;
        if (s2.getObjArray() != null) {
            objArray = (Object[])((Object[])s2.getObjArray()).clone();
            int nbElem = objArray.length;
            int length = (int)(count2 == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count2));
            if (length <= 0) {
                Object[] ret = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                return ret;
            }
            objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            System.arraycopy(s2.getObjArray(), (int)beginIdx - 1, objArray, 0, length);
        } else {
            if (s2.getDatumArray() != null) {
                objArray = (Object[])this.toJavaArray(s2, beginIdx, count2, map2);
            } else if (s2.getLocator() != null) {
                objArray = this.toArrayFromLocator(s2.getLocator(), beginIdx, count2, map2);
            } else if (s2.shareBytes() != null) {
                this.pickler.unlinearize(s2.shareBytes(), s2.getImageOffset(), sDatum, beginIdx, count2, 2, map2);
                objArray = s2.getLocator() != null ? this.toArrayFromLocator(s2.getLocator(), beginIdx, count2, map2) : (Object[])s2.getObjArray();
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
            }
            if (keepLocalCopy && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objArray != null) {
                s2.setObjArray(objArray.clone());
            } else {
                s2.setNullObjArray();
            }
        }
        return objArray;
    }

    private Datum[] toOracleArrayFromLocator(byte[] locator_bytes, long beginIdx, int count2, Map map2) throws SQLException {
        int nbElem = this.toLengthFromLocator(locator_bytes);
        int length = (int)(count2 == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count2));
        Datum[] datumArray = null;
        if (length <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[length];
            ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count2, map2);
            int i = 0;
            while (rset.next()) {
                datumArray[i] = ((OracleResultSet)rset).getOracleObject(2);
                ++i;
            }
            rset.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] locator_bytes, long beginIdx, int count2, Map map2) throws SQLException {
        int nbElem = this.toLengthFromLocator(locator_bytes);
        int length = (int)(count2 == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count2));
        Object[] objArray = null;
        if (length <= 0) {
            objArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count2, map2);
            int i = 0;
            while (rset.next()) {
                objArray[i] = ((OracleResultSet)rset).getObject(2, map2);
                ++i;
            }
            rset.close();
        }
        return objArray;
    }

    public ResultSet toResultSet(ARRAY array, long index, int count2, Map map2, boolean saveLocalCopy) throws SQLException {
        return this.toResultSet(array, array, index, count2, map2, saveLocalCopy);
    }

    public ResultSet toResultSet(OracleArray array, Datum arrayDatum, long index, int count2, Map map2, boolean saveLocalCopy) throws SQLException {
        ResultSet rset = null;
        if (array.getDatumArray() != null) {
            rset = this.toResultSet(array.getDatumArray(), index, count2, map2);
        } else if (array.getLocator() != null) {
            rset = this.toResultSetFromLocator(array.getLocator(), index, count2, map2);
        } else if (array.getObjArray() != null) {
            rset = this.toResultSet(this.toOracleArray(array.getObjArray(), index, count2), 1L, -1, map2);
        } else if (array.shareBytes() != null) {
            if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(array.shareBytes(), (int)array.getImageOffset())) {
                rset = this.toResultSetFromImage(array, index, count2, map2);
            } else {
                this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), arrayDatum, 1, null);
                if (array.getLocator() != null) {
                    rset = this.toResultSetFromLocator(array.getLocator(), index, count2, map2);
                } else {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                }
            }
        }
        if (rset == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet").fillInStackTrace();
        }
        return rset;
    }

    public ResultSet toResultSet(Datum[] data, long index, int count2, Map map2) throws SQLException {
        ResultSet ret = null;
        ret = count2 == -1 ? this.connection.newArrayDataResultSet(data, index, data.length, map2) : this.connection.newArrayDataResultSet(data, index, count2, map2);
        return ret;
    }

    public ResultSet toResultSetFromLocator(byte[] locator, long index, int count2, Map map2) throws SQLException {
        ResultSet ret = this.connection.newArrayLocatorResultSet(this, locator, index, count2, map2);
        return ret;
    }

    public ResultSet toResultSetFromImage(OracleArray array, long index, int count2, Map map2) throws SQLException {
        ResultSet ret = this.connection.newArrayDataResultSet(array, index, count2, map2);
        return ret;
    }

    public static Object[] makeJavaArray(int length, int otype) throws SQLException {
        Object[] ret = null;
        switch (otype) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ret = new BigDecimal[length];
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                ret = new String[length];
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                ret = new Timestamp[length];
                break;
            }
            case -102: 
            case -101: {
                ret = new OffsetDateTime[length];
                break;
            }
            case 2002: 
            case 2008: {
                ret = new Object[length];
                break;
            }
            case -13: {
                ret = new BFILE[length];
                break;
            }
            case 2004: {
                ret = new BLOB[length];
                break;
            }
            case 2005: 
            case 2011: {
                ret = new CLOB[length];
                break;
            }
            case -3: 
            case -2: {
                ret = (Object[])new byte[length][];
                break;
            }
            case 2006: {
                ret = new REF[length];
                break;
            }
            case 2003: {
                ret = new Object[length];
                break;
            }
            case 2007: {
                ret = new Object[length];
                break;
            }
            case 100: {
                ret = new Float[length];
                break;
            }
            case 101: {
                ret = new Double[length];
                break;
            }
            case -104: {
                ret = new INTERVALDS[length];
                break;
            }
            case -103: {
                ret = new INTERVALYM[length];
                break;
            }
            case -8: {
                ret = new ROWID[length];
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(1, "makeJavaArray doesn't support type " + otype).fillInStackTrace();
            }
        }
        return ret;
    }

    private int toLengthFromLocator(byte[] locator_bytes) throws SQLException {
        ARRAY tmpObj = new ARRAY(this, this.connection, (Object)null);
        tmpObj.setLocator(locator_bytes);
        int numElems = 0;
        OraclePreparedStatement pstmt = null;
        OracleResultSet rs = null;
        pstmt = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        pstmt.setArray(1, tmpObj);
        rs = (OracleResultSet)pstmt.executeQuery();
        if (!rs.next()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table").fillInStackTrace();
        }
        numElems = rs.getInt(1);
        rs.close();
        pstmt.close();
        return numElems;
    }

    public Datum[] toOracleArray(Object elements, long beginIdx, int count2) throws SQLException {
        Datum[] ret = null;
        if (elements != null) {
            OracleType otype = this.getElementType();
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "toOracleArray", "getArrayType()={0}", (String)null, null, (Object)this.getArrayType());
            if (this.getArrayType() == 1) {
                if (elements.getClass().isArray()) {
                    int len = Array.getLength(elements);
                    Datum[] datumArray = new Datum[len];
                    for (int i = 0; i < len; ++i) {
                        Object elem = Array.get(elements, i);
                        Datum d = otype.toDatum(elem, this.connection);
                        datumArray[i] = new AssociativeArrayEntry<Integer, Datum>(i, d);
                    }
                    ret = datumArray;
                } else if (elements instanceof Map) {
                    Map map2 = (Map)elements;
                    Datum[] datumArray = new Datum[map2.size()];
                    int i = 0;
                    for (Map.Entry e : map2.entrySet()) {
                        if (!(e.getKey() instanceof Integer)) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "SQL Associative Array Index Type").fillInStackTrace();
                        }
                        Datum d = otype.toDatum(e.getValue(), this.connection);
                        datumArray[i] = new AssociativeArrayEntry<Integer, Datum>((Integer)e.getKey(), d);
                        ++i;
                    }
                    ret = datumArray;
                }
            } else {
                ret = otype.toDatumArray(elements, this.connection, beginIdx, count2);
            }
        }
        return ret;
    }

    private Object toJavaArray(OracleArray array, long beginIdx, int count2, Map map2) throws SQLException {
        HashMap<Integer, Object> javaMap = null;
        if (this.getArrayType() == 1) {
            javaMap = new HashMap<Integer, Object>();
        }
        Datum[] elements = array.getDatumArray();
        int length = (int)(count2 == -1 ? (long)elements.length - beginIdx + 1L : Math.min((long)elements.length - beginIdx + 1L, (long)count2));
        if (length < 0) {
            length = 0;
        }
        Object[] objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
        for (int i = 0; i < length; ++i) {
            Integer idx = null;
            Datum d = elements[(int)beginIdx + i - 1];
            if (d instanceof AssociativeArrayEntry) {
                idx = (Integer)((AssociativeArrayEntry)d).getKey();
                d = (Datum)((AssociativeArrayEntry)d).getValue();
            }
            if (this.getBaseType() == 2002) {
                objArray[i] = d != null ? ((STRUCT)d).toJdbc(map2) : null;
            } else if (this.getBaseType() == -101) {
                objArray[i] = d != null ? ((TIMESTAMPTZ)d).offsetDateTimeValue(array.getJavaSqlConnection()) : null;
            } else if (this.getBaseType() == -102) {
                objArray[i] = d != null ? ((TIMESTAMPLTZ)d).offsetDateTimeValue(array.getJavaSqlConnection()) : null;
            } else {
                Object object = objArray[i] = d != null ? d.toJdbc() : null;
            }
            if (javaMap == null) continue;
            javaMap.put(idx, objArray[i]);
        }
        array.setJavaMap(javaMap);
        return objArray;
    }

    private Object toNumericArray(Datum[] darray, long beginIdx, int count2, int type) throws SQLException {
        Object[] ret = null;
        int length = (int)(count2 == -1 ? (long)darray.length - beginIdx + 1L : Math.min((long)darray.length - beginIdx + 1L, (long)count2));
        if (length < 0) {
            length = 0;
        }
        switch (type) {
            case 4: {
                int[] objArray = new int[length];
                for (int i = 0; i < length; ++i) {
                    Datum d = darray[(int)beginIdx + i - 1];
                    if (d == null) continue;
                    objArray[i] = d.intValue();
                }
                ret = objArray;
                break;
            }
            case 5: {
                double[] objArray = new double[length];
                for (int i = 0; i < length; ++i) {
                    Datum d = darray[(int)beginIdx + i - 1];
                    if (d == null) continue;
                    objArray[i] = d.doubleValue();
                }
                ret = objArray;
                break;
            }
            case 6: {
                float[] objArray = new float[length];
                for (int i = 0; i < length; ++i) {
                    Datum d = darray[(int)beginIdx + i - 1];
                    if (d == null) continue;
                    objArray[i] = d.floatValue();
                }
                ret = objArray;
                break;
            }
            case 7: {
                long[] objArray = new long[length];
                for (int i = 0; i < length; ++i) {
                    Datum d = darray[(int)beginIdx + i - 1];
                    if (d == null) continue;
                    objArray[i] = d.longValue();
                }
                ret = objArray;
                break;
            }
            case 8: {
                short[] objArray = new short[length];
                for (int i = 0; i < length; ++i) {
                    Datum d = darray[(int)beginIdx + i - 1];
                    if (d == null) continue;
                    objArray[i] = ((NUMBER)d).shortValue();
                }
                ret = objArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                ex.fillInStackTrace();
                throw ex;
            }
        }
        return ret;
    }

    private Object toNumericArrayFromLocator(byte[] locator_bytes, long beginIdx, int count2, int type) throws SQLException {
        Object[] ret = null;
        int nbElem = this.toLengthFromLocator(locator_bytes);
        ResultSet rs = this.toResultSetFromLocator(locator_bytes, beginIdx, count2, null);
        int idx = 0;
        switch (type) {
            case 4: {
                int[] objArray = new int[nbElem];
                while (rs.next() && idx < nbElem) {
                    objArray[idx++] = ((OracleResultSet)rs).getInt(2);
                }
                rs.close();
                ret = objArray;
                break;
            }
            case 5: {
                double[] objArray = new double[nbElem];
                while (rs.next() && idx < nbElem) {
                    objArray[idx++] = ((OracleResultSet)rs).getDouble(2);
                }
                rs.close();
                ret = objArray;
                break;
            }
            case 6: {
                float[] objArray = new float[nbElem];
                while (rs.next() && idx < nbElem) {
                    objArray[idx++] = ((OracleResultSet)rs).getFloat(2);
                }
                rs.close();
                ret = objArray;
                break;
            }
            case 7: {
                long[] objArray = new long[nbElem];
                while (rs.next() && idx < nbElem) {
                    objArray[idx++] = ((OracleResultSet)rs).getLong(2);
                }
                rs.close();
                ret = objArray;
                break;
            }
            case 8: {
                short[] objArray = new short[nbElem];
                while (rs.next() && idx < nbElem) {
                    objArray[idx++] = ((OracleResultSet)rs).getShort(2);
                }
                rs.close();
                ret = objArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                ex.fillInStackTrace();
                throw ex;
            }
        }
        return ret;
    }

    public Object toNumericArray(OracleArray array, Datum arrayDatum, long beginIdx, int count2, int type, boolean saveLocalCopy) throws SQLException {
        OracleType elementType = this.getElementType();
        if (!(elementType instanceof OracleTypeNUMBER) && !(elementType instanceof OracleTypeFLOAT)) {
            SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
            ex.fillInStackTrace();
            throw ex;
        }
        Object objArray = null;
        if (array.getObjArray() != null) {
            Object origObjArray = array.getObjArray();
            if (type == 4 && origObjArray instanceof int[]) {
                int length = ((int[])origObjArray).length;
                if (beginIdx > (long)length) {
                    return new int[0];
                }
                length = (int)(count2 == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count2));
                int[] newOarray = new int[length];
                System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 5 && origObjArray instanceof double[]) {
                int length = ((double[])origObjArray).length;
                if (beginIdx > (long)length) {
                    return new double[0];
                }
                length = (int)(count2 == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count2));
                double[] newOarray = new double[length];
                System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 6 && origObjArray instanceof float[]) {
                int length = ((float[])origObjArray).length;
                if (beginIdx > (long)length) {
                    return new float[0];
                }
                length = (int)(count2 == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count2));
                float[] newOarray = new float[length];
                System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 7 && origObjArray instanceof long[]) {
                int length = ((long[])origObjArray).length;
                if (beginIdx > (long)length) {
                    return new long[0];
                }
                length = (int)(count2 == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count2));
                long[] newOarray = new long[length];
                System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            } else if (type == 8 && origObjArray instanceof short[]) {
                int length = ((short[])origObjArray).length;
                if (beginIdx > (long)length) {
                    return new short[0];
                }
                length = (int)(count2 == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count2));
                short[] newOarray = new short[length];
                System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
            }
        } else {
            if (array.getDatumArray() != null) {
                objArray = this.toNumericArray(array.getDatumArray(), beginIdx, count2, type);
            } else if (array.getLocator() != null) {
                objArray = this.toNumericArrayFromLocator(array.getLocator(), beginIdx, count2, type);
            } else if (array.shareBytes() != null) {
                this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), arrayDatum, beginIdx, count2, type, null);
                objArray = array.getLocator() != null ? this.toNumericArrayFromLocator(array.getLocator(), beginIdx, count2, type) : array.getObjArray();
            } else {
                SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                ex.fillInStackTrace();
                throw ex;
            }
            if (!saveLocalCopy) {
                array.setNullObjArray();
            }
        }
        return objArray;
    }

    private void initPickler() throws SQLException {
        try {
            String typeName = this.typeNameByUser;
            if (typeName == null) {
                typeName = this.getName();
            }
            OracleTypeADT adt = new OracleTypeADT(typeName, (Connection)this.connection);
            adt.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)adt.cleanup();
            this.toid = ((OracleTypeADT)this.pickler).getTOID();
            this.pickler.setDescriptor(this);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private CompletionStage<Void> initPicklerAsync() {
        CompletionStage<Object> initializationStage;
        try {
            String typeName = this.typeNameByUser;
            if (typeName == null) {
                typeName = this.getName();
            }
            OracleTypeADT adt = new OracleTypeADT(typeName, (Connection)this.connection);
            initializationStage = adt.initAsync(this.connection).thenApply(CompletionStageUtil.normalCompletionHandler(nil -> {
                this.pickler = (OracleTypeCOLLECTION)adt.cleanup();
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
                this.pickler.setDescriptor(this);
                return nil;
            }));
        }
        catch (Exception e) {
            initializationStage = CompletableFuture.failedStage(e);
        }
        return initializationStage.exceptionally(completionError -> {
            SQLException thrownException;
            Throwable error = CompletionStageUtil.unwrapCompletionException(completionError);
            if (error instanceof SQLException) {
                thrownException = (SQLException)error;
            } else {
                try {
                    thrownException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
                }
                catch (SQLException getNameException) {
                    throw new CompletionException(getNameException);
                }
            }
            throw new CompletionException(thrownException);
        });
    }

    private OracleType getElementType() throws SQLException {
        OracleType ret = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return ret;
    }

    @Override
    public int getTypeCode() throws SQLException {
        int ret = 2003;
        return ret;
    }

    public SQLInput toJdbcToSQLInput(ARRAY obj, Map map2) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(obj, obj, 0L, obj.length(), false), map2, this.connection);
    }

    public byte[] toBytes(Datum[] attributes) throws SQLException {
        ARRAY s2 = new ARRAY(this, this.connection, attributes);
        return this.pickler.linearize(s2);
    }

    public byte[] toBytes(Object[] attributes) throws SQLException {
        Datum[] datums = this.toArray(attributes);
        byte[] ret = this.toBytes(datums);
        return ret;
    }

    public int length(byte[] bytes) throws SQLException {
        ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
        int ret = this.toLength(tmpObj, tmpObj);
        return ret;
    }

    public Datum[] toArray(byte[] bytes) throws SQLException {
        Datum[] ret = null;
        if (bytes != null) {
            ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
            ret = this.toOracleArray(tmpObj, tmpObj, 1L, -1, false);
        }
        return ret;
    }

    public Datum[] toArray(Object attributes) throws SQLException {
        Datum[] ret = this.toOracleArray(attributes, 1L, -1);
        return ret;
    }

    public ResultSet toResultSet(byte[] bytes, Map map2) throws SQLException {
        ResultSet ret = null;
        if (bytes != null) {
            ARRAY tmpObj = (ARRAY)this.pickler.unlinearize(bytes, 0L, null, 1, null);
            ret = this.toResultSet(tmpObj, tmpObj, 1L, -1, map2, false);
        }
        return ret;
    }

    public ResultSet toResultSet(byte[] bytes, long index, int count2, Map map2) throws SQLException {
        ResultSet ret = null;
        if (bytes != null) {
            ARRAY tmpObj = (ARRAY)this.pickler.unlinearize(bytes, 0L, null, 1, null);
            ret = this.toResultSet(tmpObj, tmpObj, index, count2, map2, false);
        }
        return ret;
    }

    @Override
    String tagName() {
        return "ArrayDescriptor";
    }

    public static int getCacheStyle(OracleArray array) throws SQLException {
        int ret = 2;
        if (array.getAutoIndexing() && (array.getAccessDirection() == 2 || array.getAccessDirection() == 3)) {
            ret = 1;
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

