/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.BOOLEAN;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

public class ANYDATA
implements ORAData,
OracleData {
    static final byte KAD_VSN = 1;
    static final byte KAD_VSN2 = 2;
    boolean isNull;
    byte[] data;
    TypeDescriptor type;
    boolean isREF = false;
    short serverCharsetId = 0;
    short serverNCharsetId = 0;
    OracleConnection connection;

    ANYDATA(TypeDescriptor _type, boolean _isNull, byte[] _data, boolean _isREF) {
        this.type = _type;
        this.isNull = _isNull;
        this.data = _data;
        this.isREF = _isREF;
    }

    public ANYDATA(OPAQUE datum) throws SQLException {
        byte[] image = datum.getBytesValue();
        this.connection = datum.getPhysicalConnection();
        if (this.connection != null) {
            this.serverCharsetId = this.connection.getDbCsId();
            this.serverNCharsetId = this.connection.getNCharSet();
        }
        this.unpickle(image, 0);
    }

    int unpickle(byte[] pickledBytes, int offset) throws SQLException {
        PickleContext context = new PickleContext(pickledBytes, offset);
        byte version2 = context.readByte();
        if (version2 == 2) {
            context.skipBytes(4);
        }
        short[] rdbmsTypeCode = new short[1];
        this.type = TypeDescriptor.unpickleOpaqueTypeImage(context, this.connection, rdbmsTypeCode);
        this.isNull = context.readByte() != 0;
        if (!this.isNull) {
            int dataLength = (int)context.readUB4();
            this.data = context.readDataValue(dataLength);
        }
        this.isREF = rdbmsTypeCode[0] == 110;
        int ret = context.offset();
        return ret;
    }

    int pickle(byte[] buffer, int offset) {
        buffer[offset++] = 1;
        offset = this.type.pickleOpaqueTypeImage(buffer, offset, this.isREF);
        buffer[offset++] = this.isNull ? (byte)1 : 0;
        if (!this.isNull) {
            int dataLength = this.data.length;
            buffer[offset++] = (byte)((dataLength & 0xFF000000) >> 24 & 0xFF);
            buffer[offset++] = (byte)((dataLength & 0xFF0000) >> 16 & 0xFF);
            buffer[offset++] = (byte)((dataLength & 0xFF00) >> 8 & 0xFF);
            buffer[offset++] = (byte)(dataLength & 0xFF);
            System.arraycopy(this.data, 0, buffer, offset, dataLength);
            offset += dataLength;
        }
        return offset;
    }

    int getImageSize() {
        int imageSize = this.type.getOpaqueImageTypeSize() + 1 + 1;
        if (!this.isNull) {
            imageSize += 4 + this.data.length;
        }
        return imageSize;
    }

    @Override
    public Datum toDatum(Connection c) throws SQLException {
        if (c instanceof OracleConnectionWrapper) {
            oracle.jdbc.OracleConnection oracleConnection = ((OracleConnectionWrapper)c).unwrap();
            this.connection = (OracleConnection)oracleConnection;
        } else {
            this.connection = (OracleConnection)c;
        }
        OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", c);
        byte[] image = new byte[this.getImageSize()];
        this.pickle(image, 0);
        OPAQUE opq = new OPAQUE(desc, this.connection, image);
        opq.setShareBytes(opq.toBytes());
        return opq;
    }

    @Override
    public Object toJDBCObject(Connection c) throws SQLException {
        return this.toDatum(c);
    }

    public static ANYDATA convertDatum(Datum datum) throws SQLException {
        ANYDATA ret = null;
        if (datum != null) {
            if (datum instanceof STRUCT) {
                ret = new ANYDATA(((STRUCT)datum).getDescriptor(), false, ((STRUCT)datum).toBytes(), false);
            } else if (datum instanceof ARRAY) {
                ret = new ANYDATA(((ARRAY)datum).getDescriptor(), false, ((ARRAY)datum).toBytes(), false);
            } else if (datum instanceof REF) {
                ret = new ANYDATA(((REF)datum).getDescriptor(), false, ((REF)datum).getBytes(), true);
            } else if (datum instanceof OPAQUE) {
                ret = new ANYDATA(((OPAQUE)datum).getDescriptor(), false, ((OPAQUE)datum).toBytes(), false);
            } else {
                TypeDescriptor type = null;
                if (datum instanceof NUMBER) {
                    type = new TypeDescriptor(2);
                } else if (datum instanceof DATE) {
                    type = new TypeDescriptor(12);
                } else if (datum instanceof INTERVALDS) {
                    type = new TypeDescriptor(190);
                } else if (datum instanceof INTERVALYM) {
                    type = new TypeDescriptor(189);
                } else if (datum instanceof TIMESTAMPTZ) {
                    type = new TypeDescriptor(188);
                } else if (datum instanceof TIMESTAMPLTZ) {
                    type = new TypeDescriptor(232);
                } else if (datum instanceof TIMESTAMP) {
                    type = new TypeDescriptor(187);
                } else if (datum instanceof NCLOB) {
                    type = new TypeDescriptor(288);
                } else if (datum instanceof CLOB) {
                    type = new TypeDescriptor(112);
                } else if (datum instanceof BLOB) {
                    type = new TypeDescriptor(113);
                } else if (datum instanceof BFILE) {
                    type = new TypeDescriptor(114);
                } else if (datum instanceof RAW) {
                    type = new TypeDescriptor(95);
                } else if (datum instanceof BINARY_DOUBLE) {
                    type = new TypeDescriptor(101);
                } else if (datum instanceof BINARY_FLOAT) {
                    type = new TypeDescriptor(100);
                } else if (datum instanceof ROWID) {
                    type = new TypeDescriptor(104);
                } else if (datum instanceof BOOLEAN) {
                    type = new TypeDescriptor(252);
                } else if (datum instanceof CHAR) {
                    type = ((CHAR)datum).isVariableLength() ? new TypeDescriptor(9) : new TypeDescriptor(96);
                }
                if (datum instanceof ROWID) {
                    byte[] base64rowid = datum.shareBytes();
                    long[] riddef = InternalFactory.rowid2urowid(base64rowid, 0, base64rowid.length);
                    byte[] riddefBytes = new byte[]{1, (byte)((riddef[0] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[0] & 0xFF0000L) >> 16), (byte)((riddef[0] & 0xFF00L) >> 8), (byte)(riddef[0] & 0xFFL), (byte)((riddef[1] & 0xFF00L) >> 8), (byte)(riddef[1] & 0xFFL), (byte)((riddef[2] & 0xFFFFFFFFFF000000L) >> 24), (byte)((riddef[2] & 0xFF0000L) >> 16), (byte)((riddef[2] & 0xFF00L) >> 8), (byte)(riddef[2] & 0xFFL), (byte)((riddef[3] & 0xFF00L) >> 8), (byte)(riddef[3] & 0xFFL)};
                    ret = new ANYDATA(type, false, riddefBytes, false);
                } else {
                    ret = new ANYDATA(type, false, datum.shareBytes(), false);
                }
            }
            if (datum instanceof DatumWithConnection) {
                ret.connection = ((DatumWithConnection)datum).getInternalConnection();
            }
        }
        return ret;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.type;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isREF() {
        return this.isREF;
    }

    public String stringValue() throws SQLException {
        return this.stringValue(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String stringValue(Connection _connection) throws SQLException {
        String ret = null;
        ret = "ANYDATA TypeCode: \"" + this.getTypeDescriptor().getTypeCodeName();
        if (this.isREF) {
            ret = ret + "(REF)";
        }
        ret = ret + "\" - ANYDATA Value: \"";
        Datum dd = this.accessDatum();
        boolean gotStringValueFromDataum = false;
        try {
            ret = ret + dd.stringValue();
            gotStringValueFromDataum = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!gotStringValueFromDataum) {
            if (!(this.type.getInternalTypeCode() != 108 && this.type.getInternalTypeCode() != 110 || this.type.isTransient())) {
                ret = ret + ((StructDescriptor)this.type).getName() + "(...)";
            } else if (this.type.getInternalTypeCode() == 122 && !this.type.isTransient()) {
                ret = ret + ((ArrayDescriptor)this.type).getName() + "(...)";
            } else {
                switch (this.type.getInternalTypeCode()) {
                    case 113: {
                        int c;
                        InputStream is = ((BLOB)dd).getBinaryStream();
                        Object ret3232322322 = "";
                        while ((c = is.read()) != -1) {
                            ret3232322322 = (String)ret3232322322 + Integer.toHexString(c);
                        }
                        ret = ret + (String)ret3232322322;
                        try {
                            is.close();
                        }
                        catch (IOException ret3232322322) {}
                        break;
                        catch (IOException ret3232322322) {
                            try {
                                is.close();
                            }
                            catch (IOException ret3232322322) {}
                            break;
                            catch (Throwable throwable) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    }
                    case 188: {
                        if (_connection == null) {
                            ret = ret + "?";
                            break;
                        }
                        ret = ret + ((TIMESTAMPTZ)dd).stringValue(_connection);
                        break;
                    }
                    case 232: {
                        if (_connection == null) {
                            ret = ret + "?";
                            break;
                        }
                        ret = ret + ((TIMESTAMPLTZ)dd).stringValue(_connection);
                        break;
                    }
                    case 114: {
                        ret = ret + "bfile_dir=" + ((BFILE)dd).getDirAlias() + " bfile_name=" + ((BFILE)dd).getName();
                        break;
                    }
                    case 58: {
                        OPAQUE opaque = (OPAQUE)dd;
                        String typeName = opaque.getSQLTypeName();
                        ret = ret + "OPAQUE(" + typeName + ")";
                        if (typeName.compareTo("SYS.XMLTYPE") != 0) break;
                        ret = ret + ":";
                        XMLType xxmltype = XMLType.createXML((OPAQUE)opaque);
                        ret = ret + xxmltype.getStringVal();
                    }
                }
            }
        }
        ret = ret + "\"";
        return ret;
    }

    public Datum accessDatum() throws SQLException {
        Datum o = null;
        if (!this.isNull) {
            short internalTypeCode = this.type.getInternalTypeCode();
            switch (internalTypeCode) {
                case 58: {
                    o = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                    break;
                }
                case 108: {
                    if (this.type instanceof OpaqueDescriptor) {
                        o = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    if (!this.isREF) {
                        o = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
                        break;
                    }
                    o = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                    break;
                }
                case 122: {
                    o = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
                    break;
                }
                case 110: {
                    o = new REF((StructDescriptor)this.type, (Connection)this.connection, this.data);
                    break;
                }
                case 2: {
                    o = new NUMBER(this.data);
                    break;
                }
                case 12: {
                    o = new DATE(this.data);
                    break;
                }
                case 190: {
                    o = new INTERVALDS(this.data);
                    break;
                }
                case 189: {
                    o = new INTERVALYM(this.data);
                    break;
                }
                case 188: {
                    o = new TIMESTAMPTZ(this.data);
                    break;
                }
                case 232: {
                    o = new TIMESTAMPLTZ(this.data);
                    break;
                }
                case 187: {
                    o = new TIMESTAMP(this.data);
                    break;
                }
                case 252: {
                    o = new BOOLEAN(this.data);
                    break;
                }
                case 112: {
                    o = new CLOB(this.connection, this.data);
                    break;
                }
                case 288: {
                    o = new NCLOB(this.connection, this.data);
                    break;
                }
                case 113: {
                    o = new BLOB(this.connection, this.data);
                    break;
                }
                case 114: {
                    o = new BFILE(this.connection, this.data);
                    break;
                }
                case 95: {
                    o = new RAW(this.data);
                    break;
                }
                case 101: {
                    o = new BINARY_DOUBLE(this.data);
                    break;
                }
                case 100: {
                    o = new BINARY_FLOAT(this.data);
                    break;
                }
                case 104: {
                    long rba = ((long)this.data[1] & 0xFFL) << 24 | ((long)this.data[2] & 0xFFL) << 16 | ((long)this.data[3] & 0xFFL) << 8 | (long)this.data[4] & 0xFFL;
                    long partitionId = ((long)this.data[5] & 0xFFL) << 8 | (long)this.data[6] & 0xFFL;
                    long blockNumber = ((long)this.data[7] & 0xFFL) << 24 | ((long)this.data[8] & 0xFFL) << 16 | ((long)this.data[9] & 0xFFL) << 8 | (long)this.data[10] & 0xFFL;
                    long slotNumber = ((long)this.data[11] & 0xFFL) << 8 | (long)this.data[12] & 0xFFL;
                    long[] urowid = new long[]{rba, partitionId, blockNumber, slotNumber};
                    byte[] rowidBase64 = InternalFactory.urowid2rowid(urowid);
                    o = new ROWID(rowidBase64);
                    break;
                }
                case 1: 
                case 9: 
                case 96: {
                    o = this.serverCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverCharsetId)) : new CHAR(this.data, null);
                    if (internalTypeCode != 1 && internalTypeCode != 9) break;
                    ((CHAR)o).setVariableLength(true);
                    break;
                }
                case 286: 
                case 287: {
                    o = this.serverNCharsetId != 0 ? new CHAR(this.data, CharacterSet.make(this.serverNCharsetId)) : new CHAR(this.data, null);
                    if (internalTypeCode != 287) break;
                    ((CHAR)o).setVariableLength(true);
                    break;
                }
                default: {
                    String messageXXX = "internal typecode: " + internalTypeCode;
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, messageXXX).fillInStackTrace();
                }
            }
        }
        return o;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

