/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.AbstractAdapter;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.NTAdapter;

public class SdpNTAdapter
extends AbstractAdapter {
    static final boolean DEBUG = false;
    static final String SDP_SOCKET_CLASS_NAME = "com.oracle.net.Sdp";
    static Method OPEN_SOCKET = null;
    static Method OPEN_SOCKET_CHANNEL = null;
    private SocketChannel socketChannel;
    private InetSocketAddress inetSocketAddress;
    int count;
    int attempts;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
    private static Hashtable<String, Integer> circularOffsets = new Hashtable();
    private static final Monitor CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();

    private static Socket getSDPSocket() throws IOException {
        if (OPEN_SOCKET == null) {
            try {
                Class<?> sdp = Class.forName(SDP_SOCKET_CLASS_NAME);
                OPEN_SOCKET = sdp.getMethod("openSocket", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("SDP enabled, but SDP socket class not in classpath", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("SDP enabled but unable to get SDP socket class", ex);
            }
        }
        try {
            return (Socket)OPEN_SOCKET.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IOException("SDP enabled, but SDP.openSocket raised an exception", ex);
        }
    }

    private static SocketChannel getSDPSocketChannel() throws IOException {
        if (OPEN_SOCKET_CHANNEL == null) {
            try {
                Class<?> sdp = Class.forName(SDP_SOCKET_CLASS_NAME);
                OPEN_SOCKET_CHANNEL = sdp.getMethod("openSocketChannel", new Class[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("SDP enabled, but SDP socket class not in classpath", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IOException("SDP enabled but unable to get SDP socket class", ex);
            }
        }
        try {
            return (SocketChannel)OPEN_SOCKET_CHANNEL.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IOException("SDP enabled, but SDP.openSocket raised an exception", ex);
        }
    }

    public SdpNTAdapter(String address, ConnOption connOption, @Blind(value=PropertiesBlinder.class) Properties socketOptions) throws NLException {
        this.socketOptions = socketOptions;
        this.inetSocketAddress = connOption.inetSocketAddress;
        this.host = connOption.host;
        this.port = connOption.port;
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException {
        String c_timeout = (String)this.socketOptions.get(2);
        Boolean useNio = Boolean.parseBoolean((String)this.socketOptions.get(20));
        long socketConnectStartTime = System.currentTimeMillis();
        if (!useNio.booleanValue()) {
            this.socket = SdpNTAdapter.getSDPSocket();
        }
        try {
            if (useNio.booleanValue()) {
                this.socketChannel = SdpNTAdapter.getSDPSocketChannel();
                this.socket = this.socketChannel.socket();
            }
            this.socket.connect(this.inetSocketAddress, Integer.parseInt(c_timeout));
        }
        catch (IOException ea) {
            DownHostsCache.getInstance().markDownHost(this.inetSocketAddress.getAddress(), this.port);
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String newExMessage = String.format("%s, socket connect lapse %d ms. %s %d %s %d %s", ea.getMessage(), System.currentTimeMillis() - socketConnectStartTime, this.inetSocketAddress.getHostString(), this.port, c_timeout, this.count, useNio);
            IOException newEx = new IOException(newExMessage, ea);
            throw newEx;
        }
        this.setOption(3, c_timeout);
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        String temp = (String)this.socketOptions.get(0);
        if (temp != null) {
            this.setOption(0, temp);
        }
        if ((temp = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, temp);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int option2, Object value) throws IOException, NetException {
        switch (option2) {
            case 0: {
                String tmp = (String)value;
                this.socket.setTcpNoDelay(tmp.equals("YES"));
                break;
            }
            case 1: {
                String tmp = (String)value;
                if (!tmp.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.readTimeout = Integer.parseInt((String)value);
                this.socket.setSoTimeout(this.readTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int option2) throws IOException, NetException {
        switch (option2) {
            case 101: {
                return "" + this.readTimeout;
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int urgentData) throws IOException {
        this.socket.sendUrgentData(urgentData);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties prop) throws IOException, NetException {
        String tmp = (String)prop.get("oracle.net.READ_TIMEOUT");
        if (tmp == null) {
            tmp = "0";
        }
        this.setOption(3, tmp);
    }

    private static final InetAddress[] getAddressesInCircularOrder(String hostname, InetAddress[] inetAddressesFromJVM) {
        try (Monitor.CloseableLock lock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] cachedAddresses = inetaddressesCache.get(hostname);
            Integer offset = circularOffsets.get(hostname);
            if (cachedAddresses == null || !SdpNTAdapter.areEquals(cachedAddresses, inetAddressesFromJVM)) {
                offset = new Integer(0);
                cachedAddresses = inetAddressesFromJVM;
                inetaddressesCache.put(hostname, inetAddressesFromJVM);
                circularOffsets.put(hostname, offset);
            }
            InetAddress[] addrb = SdpNTAdapter.getCopyAddresses(cachedAddresses, offset);
            circularOffsets.put(hostname, new Integer((offset + 1) % cachedAddresses.length));
            InetAddress[] inetAddressArray = addrb;
            return inetAddressArray;
        }
    }

    private static final boolean areEquals(InetAddress[] add1, InetAddress[] add2) {
        if (add1.length != add2.length) {
            return false;
        }
        for (int i = 0; i < add1.length; ++i) {
            if (add1[i].equals(add2[i])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] add, int nbOfRotation) {
        InetAddress[] addcp = new InetAddress[add.length];
        for (int i = 0; i < add.length; ++i) {
            addcp[i] = add[(i + nbOfRotation) % add.length];
        }
        return addcp;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.SDP;
    }
}

