/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.net.ns.Message;

public class NetErrorMessage
implements Message,
Serializable {
    private static final boolean DEBUG = false;
    private String msg;
    private transient ResourceBundle rBundle;
    private static final String messageFile = "oracle.net.mesg.NetErrorMessages";

    @Override
    public String getMessage(int errorNumber, String userMsg) {
        try {
            this.rBundle = ResourceBundle.getBundle(messageFile);
        }
        catch (Exception e) {
            return "Message file 'oracle.net.mesg.NetErrorMessages' is missing.";
        }
        try {
            String key = String.format("%05d", errorNumber);
            if (userMsg != null && !userMsg.trim().isEmpty() && userMsg.contains("ORA-")) {
                this.msg = userMsg;
            } else {
                String _userMsg = userMsg == null || userMsg.trim().isEmpty() ? "" : ": " + userMsg;
                this.msg = "ORA-" + key + ": " + this.rBundle.getString(key) + _userMsg;
            }
        }
        catch (MissingResourceException e) {
            this.msg = userMsg == null || userMsg.trim().isEmpty() ? "ORA-18957: " + this.rBundle.getString(String.valueOf(18957)) + String.format("%05d", errorNumber) : (userMsg.contains("" + errorNumber) ? userMsg : "ORA-" + String.format("%05d", errorNumber) + ": " + userMsg);
        }
        return this.msg;
    }

    @Override
    public String addArgs(String errMsg, Object ... args2) {
        errMsg = MessageFormat.format(errMsg, args2);
        return errMsg;
    }
}

