/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

public class RepConversion {
    public static void printInHex(byte b) {
        System.out.print((char)RepConversion.nibbleToHex((byte)((b & 0xF0) >> 4)));
        System.out.print((char)RepConversion.nibbleToHex((byte)(b & 0xF)));
    }

    public static byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    public static byte asciiHexToNibble(byte b) {
        byte value = b >= 97 && b <= 102 ? (byte)(b - 97 + 10) : (b >= 65 && b <= 70 ? (byte)(b - 65 + 10) : (b >= 48 && b <= 57 ? (byte)(b - 48) : b));
        return value;
    }

    public static void bArray2nibbles(byte[] array, byte[] nibbles) {
        for (int i = 0; i < array.length; ++i) {
            nibbles[i * 2] = RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4));
            nibbles[i * 2 + 1] = RepConversion.nibbleToHex((byte)(array[i] & 0xF));
        }
    }

    public static String bArray2String(byte[] array) {
        StringBuffer result2 = new StringBuffer(array.length * 2);
        for (int i = 0; i < array.length; ++i) {
            result2.append((char)RepConversion.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
            result2.append((char)RepConversion.nibbleToHex((byte)(array[i] & 0xF)));
        }
        return result2.toString();
    }

    public static byte[] nibbles2bArray(byte[] nibbles) {
        byte[] array = new byte[nibbles.length / 2];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)(RepConversion.asciiHexToNibble(nibbles[i * 2]) << 4);
            int n = i;
            array[n] = (byte)(array[n] | RepConversion.asciiHexToNibble(nibbles[i * 2 + 1]));
        }
        return array;
    }

    public static void printInHex(long value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static void printInHex(int value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static void printInHex(short value) {
        byte[] hexValue = RepConversion.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static byte[] toHex(long value) {
        int lsize = 16;
        byte[] hex = new byte[lsize];
        for (int i = lsize - 1; i >= 0; --i) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & 0xFL));
            value >>= 4;
        }
        return hex;
    }

    public static byte[] toHex(int value) {
        int lsize = 8;
        byte[] hex = new byte[lsize];
        for (int i = lsize - 1; i >= 0; --i) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value >>= 4;
        }
        return hex;
    }

    public static byte[] toHex(short value) {
        int lsize = 4;
        byte[] hex = new byte[lsize];
        for (int i = lsize - 1; i >= 0; --i) {
            hex[i] = RepConversion.nibbleToHex((byte)(value & 0xF));
            value = (short)(value >> 4);
        }
        return hex;
    }
}

