/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class Address
implements SchemaObject {
    public String addr;
    public String prot;
    public String host;
    public int port;
    public String httpsProxy;
    public int httpsProxyPort;
    public String webSocketURI;
    protected SchemaObjectFactoryInterface f = null;

    public Address(SchemaObjectFactoryInterface f2) {
        this.f = f2;
    }

    @Override
    public int isA() {
        return 0;
    }

    @Override
    public String isA_String() {
        return "ADDRESS";
    }

    @Override
    public void initFromString(String s2) throws NLException, SOException {
        NVPair nvp = new NVFactory().createNVPair(s2);
        this.initFromNVPair(nvp);
    }

    @Override
    public void initFromNVPair(NVPair nvp) throws SOException {
        NVPair nvpWebSockUri;
        this.init();
        if (nvp == null || !nvp.getName().equalsIgnoreCase("address")) {
            throw new SOException("Null or unexpected name");
        }
        NVNavigator nav = new NVNavigator();
        NVPair protnvp = nav.findNVPair(nvp, "PROTOCOL");
        if (protnvp == null || protnvp.getAtom() == null) {
            throw new SOException("PROTOCOL is not specified");
        }
        this.prot = protnvp.getAtom();
        NVPair nvpHost = nav.findNVPair(nvp, "HOST");
        this.host = nvpHost != null ? nvpHost.getAtom() : null;
        NVPair nvpPort = nav.findNVPair(nvp, "PORT");
        if (nvpPort != null && nvpPort.getAtom() != null) {
            try {
                this.port = Integer.parseInt(nvpPort.getAtom());
            }
            catch (Exception e) {
                throw new SOException(new NetException(17866, nvpPort.getAtom()).getMessage());
            }
        } else {
            this.port = this.prot.equalsIgnoreCase("beq") ? 0 : 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new SOException(new NetException(17866, String.valueOf(this.port)).getMessage());
        }
        NVPair nvpHttpProxy = nav.findNVPair(nvp, "HTTPS_PROXY");
        NVPair nvpHttpProxyPort = nav.findNVPair(nvp, "HTTPS_PROXY_PORT");
        if (nvpHttpProxy != null) {
            this.httpsProxy = nvpHttpProxy.getAtom();
        }
        if (this.httpsProxy != null && nvpHttpProxyPort != null) {
            this.httpsProxyPort = Integer.parseInt(nvpHttpProxyPort.getAtom());
        }
        if ((nvpWebSockUri = nav.findNVPair(nvp, "WEBSOCK_URI")) != null) {
            this.webSocketURI = nvpWebSockUri.getAtom();
        }
        if (this.addr == null) {
            this.addr = nvp.toString();
        }
    }

    @Override
    public String toString() {
        Object s2 = new String("");
        if (this.host != null) {
            s2 = (String)s2 + "(HOST=" + this.host + ")";
        }
        if (this.port != 0) {
            s2 = (String)s2 + "(PORT=" + this.port + ")";
        }
        if (this.prot != null) {
            s2 = (String)s2 + "(PROTOCOL=" + this.prot + ")";
        }
        if (s2 != "") {
            s2 = "(ADDRESS=" + (String)s2 + ")";
        }
        return s2;
    }

    public String getProtocol() {
        return this.prot;
    }

    protected void init() {
        this.addr = null;
        this.prot = null;
        this.httpsProxy = null;
        this.httpsProxyPort = -1;
        this.port = 0;
        this.host = null;
        this.webSocketURI = null;
    }
}

