/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import java.util.Arrays;
import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionEngine;
import oracle.net.aso.PaddedCipher;

class OraclePadding
extends PaddedCipher {
    private final byte[] tempBuffer;

    OraclePadding(int blockSize, EncryptionEngine engine, CipherBlockProcessor blockProcessor) {
        super(blockSize, engine, blockProcessor);
        this.tempBuffer = new byte[blockSize];
    }

    @Override
    public byte[] encrypt(byte[] buffer) throws AsoException {
        int length = buffer.length;
        byte padding = (byte)(length % this.blockSize == 0 ? 0 : this.blockSize - length % this.blockSize);
        int elength = length + padding;
        byte[] result2 = new byte[elength + 1];
        if (this.coreEngine.canProcessBulk(elength)) {
            byte[] input = new byte[elength];
            System.arraycopy(buffer, 0, input, 0, length);
            this.coreEngine.encrypt(input, 0, elength, result2);
        } else {
            for (int i = 0; i < length; i += this.blockSize) {
                if (i <= length - this.blockSize) {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, this.blockSize);
                } else {
                    System.arraycopy(buffer, i, this.tempBuffer, 0, buffer.length - i);
                    Arrays.fill(this.tempBuffer, buffer.length - i, this.blockSize, (byte)0);
                }
                byte[] output = this.blockProcessor.encrypt(this.tempBuffer);
                System.arraycopy(output, 0, result2, i, this.blockSize);
            }
        }
        result2[elength] = (byte)(padding + 1);
        return result2;
    }

    @Override
    public byte[] decrypt(byte[] ebuffer) throws AsoException {
        int encryptedDataLength = ebuffer.length;
        byte padding = ebuffer[encryptedDataLength - 1];
        if (padding < 0 || padding > this.blockSize) {
            throw new RuntimeException("Invalid padding value");
        }
        int actualDataLength = encryptedDataLength - padding;
        byte[] result2 = new byte[actualDataLength];
        if (this.coreEngine.canProcessBulk(encryptedDataLength - 1)) {
            byte[] temp = new byte[encryptedDataLength - 1];
            this.coreEngine.decrypt(ebuffer, 0, encryptedDataLength - 1, temp);
            System.arraycopy(temp, 0, result2, 0, actualDataLength);
        } else {
            for (int i = 0; i < encryptedDataLength - 1; i += this.blockSize) {
                System.arraycopy(ebuffer, i, this.tempBuffer, 0, this.blockSize);
                byte[] output = this.blockProcessor.decrypt(this.tempBuffer);
                System.arraycopy(output, 0, result2, i, Math.min(this.blockSize, actualDataLength - i));
            }
        }
        return result2;
    }
}

