/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import oracle.net.aso.AsoException;
import oracle.net.aso.CipherBlockProcessor;
import oracle.net.aso.EncryptionAlgorithm;
import oracle.net.aso.EncryptionEngine;

class CBCBlockProcessor
implements CipherBlockProcessor {
    private byte[] fbreg;
    private final EncryptionEngine engine;
    private final int blockSize;
    private final byte[] tempBuffer;

    CBCBlockProcessor(byte[] iv, EncryptionEngine engine, int blockSize) {
        this.fbreg = iv == null ? iv : (byte[])iv.clone();
        this.engine = engine;
        this.blockSize = blockSize;
        this.tempBuffer = new byte[blockSize];
    }

    @Override
    public byte[] encrypt(byte[] plainData) throws AsoException {
        EncryptionAlgorithm.byteOperation(this.tempBuffer, this.fbreg, plainData, 2, this.blockSize);
        byte[] result2 = this.engine.encrypt(this.tempBuffer);
        EncryptionAlgorithm.byteOperation(this.fbreg, result2, null, 3, this.blockSize);
        return result2;
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) throws AsoException {
        EncryptionAlgorithm.byteOperation(this.tempBuffer, encryptedData, null, 3, this.blockSize);
        byte[] result2 = this.engine.decrypt(encryptedData);
        EncryptionAlgorithm.byteOperation(result2, this.fbreg, result2, 2, this.blockSize);
        EncryptionAlgorithm.byteOperation(this.fbreg, this.tempBuffer, null, 3, this.blockSize);
        return result2;
    }

    @Override
    public int encrypt(byte[] plainData, int offset, int length, byte[] resultBuffer) throws AsoException {
        throw new RuntimeException("Unsupported Operation");
    }

    @Override
    public int decrypt(byte[] encryptedData, int offset, int length, byte[] resultBuffer) throws AsoException {
        throw new RuntimeException("Unsupported Operation");
    }

    @Override
    public void resetIV(byte[] iv) {
        this.fbreg = iv == null ? iv : (byte[])iv.clone();
    }
}

