/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ano.Service;
import oracle.net.aso.DataIntegrityAlgorithm;
import oracle.net.aso.DiffieHellman;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataIntegrityService
extends Service
implements SQLnetDef {
    private static final String CLASS_NAME = DataIntegrityService.class.getName();
    static final String[] DATAINTEGRITY_JAVA_ANO_ID = new String[]{"", "SHA1", "SHA512", "SHA256", "SHA384"};
    private static final byte[] DATAINTEGRITY_ORACLE_ID = new byte[]{0, 3, 4, 5, 6};
    private boolean checkSummingActivated = false;
    private byte[] clientPK;
    static final int NUM_DATAINTEGRITY_SUBPACKETS = 2;

    @Override
    int init(SessionAtts sAtts) throws NetException {
        int i;
        super.init(sAtts);
        this.service = 3;
        this.level = sAtts.profile.getDataIntegrityLevelNum();
        String[] userChoiceDrivers = sAtts.profile.getDataIntegrityServices();
        userChoiceDrivers = this.removeWeakChecksumDrivers(userChoiceDrivers);
        userChoiceDrivers = this.getValidUserChoices(userChoiceDrivers, DATAINTEGRITY_JAVA_ANO_ID);
        this.userChoiceDriversId = new int[userChoiceDrivers.length];
        for (i = 0; i < this.userChoiceDriversId.length; ++i) {
            this.userChoiceDriversId[i] = this.getDriverID(DATAINTEGRITY_JAVA_ANO_ID, userChoiceDrivers[i]);
        }
        this.userChoiceDriversId = this.createDriversListWithLevel(this.userChoiceDriversId, this.level);
        this.selectedDrivers = new byte[this.userChoiceDriversId.length];
        for (i = 0; i < this.selectedDrivers.length; ++i) {
            this.selectedDrivers[i] = DATAINTEGRITY_ORACLE_ID[this.userChoiceDriversId[i]];
        }
        int flags = 1;
        if (this.userChoiceDriversId.length == 0) {
            if (this.level == 3) {
                throw new NetException(18915);
            }
            flags |= 8;
        } else if (this.level == 3) {
            flags |= 0x10;
        }
        return flags;
    }

    private String[] removeWeakChecksumDrivers(String[] userChoiceDrivers) throws NetException {
        if (userChoiceDrivers == null || userChoiceDrivers.length == 0) {
            return userChoiceDrivers;
        }
        ArrayList<String> strongChecksumDrivers = new ArrayList<String>();
        for (String driver : userChoiceDrivers) {
            if ("MD5".equalsIgnoreCase(driver)) continue;
            strongChecksumDrivers.add(driver);
        }
        if (this.level != 1 && strongChecksumDrivers.size() == 0) {
            throw new NetException(18903, (String)this.sAtts.profile.get("oracle.net.crypto_checksum_types_client"));
        }
        return strongChecksumDrivers.toArray(new String[strongChecksumDrivers.size()]);
    }

    @Override
    void receiveServiceData(int numSubPackets) throws NetException, IOException {
        this.version = this.comm.receiveVersion();
        this.sAtts.profile.setANOVersion(this.version);
        short receiveDriverId = this.comm.receiveUB1();
        this.algID = (short)-1;
        for (int i = 0; i < DATAINTEGRITY_JAVA_ANO_ID.length; ++i) {
            if (DATAINTEGRITY_ORACLE_ID[i] != receiveDriverId) continue;
            this.algID = (short)i;
        }
        if (numSubPackets != 2 && numSubPackets == 8) {
            short ebits = (short)this.comm.receiveUB2();
            short mbits = (short)this.comm.receiveUB2();
            byte[] base = this.comm.receiveRaw();
            byte[] modulus = this.comm.receiveRaw();
            byte[] svrPK = this.comm.receiveRaw();
            byte[] iv = this.comm.receiveRaw();
            if (ebits <= 0 || mbits <= 0) {
                throw new IOException("Bad parameters from server");
            }
            int key_size = (mbits + 7) / 8;
            if (svrPK.length != key_size || modulus.length != key_size) {
                throw new IOException("DiffieHellman negotiation out of synch");
            }
            if (!(this.sAtts.profile.isWeakCryptoEnabled() || modulus.length >= 256 && base.length >= 256 && svrPK.length >= 256)) {
                this.debug(Level.WARNING, SecurityLabel.INTERNAL, CLASS_NAME, "receiveServiceData", "Received weak DiffieHellman initialization parameters from server.", null, null);
                throw new NetException(12268);
            }
            DiffieHellman dh = DiffieHellman.newInstance(base, modulus, ebits, mbits, this.sAtts.profile.isFIPSMode());
            this.clientPK = dh.getPublicKey(this.sAtts.profile.useWeakCrypto());
            this.sAtts.ano.setClientPK(this.clientPK);
            byte[] dhSessionKey = dh.getSessionKey(svrPK, svrPK.length);
            this.sAtts.ano.setSessionKey(dhSessionKey);
            this.sAtts.ano.setInitializationVector(iv);
        }
        this.checkSummingActivated = this.algID > 0;
    }

    @Override
    void validateResponse() throws NetException, IOException {
        if (this.algID < 0) {
            throw new NetException(18919);
        }
        if (this.checkSummingActivated) {
            if (this.sAtts.profile.isServerUsingWeakCrypto() && !this.sAtts.profile.isWeakCryptoEnabled()) {
                throw new NetException(12268);
            }
        } else if (this.level == 3) {
            throw new NetException(18921, "Checksumming is REQUIRED but activation failed.");
        }
        for (int i = 0; i < this.userChoiceDriversId.length; ++i) {
            if (this.userChoiceDriversId[i] != this.algID) continue;
            return;
        }
        throw new NetException(18919);
    }

    @Override
    public boolean isActive() {
        return this.checkSummingActivated;
    }

    @Override
    void activateAlgorithm() throws NetException, IOException {
        if (this.checkSummingActivated) {
            this.ano.dataIntegrityAlg = new DataIntegrityAlgorithm(this.ano.getSessionKey(), this.ano.getInitializationVector(), this.ano.getDataIntegrityName(), this.sAtts.profile.useWeakCrypto());
            this.sAtts.isChecksumActive = true;
        }
    }

    public static void printInHex(int value) {
        byte[] hexValue = DataIntegrityService.toHex(value);
        System.out.print(new String(hexValue));
    }

    public static byte[] toHex(int value) {
        int lsize = 8;
        byte[] hex = new byte[lsize];
        for (int i = lsize - 1; i >= 0; --i) {
            hex[i] = DataIntegrityService.nibbleToHex((byte)(value & 0xF));
            value >>= 4;
        }
        return hex;
    }

    public static byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    public static String bArray2String(byte[] array) {
        StringBuffer result2 = new StringBuffer(array.length * 2);
        for (int i = 0; i < array.length; ++i) {
            result2.append((char)DataIntegrityService.nibbleToHex((byte)((array[i] & 0xF0) >> 4)));
            result2.append((char)DataIntegrityService.nibbleToHex((byte)(array[i] & 0xF)));
        }
        return result2.toString();
    }
}

