/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;

public class Util {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public static Object convertToObject(Datum d, int sqlType, Object f2) throws SQLException {
        Object result2 = Util._convertToObject(d, sqlType, f2);
        return result2;
    }

    public static Object _convertToObject(Datum d, int sqlType, Object f2) throws SQLException {
        if (d == null) {
            return null;
        }
        if (d instanceof STRUCT) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d, 2002);
            }
            return ((CustomDatumFactory)f2).create(d, 2002);
        }
        if (d instanceof REF) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d, 2006);
            }
            return ((CustomDatumFactory)f2).create(d, 2006);
        }
        if (d instanceof ARRAY) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d, 2003);
            }
            return ((CustomDatumFactory)f2).create(d, 2003);
        }
        if (d instanceof OPAQUE) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d, 2007);
            }
            return ((CustomDatumFactory)f2).create(d, 2007);
        }
        if (f2 != null) {
            if (f2 instanceof ORADataFactory) {
                return ((ORADataFactory)f2).create(d, sqlType);
            }
            return ((CustomDatumFactory)f2).create(d, sqlType);
        }
        if (d instanceof NUMBER) {
            if (sqlType == 2 || sqlType == 3) {
                return ((NUMBER)d).bigDecimalValue();
            }
            if (sqlType == 8 || sqlType == 6) {
                return ((NUMBER)d).doubleValue();
            }
            if (sqlType == 4 || sqlType == 5) {
                return ((NUMBER)d).intValue();
            }
            if (sqlType == 7) {
                return Float.valueOf(((NUMBER)d).floatValue());
            }
            if (sqlType == 16) {
                return ((NUMBER)d).booleanValue();
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 48, " type: " + sqlType);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return d.toJdbc();
    }

    public static Datum convertToOracle(Object d, Connection c) throws SQLException {
        return Util.convertToOracle(d, c, false);
    }

    public static Datum convertToOracle(Object d, Connection c, boolean isNChar) throws SQLException {
        Datum result2 = Util._convertToOracle(d, c, isNChar);
        return result2;
    }

    private static Datum _convertToOracle(Object d, Connection c, boolean isNChar) throws SQLException {
        if (d == null) {
            return null;
        }
        if (d instanceof ORAData) {
            return ((ORAData)d).toDatum(c);
        }
        if (d instanceof CustomDatum) {
            return ((CustomDatum)d).toDatum((OracleConnection)c);
        }
        if (d instanceof String) {
            short csId;
            short s2 = c == null || !(c instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (csId = isNChar ? ((oracle.jdbc.internal.OracleConnection)c).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)c).getDbCsId());
            if (csId != lastCsId) {
                lastCsId = csId;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)d, lastCS);
        }
        if (d instanceof Character) {
            short csId;
            short s3 = csId = c == null || !(c instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)c).getDbCsId();
            if (csId != lastCsId) {
                lastCsId = csId;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)d).toString(), lastCS);
        }
        if (d instanceof BigDecimal) {
            return new NUMBER((BigDecimal)d);
        }
        if (d instanceof BigInteger) {
            return new NUMBER((BigInteger)d);
        }
        if (d instanceof Double) {
            return new NUMBER((Double)d);
        }
        if (d instanceof Float) {
            return new NUMBER(((Float)d).floatValue());
        }
        if (d instanceof Integer) {
            return new NUMBER((Integer)d);
        }
        if (d instanceof Boolean) {
            return new NUMBER((Boolean)d);
        }
        if (d instanceof Short) {
            return new NUMBER((Short)d);
        }
        if (d instanceof Byte) {
            return new NUMBER((Byte)d);
        }
        if (d instanceof Long) {
            return new NUMBER((Long)d);
        }
        if (d instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)d);
        }
        if (d instanceof Date) {
            return new DATE((Date)d);
        }
        if (d instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)d).getTime()));
        }
        if (d instanceof byte[]) {
            return new RAW((byte[])d);
        }
        if (d instanceof Datum) {
            return (Datum)d;
        }
        SQLException __ex__ = DatabaseError.createSqlException(null, 48);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    static boolean isMutable(Datum d, ORADataFactory f2) {
        if (d == null) {
            return false;
        }
        return d instanceof BFILE || d instanceof BLOB || d instanceof CLOB || f2 != null && (d instanceof STRUCT || d instanceof OPAQUE || d instanceof ARRAY);
    }

    static boolean isMutable(Datum d, CustomDatumFactory f2) {
        if (d == null) {
            return false;
        }
        return d instanceof BFILE || d instanceof BLOB || d instanceof CLOB || f2 != null && (d instanceof STRUCT || d instanceof OPAQUE || d instanceof ARRAY);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

