/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleStruct;
import oracle.jpub.runtime.OracleDataUtil;

public class OracleDataMutableStruct {
    int length;
    OracleStruct pickled;
    Object[] jdbcObjects;
    Object[] attributes;
    OracleDataFactory[] oracleDataFactories;
    int[] sqlTypes;
    boolean pickledCorrect;
    boolean[] isNChar;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleDataMutableStruct(OracleStruct s2, int[] sqlTypes, OracleDataFactory[] oracleDataFactories) {
        this.length = oracleDataFactories.length;
        this.pickled = s2;
        this.oracleDataFactories = oracleDataFactories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = true;
    }

    public OracleDataMutableStruct(Object[] attributes, int[] sqlTypes, OracleDataFactory[] factories) {
        this.length = factories.length;
        this.attributes = attributes;
        this.oracleDataFactories = factories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = false;
    }

    public OracleDataMutableStruct(OracleDataMutableStruct s2, int[] sqlTypes, OracleDataFactory[] oracleDataFactories) {
        this.length = oracleDataFactories.length;
        this.oracleDataFactories = oracleDataFactories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickled = s2.pickled;
        this.pickledCorrect = s2.pickledCorrect;
        this.jdbcObjects = s2.jdbcObjects;
        this.attributes = s2.attributes;
    }

    public Object toJDBCObject(Connection c, String sqlTypeName) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = (OracleStruct)c.createStruct(sqlTypeName, this.getJDBCObjectAttributes(c));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Object getAttribute(int n) throws SQLException {
        Object attribute = this.getLazyAttributes()[n];
        if (attribute == null) {
            Object d = this.getLazyJDBCObjects()[n];
            if (this.oracleDataFactories != null) {
                this.attributes[n] = attribute = OracleDataUtil.convertToObject(d, this.sqlTypes[n], this.oracleDataFactories[n]);
                if (OracleDataUtil.isMutable(d, this.oracleDataFactories[n])) {
                    this.resetJDBCObject(n);
                }
            }
        }
        return attribute;
    }

    public Object getOracleAttribute(int n) throws SQLException {
        Object o;
        if (this.oracleDataFactories[n] == null) {
            o = this.getJDBCObjectAttribute(n, null);
            Object d = this.getLazyJDBCObjects()[n];
            if (OracleDataUtil.isMutable(d, this.oracleDataFactories[n])) {
                this.pickledCorrect = false;
            }
        } else {
            o = this.getAttribute(n);
        }
        return o;
    }

    public Object[] getAttributes() throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getAttribute(i);
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] result2 = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            result2[i] = this.getOracleAttribute(i);
        }
        return result2;
    }

    public void setAttribute(int n, Object attribute) throws SQLException {
        if (attribute == null) {
            this.getLazyJDBCObjects();
        }
        this.resetJDBCObject(n);
        this.getLazyAttributes()[n] = attribute;
    }

    public void setDoubleAttribute(int n, double attribute) throws SQLException {
        this.setAttribute(n, attribute);
    }

    public void setFloatAttribute(int n, float attribute) throws SQLException {
        this.setAttribute(n, Float.valueOf(attribute));
    }

    public void setIntAttribute(int n, int attribute) throws SQLException {
        this.setAttribute(n, attribute);
    }

    public void setOracleAttribute(int n, Object attribute) throws SQLException {
        if (this.oracleDataFactories != null) {
            if (this.oracleDataFactories[n] == null) {
                this.setJDBCObjectAttribute(n, attribute);
            } else {
                this.setAttribute(n, attribute);
            }
        }
    }

    Object getJDBCObjectAttribute(int n, Connection c) throws SQLException {
        Object jdbcObject = this.getLazyJDBCObjects()[n];
        if (jdbcObject == null) {
            Object a = this.getLazyAttributes()[n];
            this.jdbcObjects[n] = jdbcObject = OracleDataUtil.convertToOracle(a, c, this.isNChar(n));
        }
        return jdbcObject;
    }

    void setJDBCObjectAttribute(int n, Object jdbcObject) throws SQLException {
        this.resetAttribute(n);
        this.getLazyJDBCObjects()[n] = jdbcObject;
        this.pickledCorrect = false;
    }

    Object[] getJDBCObjectAttributes(Connection c) throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getJDBCObjectAttribute(i, c);
        }
        return (Object[])this.jdbcObjects.clone();
    }

    void resetAttribute(int n) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n] = null;
        }
    }

    void resetJDBCObject(int n) throws SQLException {
        if (this.jdbcObjects != null) {
            this.jdbcObjects[n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Object[] getLazyJDBCObjects() throws SQLException {
        if (this.jdbcObjects == null) {
            if (this.pickled != null) {
                this.jdbcObjects = this.pickled.getAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    for (int x = 0; x < this.length; ++x) {
                        if (this.attributes[x] == null) continue;
                        this.jdbcObjects[x] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else {
                this.jdbcObjects = new Object[this.length];
            }
        }
        return this.jdbcObjects;
    }

    private void initNChar(int n) {
        this.isNChar = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.isNChar[i] = false;
        }
    }

    public void setNChar(int n) throws SQLException {
        this.isNChar[n] = true;
    }

    public boolean isNChar(int n) throws SQLException {
        boolean is = this.isNChar[n];
        return is;
    }
}

