/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private boolean needStackingForCommitRollbackPrepare = false;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose = false;
    private static final boolean DEBUG = false;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        super(pm_conn, xaconn);
        SQLException savedSqe = null;
        try {
            this.m_version = ((OracleConnection)pm_conn).getVersionNumber();
            this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
        }
        catch (SQLException sqe) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "(pm_conn= " + String.valueOf(pm_conn) + ", xaconn= " + String.valueOf(xaconn) + "): getVersionNumber(): " + String.valueOf(sqe), null, null);
            savedSqe = sqe;
            this.m_version = (short)-1;
        }
        if (this.m_version < 8170) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "(pm_conn= " + String.valueOf(pm_conn) + "): Java XA not supported for this server version", null, null);
            throw (XAException)DatabaseError.createXAException(String.format("Unsupported database version %d", this.m_version), -6).initCause(savedSqe);
        }
    }

    protected void startSessionlessTransaction(Xid xid, int flag) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try {
            int operation;
            byte[] gtrid = xid.getGlobalTransactionId();
            boolean RTSTART = true;
            int RTRESUME = 2;
            switch (flag) {
                case 0: {
                    operation = 1;
                    break;
                }
                case 0x8000000: {
                    operation = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid flag!");
                }
            }
            this.saveAndAlterAutoCommitModeForSessionlessTransaction();
            physicalConnection.doStartOrResume(gtrid, this.timeout, operation, 3);
        }
        catch (SQLException e) {
            this.restoreAutoCommitModeForSessionlessTransaction();
            throw this.convertError(e, -6);
        }
    }

    protected void endSessionlessTransaction(Xid xid, int flag) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try {
            byte[] gtrid = xid.getGlobalTransactionId();
            if (!Arrays.equals(physicalConnection.getTransactionId(), gtrid)) {
                return;
            }
        }
        catch (SQLException sqle) {
            throw this.convertError(sqle, -4);
        }
        try {
            physicalConnection.doPreCallSuspend(3);
            this.restoreAutoCommitModeForSessionlessTransaction();
        }
        catch (SQLException e) {
            throw this.convertError(e, -6);
        }
    }

    protected void commitSessionlessTransaction(Xid xid) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try {
            byte[] gtrid = xid.getGlobalTransactionId();
            if (!Arrays.equals(physicalConnection.getTransactionId(), gtrid)) {
                this.startSessionlessTransaction(xid, 0x8000000);
            }
        }
        catch (SQLException sqle) {
            throw this.convertError(sqle, -4);
        }
        try {
            physicalConnection.commit();
            this.restoreAutoCommitModeForSessionlessTransaction();
        }
        catch (SQLException e) {
            throw this.convertError(e, -6);
        }
    }

    protected void rollbackSessionlessTransaction(Xid xid) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try {
            byte[] gtrid = xid.getGlobalTransactionId();
            if (!Arrays.equals(physicalConnection.getTransactionId(), gtrid)) {
                this.startSessionlessTransaction(xid, 0x8000000);
            }
        }
        catch (SQLException sqle) {
            throw this.convertError(sqle, -4);
        }
        try {
            physicalConnection.rollback();
            this.restoreAutoCommitModeForSessionlessTransaction();
        }
        catch (SQLException e) {
            throw this.convertError(e, -6);
        }
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        this.testlog("###### In OracleXAResource.start(), flag = " + flag + ", conn = " + String.valueOf(physicalConnection));
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            int returnVal;
            block18: {
                block19: {
                    returnVal = -1;
                    try {
                        if (xid == null) {
                            XAException xae = (XAException)DatabaseError.createXAException("xid is null", -5).fillInStackTrace();
                            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "start(): XAER_INVAL: xid is null", null, xae);
                            throw xae;
                        }
                        if (!physicalConnection.isXAThroughSessionlessTransactions()) break block18;
                        if (flag != 0x200000) break block19;
                        this.debug(Level.INFO, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "join", "join() is not supported for sessionless transactions.", null, null);
                        return;
                    }
                    catch (XAException ea) {
                        if (!physicalConnection.isXAThroughSessionlessTransactions()) {
                            this.restoreAutoCommitModeForGlobalTransaction();
                        }
                        throw ea;
                    }
                }
                this.startSessionlessTransaction(xid, flag);
                return;
            }
            int isolFlag = flag & 0xFF00;
            int otherFlag = (flag &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
            if (((flag &= 0xFFFEFFFF) & 0x820000A) != flag || otherFlag != 0 && (otherFlag & 0x10000) != 65536) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "start(): XAER_INVAL: invalid flag: " + flag, null, xae);
                throw xae;
            }
            if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "start(): XAER_INVAL: invalid Isolation flag: " + isolFlag, null, xae);
                throw xae;
            }
            if ((flag & 0x8200000) != 0 && ((isolFlag & 0xFF00) != 0 || (otherFlag & 0x10000) != 0)) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME: " + isolFlag, null, xae);
                throw xae;
            }
            flag |= isolFlag | otherFlag;
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            try {
                returnVal = this.doStart(xid, flag);
            }
            catch (SQLException sqle) {
                throw this.convertError(sqle, -3);
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "start(): return status returnVal = " + returnVal, null, null);
            this.checkError(returnVal);
            boolean[] isLocallySuspended = new boolean[]{false};
            super.createOrUpdateXid(xid, false, isLocallySuspended);
        }
    }

    protected int doStart(Xid xid, int flag) throws XAException, SQLException {
        int returnVal = -1;
        CallableStatement cstmt = null;
        try {
            cstmt = this.connection.prepareCall(xa_start_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.setInt(5, this.timeout);
            cstmt.setInt(6, flag);
            cstmt.execute();
            returnVal = cstmt.getInt(1);
        }
        catch (SQLException s2) {
            returnVal = s2.getErrorCode();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doStart() returnVal=" + returnVal, null, null);
            if (returnVal == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        this.testlog("###### In OracleXAResource.end(), flag = " + flag + ", conn = " + String.valueOf(physicalConnection));
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            int returnVal = -1;
            boolean isTMSUCCESS = false;
            boolean isTMFAIL = false;
            try {
                if (xid == null) {
                    XAException xae = (XAException)DatabaseError.createXAException("xid is null", -5).fillInStackTrace();
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "end(): XAER_INVAL: xid is null", null, xae);
                    throw xae;
                }
                if (physicalConnection.isXAThroughSessionlessTransactions()) {
                    this.endSessionlessTransaction(xid, flag);
                    return;
                }
                int validFlags = 638582786;
                if ((flag & validFlags) != flag) {
                    XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "end(): XAER_INVAL: invalid flag: " + flag, null, xae);
                    throw xae;
                }
                Xid stackedXid = null;
                isTMSUCCESS = (flag & 0x4000000) != 0;
                boolean bl = isTMFAIL = (flag & 0x20000000) != 0;
                if (isTMSUCCESS || isTMFAIL) {
                    stackedXid = super.suspendStacked(xid);
                }
                try {
                    boolean isLocallySuspended = false;
                    if (isTMSUCCESS || isTMFAIL) {
                        isLocallySuspended = this.isXidSuspended(xid);
                        if (isLocallySuspended) {
                            super.resumeStacked(xid);
                        }
                        this.removeXidFromList(xid);
                    } else if (flag == 0x2000000) {
                        boolean[] flags = new boolean[]{false};
                        super.createOrUpdateXid(xid, true, flags);
                        isLocallySuspended = flags[0];
                    }
                    returnVal = this.doEnd(xid, flag, isLocallySuspended);
                }
                catch (SQLException sqle) {
                    throw this.convertError(sqle, -3);
                }
                if (stackedXid != null) {
                    super.resumeStacked(stackedXid);
                } else if (this.isXidListEmpty()) {
                    this.exitGlobalTxnMode();
                    this.activeXid = null;
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "end(): return status returnVal = " + returnVal, null, null);
                this.checkError(returnVal);
                if (isTMSUCCESS && flag != 0x4000000 || isTMFAIL && flag != 0x20000000) {
                    XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "end(): XAER_INVAL: The flag combines TMSUCCESS or TMFAIL with other flags: " + flag, null, xae);
                    throw xae;
                }
            }
            finally {
                if (!physicalConnection.isXAThroughSessionlessTransactions()) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                }
            }
        }
    }

    protected int doEnd(Xid xid, int flag, boolean isLocallySuspended) throws XAException, SQLException {
        CallableStatement cstmt = null;
        int returnVal = -1;
        try {
            cstmt = this.connection.prepareCall(xa_end_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.setInt(5, flag);
            cstmt.execute();
            returnVal = cstmt.getInt(1);
        }
        catch (SQLException s2) {
            returnVal = s2.getErrorCode();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doEnd() returnVal=" + returnVal, null, null);
            if (returnVal == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
        return returnVal;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        this.testlog("###### In OracleXAResource.commit(), onePhase = " + onePhase + ", conn = " + String.valueOf(physicalConnection));
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            if (xid == null) {
                XAException xae = (XAException)DatabaseError.createXAException("xid is null", -5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "commit(): XAER_INVAL: xid is null", null, xae);
                throw xae;
            }
            if (physicalConnection.isXAThroughSessionlessTransactions()) {
                this.commitSessionlessTransaction(xid);
                return;
            }
            Xid stackedXid = null;
            if (this.needStackingForCommitRollbackPrepare) {
                stackedXid = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                try {
                    this.doCommit(xid, onePhase);
                }
                catch (SQLException sqle) {
                    throw this.convertError(sqle, -3);
                }
            }
            catch (XAException xae) {
                if (xae.errorCode == -7) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "commit(): Error during commit is fatal so, close the connection.", null, null);
                    try {
                        physicalConnection.close();
                    }
                    catch (SQLException ea) {
                        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "commit(): connection.close hit exception: " + String.valueOf(ea), null, null);
                    }
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                throw xae;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(stackedXid);
            }
        }
    }

    protected void doCommit(Xid xid, boolean onePhase) throws XAException, SQLException {
        CallableStatement cstmt = null;
        try {
            cstmt = this.connection.prepareCall(xa_commit_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.setInt(5, onePhase ? 1 : 0);
            cstmt.execute();
            int returnVal = cstmt.getInt(1);
            this.checkError(returnVal, -7);
        }
        catch (SQLException s2) {
            int returnVal = s2.getErrorCode();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doCommit() returnVal=" + returnVal, null, null);
            if (returnVal == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        this.testlog("###### In OracleXAResource.prepare(), conn = " + String.valueOf(physicalConnection));
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            int returnVal = 0;
            if (xid == null) {
                XAException xae = (XAException)DatabaseError.createXAException("xid is null", -5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "prepare(): XAER_INVAL: xid is null", null, xae);
                throw xae;
            }
            if (physicalConnection.isXAThroughSessionlessTransactions()) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "prepare", "prepare() is not supported for sessionless transactions.", null, null);
                int xae = 0;
                return xae;
            }
            Xid stackedXid = null;
            if (this.needStackingForCommitRollbackPrepare) {
                stackedXid = super.suspendStacked(xid);
            }
            try {
                try {
                    returnVal = this.doPrepare(xid);
                    if (returnVal != 0 && returnVal != 3) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "prepare(): return status returnVal = " + returnVal, null, null);
                        int x_e = OracleXAException.errorConvert(returnVal);
                        if (x_e != 0 && x_e != 3) {
                            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), returnVal).fillInStackTrace();
                        }
                        returnVal = x_e;
                    }
                }
                catch (SQLException sqle) {
                    throw this.convertError(sqle, -3);
                }
            }
            catch (XAException xaex) {
                if (xaex.errorCode == -7) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "prepare(): Error during prepare is fatal so, close the connection.", null, null);
                    try {
                        physicalConnection.close();
                    }
                    catch (SQLException ea) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "prepare(): connection.close hit exception: " + String.valueOf(ea), null, null);
                    }
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(stackedXid);
                }
                throw xaex;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(stackedXid);
            }
            int n = returnVal;
            return n;
        }
    }

    protected int doPrepare(Xid xid) throws XAException, SQLException {
        int returnVal = 0;
        CallableStatement cstmt = null;
        try {
            cstmt = this.connection.prepareCall(xa_prepare_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.execute();
            returnVal = cstmt.getInt(1);
        }
        catch (SQLException s2) {
            int errorCode = s2.getErrorCode();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doPrepare() errorCode=" + errorCode, null, null);
            if (errorCode == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
        return returnVal;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            int returnVal = 0;
            if (xid == null) {
                XAException xae = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "forget(): XAER_INVAL: xid is null", null, xae);
                throw xae;
            }
            if (physicalConnection.isXAThroughSessionlessTransactions()) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "forget", "forget() is not supported for sessionless transactions.", null, null);
                return;
            }
            this.removeXidFromList(xid);
            try {
                returnVal = this.doForget(xid);
            }
            catch (SQLException sqle) {
                throw this.convertError(sqle, -3);
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "forget(): return status returnVal = " + returnVal, null, null);
            this.checkError(returnVal);
        }
    }

    protected int doForget(Xid xid) throws XAException, SQLException {
        int returnVal = 0;
        CallableStatement cstmt = null;
        try {
            cstmt = this.connection.prepareCall(xa_forget_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.execute();
            returnVal = cstmt.getInt(1);
        }
        catch (SQLException s2) {
            returnVal = s2.getErrorCode();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doForget() returnVal=" + returnVal, null, null);
            if (returnVal == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
        return returnVal;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        this.testlog("###### In OracleXAResource.rollback(), conn = " + String.valueOf(physicalConnection));
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            int returnVal = 0;
            if (xid == null) {
                XAException xae = (XAException)DatabaseError.createXAException("xid is null", -5).fillInStackTrace();
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "rollback(): XAER_INVAL: xid is null", null, xae);
                throw xae;
            }
            if (physicalConnection.isXAThroughSessionlessTransactions()) {
                this.rollbackSessionlessTransaction(xid);
                return;
            }
            Xid stackedXid = null;
            if (this.needStackingForCommitRollbackPrepare) {
                stackedXid = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                this.doRollback(xid);
            }
            catch (SQLException sqle) {
                throw this.convertError(sqle, -3);
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(stackedXid);
            }
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "rollback(): return status returnVal = " + returnVal, null, null);
            this.checkError(returnVal);
        }
    }

    protected void doRollback(Xid xid) throws XAException, SQLException {
        CallableStatement cstmt = null;
        try {
            cstmt = this.connection.prepareCall(xa_rollback_post_816);
            cstmt.registerOutParameter(1, 2);
            cstmt.setInt(2, xid.getFormatId());
            cstmt.setBytes(3, xid.getGlobalTransactionId());
            cstmt.setBytes(4, xid.getBranchQualifier());
            cstmt.execute();
            int returnVal = cstmt.getInt(1);
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "OracleXAResource", "doRollback() returnVal=" + returnVal, null, null);
            this.checkError(returnVal, -7);
        }
        catch (SQLException s2) {
            int errorCode = s2.getErrorCode();
            if (errorCode == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw s2;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            cstmt = null;
        }
    }

    public void doTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        OracleConnection physicalConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock lock = physicalConnection.acquireCloseableLock();){
            this.doDoTwoPhaseAction(nsites, action, dbnames, xids);
        }
    }

    protected int doDoTwoPhaseAction(int nsites, int action, String[] dbnames, Xid[] xids) throws XAException {
        throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
    }

    private void testlog(String mesg) {
    }

    private void testlog(String mesg, Throwable exc) {
    }

    private byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException ioe) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.xa.client.OracleXAResource", "getSerializedBytes", "got exception: " + ioe.getMessage(), null, ioe);
            return null;
        }
    }
}

