/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleClob;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={oracle.jdbc.internal.OracleClob.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableClob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETASCIISTREAM_METHOD = TxnReplayableClob.getGetAsciiStreamMethod();
    private static final Method GETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getGetAsciiStreamLongMethod();
    private static final Method GETCHARSTREAM_METHOD = TxnReplayableClob.getGetCharacterStreamMethod();
    private static final Method GETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongMethod();
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongLongMethod();
    private static final Method SETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getSetAsciiStreamLongMethod();
    private static final Method SETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getSetCharacterStreamLongMethod();
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableClob";

    protected TxnReplayableClob() {
    }

    private static final Method getGetAsciiStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args2) {
        super.preForAll(m, receiver, args2);
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result2) {
        if (result2 instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result2;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m, result2);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        this.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            this.isLogicallyClosed = true;
            try {
                connProxy.checkImplicitRequestBoundary();
            }
            catch (Throwable error) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForClose", "On Clob {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method m) {
        super.postForAll(m);
        if (!this.isFreed) {
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
            OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
            if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
                if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.setStateSignatureSyncUp();
                }
                try {
                    connProxy.checkImplicitRequestBoundary();
                }
                catch (Throwable error) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForFree", "On Clob {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
                }
            }
        }
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getAsciiStream() throws SQLException {
        if (GETASCIISTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method m = GETASCIISTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate2.canReadBasicLobDataInLocator() ? delegate2.getAsciiStream() : delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), 0L);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getAsciiStream(long pos) throws SQLException {
        if (GETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method m = GETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            InputStream delegateReturn;
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate2.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate2.getAsciiStream(pos);
            } else {
                if (pos < 1L) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), pos);
            }
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (GETCHARSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m = GETCHARSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            Reader delegateReturn = delegate2.canReadBasicLobDataInLocator() ? delegate2.getCharacterStream() : delegate2.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), 0L);
            return (Reader)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public Reader getCharacterStream(long pos) throws SQLException {
        if (GETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m = GETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            Reader delegateReturn;
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate2.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate2.getCharacterStream(pos);
            } else {
                if (pos < 1L) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate2.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), pos);
            }
            return (Reader)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m = GETCHARSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos, length);
        try {
            Reader delegateReturn;
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate2.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate2.getCharacterStream(pos, length);
            } else {
                long lobLen = delegate2.length();
                if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate2.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), pos, length);
            }
            return (Reader)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (SETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
        }
        Method m = SETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            OutputStream delegateReturn = delegate2.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), pos, true);
            return (OutputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (OutputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        if (SETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set character stream");
        }
        Method m = SETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            Writer delegateReturn = delegate2.getDBAccess().newWriter((oracle.jdbc.internal.OracleClob)((Object)this), delegate2.getBufferSize(), pos, true);
            return (Writer)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Writer)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        return this.setAsciiStream(pos);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(1L);
    }

    public Writer getCharacterOutputStream(long pos) throws SQLException {
        return this.setCharacterStream(pos);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleClob delegate2 = (oracle.jdbc.internal.OracleClob)this.getDelegate();
        return delegate2.getInternalConnection();
    }

    @Override
    protected OracleConnection getConnectionInDelegate() throws SQLException {
        return this.getInternalConnection();
    }

    @Override
    protected void replugWithoutCreator(OracleConnection newConn) throws SQLException {
        oracle.jdbc.internal.OracleClob oldDelegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
        OracleClob newlob = new OracleClob(newConn, oldDelegate.getBytes());
        this.setDelegate(newlob);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replugWithoutCreator", "On Clob {0}, replugged delegate: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), newlob});
    }
}

