/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, oracle.jdbc.internal.OracleCallableStatement.class, oracle.jdbc.internal.OraclePreparedStatement.class, oracle.jdbc.internal.OracleStatement.class})
public abstract class NonTxnReplayableStatement
extends NonTxnReplayableBase
implements Replayable {
    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args2) {
        super.preForAll(m, receiver, args2);
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        try {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecute", "On statement {0}, original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlKind});
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION || sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.preForAll(m, receiver, args2);
            } else if (sqlKind.isDML()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
                } else {
                    this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecute", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
                }
            } else if (sqlKind.isOTHER()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
                } else {
                    this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecute", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
                }
            }
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecute", "On statement {0}, could not get original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlexc});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteUpdate", "On statement {0}, preForExecuteUpdate", (String)null, (Throwable)null, (Object)this);
        try {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteUpdate", "On statement {0}, original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlKind});
            if (sqlKind.isPlsqlOrCall()) {
                this.preForAll(m, receiver, args2);
            } else if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
            } else {
                this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteUpdate", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
            }
        }
        catch (SQLException sqlexc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteUpdate", "On statement {0}, could not get original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlexc});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeBatch", args={})})
    protected void preForExecuteBatch(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteBatch", "On statement {0}, preForExecuteBatch", (String)null, (Throwable)null, (Object)this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForExecuteBatch", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setUnicodeStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class})})
    protected void preForSetStreams(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForSetStreams", "On statement {0}, preForSetStreams", (String)null, (Throwable)null, (Object)this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForSetStreams", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setObject", args={String.class, Object.class}), @Signature(name="setObject", args={String.class, Object.class, int.class}), @Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @Signature(name="setObject", args={int.class, Object.class}), @Signature(name="setObject", args={int.class, Object.class, int.class}), @Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
    protected void preForSetObjects(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForSetObjects", "On statement {0}, preForSetObjects", (String)null, (Throwable)null, (Object)this);
        if (args2[1] instanceof InputStream || args2[1] instanceof Reader) {
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
            } else {
                this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "preForSetObjects", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
            }
        }
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result2) {
        return super.postForAll(m, result2);
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean postForExecute(Method m, boolean result2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m, result2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m, result2, null);
            }
        }
        return result2;
    }

    @Post
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected int postForExecuteUpdate(Method m, int result2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m, result2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m, result2, null);
            }
        }
        return result2;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method m, ResultSet result2) {
        if (result2 instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)((Object)result2);
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(m, result2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(m, result2, null);
            }
        }
        return result2;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(m, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method m, SQLException error) throws SQLException {
        if (error instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(m, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean onErrorForExecute(Method m, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            try {
                oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "onErrorForExecute", "On statement {0}, original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlKind});
                if (sqlKind.isPlsqlOrCall()) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "onErrorForExecute", "On proxy {0}, last call is PL/SQL", (String)null, (Throwable)null, (Object)this);
                    this.failoverMngr.disableReplayInternal(m, 373, "Replay disabled because outage occurred during PL/SQL execution", null);
                } else if (sqlKind.isDML()) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
                    } else {
                        this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "onErrorForExecute", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
                    }
                } else if (sqlKind.isOTHER() && sqlKind != OracleStatement.SqlKind.ALTER_SESSION) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
                    } else {
                        this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "onErrorForExecute", "On statement {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
                    }
                }
            }
            catch (SQLException sqlexc) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "onErrorForExecute", "On statement {0}, could not get original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlexc});
            }
        }
        return (Boolean)super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry entry) throws SQLException {
        oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
        long checksum = ostmt.getChecksum();
        String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "fillInChecksum", "On proxy {0}, method {1}, filling in checksum: {2}", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, methodName, checksum});
        this.failoverMngr.update(this, entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        if (entry.scn != -1L) {
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            ostmt.setSnapshotSCN(entry.scn);
            String methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "replayOneCall", "On proxy {0}, replaying method {1}, set original SCN: {2}", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, methodName, entry.scn});
        }
        return super.replayOneCall(entry, origError);
    }

    @Override
    protected void doPostWhenReplaying(Method m, Object result2, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    long newChecksum = ostmt.getChecksum();
                    String methodName = this.replayingCallEntry == null || this.replayingCallEntry.method == null ? "NULL METHOD" : this.replayingCallEntry.method.getName();
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenReplaying", "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", (String)null, (Throwable)null, new Object[]{this.replayingCallEntry.jdbcProxy, methodName, newChecksum, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != newChecksum) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException exc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenReplaying", "On statement {0}, doPostWhenReplaying exception: {1}", (String)null, (Throwable)null, new Object[]{this, exc});
        }
    }

    protected void doPostWhenReplayingExecutes(Method m, Object result2, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    this.doPostWhenReplaying(m, result2, sqlexc);
                    break;
                }
                case REPLAYING_LASTCALL: {
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    if (!sqlKind.isPlsqlOrCall()) break;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenReplayingExecutes", "On proxy {0}, last call is PL/SQL", (String)null, (Throwable)null, this.replayingCallEntry.jdbcProxy);
                    this.failoverMngr.disableReplayInternal(this.replayingCallEntry.method, 373, "Replay disabled because outage occurred during PL/SQL execution", this.originalError);
                }
            }
        }
        catch (SQLException exc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenReplayingExecutes", "On statement {0}, doPostWhenReplayingExecutes exception: {1}", (String)null, (Throwable)null, new Object[]{this, exc});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToPurgeSameProxyList() {
        boolean result2;
        block7: {
            result2 = false;
            try {
                oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                if (sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                    result2 = true;
                    break block7;
                }
                if (!sqlKind.isSELECT() || sqlKind == OracleStatement.SqlKind.SELECT_FOR_UPDATE) break block7;
                FailoverManagerImpl.CallHistoryEntry entry = this.headSameProxy;
                while (entry != null) {
                    String methodName;
                    String string = methodName = entry.method == null ? "NULL METHOD" : entry.method.getName();
                    if (("execute".equals(methodName) || "executeQuery".equals(methodName)) && entry.scn > 0L) {
                        result2 = true;
                        break;
                    }
                    entry = entry.nextEntrySameProxy;
                }
            }
            catch (SQLException sqlexc) {
                try {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "okToPurgeSameProxyList", "On statement {0}, could not get original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, sqlexc});
                    result2 = false;
                }
                catch (Throwable throwable) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "okToPurgeSameProxyList", "On statement {0}, ok for implicit purge: {1}", (String)null, (Throwable)null, new Object[]{this, result2});
                    return result2;
                }
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "okToPurgeSameProxyList", "On statement {0}, ok for implicit purge: {1}", (String)null, (Throwable)null, new Object[]{this, result2});
                return result2;
            }
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "okToPurgeSameProxyList", "On statement {0}, ok for implicit purge: {1}", (String)null, (Throwable)null, new Object[]{this, result2});
        return result2;
    }

    protected void doPostWhenRecordingClose(Method m, SQLException sqlexc) {
        if (this.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
    }

    protected void doPostWhenRecordingExecutes(Method m, Object result2, SQLException sqlexc) {
        try {
            String methodName;
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleConnection oconn = (OracleConnection)ostmt.getConnection();
            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
            long checksum = 0L;
            long SCN = -1L;
            String string = methodName = m == null ? "NULL METHOD" : m.getName();
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION) {
                EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenRecordingExecutes", "On proxy {0}, method {1}, transaction state: {2}", (String)null, (Throwable)null, new Object[]{this, methodName, eocs});
                if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_INTENTION) || oconn.inLocalTransaction()) {
                    this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of transaction", null);
                } else {
                    checksum = 0L;
                    if (!this.failoverMngr.isReplayInCurrentMode() && sqlKind.isPlsqlOrCall()) {
                        this.failoverMngr.setReplayInCurrentMode();
                    }
                    SCN = this.failoverMngr.isReplayInCurrentMode() ? -1L : oconn.getCurrentSCN();
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenRecordingExecutes", "On proxy {0}, method {1}, SCN to record: {2}", (String)null, (Throwable)null, new Object[]{this, methodName, SCN});
                }
                if (this.failoverMngr.getReplayLifecycle() == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.update(this, null, result2, "completed", checksum, SCN, sqlexc);
                }
            } else {
                this.failoverMngr.update(this, null, result2, "completed", checksum, SCN, sqlexc);
                this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (SQLException exc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableStatement", "doPostWhenRecordingExecutes", "On statement {0}, could not get original SqlKind: {1}", (String)null, (Throwable)null, new Object[]{this, exc});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() {
        return (Connection)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(String var1) throws SQLException;
}

