/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Level;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={ResultSet.class, OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class NonTxnReplayableResultSet
extends NonTxnReplayableBase
implements Replayable {
    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args2) {
        super.preForAll(m, receiver, args2);
    }

    @Pre
    @Methods(signatures={@Signature(name="deleteRow", args={}), @Signature(name="insertRow", args={}), @Signature(name="updateRow", args={})})
    protected void preForRowUpdates(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForRowUpdates", "On result set {0}, entering preForRowUpdates({1})", (String)null, (Throwable)null, new Object[]{this, m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForRowUpdates", "On result set {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForRowUpdates", "On result set {0}, exiting preForRowUpdates()", (String)null, (Throwable)null, (Object)this);
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForUpdateStreams", "On result set {0}, entering preForRowUpdates({1})", (String)null, (Throwable)null, new Object[]{this, m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForUpdateStreams", "On result set {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "preForUpdateStreams", "On result set {0}, exiting preForRowUpdates()", (String)null, (Throwable)null, (Object)this);
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result2) {
        return super.postForAll(m, result2);
    }

    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method m, boolean result2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingNext(m, result2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(m, result2, null);
            }
        }
        return result2;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(m, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        this.onErrorForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method m, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "onErrorForLast", "On proxy {0}, failed call for initial outage is last()", (String)null, (Throwable)null, (Object)this);
            this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry entry) throws SQLException {
        OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        long checksum = ostmt.getChecksum();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "fillInChecksum", "On proxy {0}, method {1}, filling in checksum: {2}", (String)null, (Throwable)null, new Object[]{entry.jdbcProxy, entry.method, checksum});
        this.failoverMngr.update(this, entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        Object result2 = super.replayOneCall(entry, origError);
        return result2;
    }

    protected void doPostWhenRecordingNext(Method m, Object result2, SQLException sqlexc) {
        long SCN = -1L;
        long checksum = 0L;
        OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        try {
            checksum = ostmt.getChecksum();
        }
        catch (SQLException exc) {
            checksum = 0L;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "doPostWhenRecordingNext", "On result set {0}, getChecksum() gets exception: {1}", (String)null, (Throwable)null, new Object[]{this, exc});
        }
        this.failoverMngr.update(this, null, result2, "completed", checksum, -1L, sqlexc);
    }

    protected void doPostWhenRecordingClose(Method m, SQLException sqlexc) {
        NonTxnReplayableStatement stmtProxy = (NonTxnReplayableStatement)this.getCreator();
        if (stmtProxy.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    protected void doPostWhenReplaying(Method m, Object result2, SQLException sqlexc) {
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    OracleStatement ostmt = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                    long newChecksum = ostmt.getChecksum();
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "doPostWhenReplaying", "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", (String)null, (Throwable)null, new Object[]{this.replayingCallEntry.jdbcProxy, this.replayingCallEntry.method, newChecksum, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != newChecksum) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException exc) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableResultSet", "doPostWhenReplaying", "On result set {0}, doPostWhenReplaying exception: {1}", (String)null, (Throwable)null, new Object[]{this, exc});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() {
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate();
    }
}

