/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Blob.class, OracleBlob.class, oracle.jdbc.internal.OracleBlob.class})
public abstract class NonTxnReplayableBlob
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETBINSTREAM_METHOD = NonTxnReplayableBlob.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = NonTxnReplayableBlob.getGetBinaryStreamLongMethod();
    private static final Method GETBINSTREAM_LONG_LONG_METHOD = NonTxnReplayableBlob.getGetBinaryStreamLongLongMethod();
    private static final Method SETBINSTREAM_LONG_METHOD = NonTxnReplayableBlob.getSetBinaryStreamLongMethod();
    protected boolean isFreed = false;

    private static final Method getGetBinaryStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args2) {
        super.preForAll(m, receiver, args2);
    }

    @Pre
    @Methods(signatures={@Signature(name="free", args={})})
    protected void preForFree(Method m, Object receiver, Object ... args2) {
        this.isFreed = true;
        super.preForAll(m, receiver, args2);
    }

    @Pre
    @Methods(signatures={@Signature(name="setBytes", args={long.class, byte[].class}), @Signature(name="setBytes", args={long.class, byte[].class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForBlobWrites(Method m, Object receiver, Object ... args2) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBlob", "preForBlobWrites", "On blob {0}, entering preForBlobWrites({1})", (String)null, (Throwable)null, new Object[]{this, m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 371, "Replay disabled because of active transaction", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBlob", "preForBlobWrites", "On blob {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableBlob", "preForBlobWrites", "On blob {0}, exiting preForBlobWrites()", (String)null, (Throwable)null, (Object)this);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result2) {
        if (result2 instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result2;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m, result2);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob delegate2 = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate2.canReadBasicLobDataInLocator() ? delegate2.getBinaryStream() : delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate2.getBufferSize(), 0L);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob delegate2 = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate2.canReadBasicLobDataInLocator() ? delegate2.getBinaryStream(pos) : delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate2.getBufferSize(), pos);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (GETBINSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_LONG_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            InputStream delegateReturn;
            oracle.jdbc.internal.OracleBlob delegate2 = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate2.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate2.getBinaryStream(pos, length);
            } else {
                long lobLen = delegate2.length();
                if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate2.getBufferSize(), pos, length);
            }
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (SETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set binary stream");
        }
        Method m = SETBINSTREAM_LONG_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob delegate2 = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate2.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            OutputStream delegateReturn = delegate2.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate2.getBufferSize(), pos, true);
            return (OutputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (OutputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.setBinaryStream(pos);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleBlob delegate2 = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
        return delegate2.getInternalConnection();
    }
}

