/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={OracleBfile.class, oracle.jdbc.internal.OracleBfile.class})
public abstract class NonTxnReplayableBfile
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETBINSTREAM_METHOD = NonTxnReplayableBfile.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = NonTxnReplayableBfile.getGetBinaryStreamLongMethod();
    private static final int MAX_CHUNK_SIZE = 32512;

    private static final Method getGetBinaryStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args2) {
        super.preForAll(m, receiver, args2);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result2) {
        if (result2 instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result2;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m, result2);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBfile delegate2 = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
            InputStream delegateReturn = delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)((Object)this), 32512, 0L);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBfile delegate2 = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
            InputStream delegateReturn = delegate2.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)((Object)this), 32512, pos);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleBfile delegate2 = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
        return delegate2.getInternalConnection();
    }
}

