/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext
implements Diagnosable {
    private PickleOutputStream outStream;
    private static final String CLASS_NAME = PickleContext.class.getName();
    byte[] image;
    int imageOffset;
    private byte[] byteBuffer = new byte[5];
    private int userCode = 0;
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    public static final byte KOPU_UPT_INDEX_TBL = 1;
    public static final byte KOPU_UPT_NEST_TBL = 2;
    public static final byte KOPU_UPT_VARRAY = 3;
    public static final byte KOPU_UPT_ASSOC_ARRAY = 4;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;

    public PickleContext() {
    }

    public PickleContext(byte[] pickled_bytes) {
        this.image = pickled_bytes;
        this.imageOffset = 0;
    }

    public PickleContext(byte[] pickled_bytes, long offset) {
        this.image = pickled_bytes;
        this.imageOffset = (int)offset;
    }

    public void initStream(int imglen) {
        this.outStream = new PickleOutputStream(imglen);
    }

    public void initStream() {
        this.outStream = new PickleOutputStream();
    }

    public int lengthInBytes(int v) {
        return v <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeElementNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeImmediatelyEmbeddedElementNull(byte null_adtno) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_IEMN;
        this.byteBuffer[1] = null_adtno;
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeSB2(int len) throws SQLException {
        this.byteBuffer[0] = (byte)(len >> 8 & 0xFF);
        this.byteBuffer[1] = (byte)(len & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeUB4(int value) throws SQLException {
        this.byteBuffer[0] = (byte)(value >> 24 & 0xFF);
        this.byteBuffer[1] = (byte)(value >> 16 & 0xFF);
        this.byteBuffer[2] = (byte)(value >> 8 & 0xFF);
        this.byteBuffer[3] = (byte)(value & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 4);
        return 4;
    }

    public int writeLength(int len) throws SQLException {
        if (len <= KOPI20_LN_MAXV) {
            this.outStream.write((byte)len);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(len >> 24);
        this.byteBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(len &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException ioException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "writeLength", ioException.getMessage(), null, ioException, new Object[0]);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioException).fillInStackTrace();
        }
        return 5;
    }

    public int writeLength(int datalen, boolean include) throws SQLException {
        if (!include) {
            return this.writeLength(datalen);
        }
        if (datalen <= KOPI20_LN_MAXV - 1) {
            this.outStream.write((byte)datalen + 1);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)((datalen += 5) >> 24);
        this.byteBuffer[2] = (byte)((datalen &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((datalen &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(datalen &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException ioException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "writeLength", ioException.getMessage(), null, ioException, new Object[0]);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioException).fillInStackTrace();
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int len) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(len >> 24);
        this.byteBuffer[2] = (byte)((len &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((len &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(len &= 0xFF);
        return this.byteBuffer;
    }

    public int writeData(byte b) throws SQLException {
        this.outStream.write(b);
        return 1;
    }

    public int writeData(byte[] b) throws SQLException {
        try {
            this.outStream.write(b);
        }
        catch (IOException ioException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "writeData", ioException.getMessage(), null, ioException, new Object[0]);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioException).fillInStackTrace();
        }
        return b.length;
    }

    public void patchImageLen(int offset, int image_length) throws SQLException {
        byte[] lenbuf = this.to5bLengthBytes_pctx(image_length);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "patchImageLen", "imglen={0},lenbuf={1}", (String)null, null, (Object)image_length, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, lenbuf, new long[0]));
        this.outStream.overwrite(offset, lenbuf, 0, lenbuf.length);
    }

    public int writeImageHeader(boolean withPrefix) throws SQLException {
        return this.writeImageHeader(KOPI20_LN_MAXV + 1, withPrefix);
    }

    public int writeOpaqueImageHeader(int data_length) throws SQLException {
        int count2 = 2;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return count2 += this.writeLength(data_length + 2, true);
    }

    public int writeImageHeader(int image_length, boolean withPrefix) throws SQLException {
        int count2 = 2;
        this.byteBuffer[0] = withPrefix ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return count2 += this.writeLength(image_length);
    }

    public int writeCollImageHeader(int num_collection_items, int typeVersion) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, num_collection_items, typeVersion);
    }

    public int writeCollImageHeader(int image_length, int num_collection_items, int typeVersion) throws SQLException {
        int count2 = 5;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        count2 += this.writeLength(image_length);
        this.byteBuffer[0] = 1;
        this.byteBuffer[1] = 17;
        if (typeVersion > KOPI20_LN_MAXV) {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 5);
            count2 += 5;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeLength(typeVersion);
        } else {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 2);
            count2 += 2;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeSB2(typeVersion);
        }
        this.byteBuffer[0] = this.userCode == 1 ? (byte)KOPI20_CF_INDX : (byte)0;
        this.outStream.write(this.byteBuffer, 0, 1);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "writeCollImageHeader", "image_length={0}, num_collection_items{1}, typeVersion={2}, userCode{3}", (String)null, null, (Object)image_length, (Object)num_collection_items, (Object)typeVersion, (Object)this.userCode);
        return count2 += this.writeLength(num_collection_items);
    }

    public int writeCollImageHeader(byte[] prefix_segment) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, prefix_segment);
    }

    public int writeCollImageHeader(int image_length, byte[] prefix_segment) throws SQLException {
        int psegLen = prefix_segment.length;
        int count2 = 3 + psegLen;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        count2 += this.writeLength(image_length);
        this.byteBuffer[0] = 0;
        this.outStream.write(this.byteBuffer, 0, 1);
        this.outStream.write(prefix_segment, 0, psegLen);
        return count2 += this.writeLength(psegLen + 1);
    }

    public byte[] stream2Bytes() throws SQLException {
        return this.outStream.toByteArray();
    }

    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.imageOffset];
            return by;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public boolean readAndCheckVersion() throws SQLException {
        try {
            boolean bl = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
            return bl;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public int readLength() throws SQLException {
        int len = this.image[this.imageOffset] & 0xFF;
        if (len > KOPI20_LN_MAXV) {
            if (len == KOPI20_LN_ELNL) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid null flag read").fillInStackTrace();
            }
            len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        return len;
    }

    public void skipLength() throws SQLException {
        int len = this.image[this.imageOffset] & 0xFF;
        this.imageOffset = len > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
    }

    public int readRestOfLength(byte len) throws SQLException {
        if ((len & 0xFF) != KOPI20_LN_5BLN) {
            return len & 0xFF;
        }
        try {
            int n = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
            return n;
        }
        finally {
            this.imageOffset += 4;
        }
    }

    public void skipRestOfLength(byte len) throws SQLException {
        if ((len & 0xFF) > KOPI20_LN_MAXV) {
            if ((len & 0xFF) == KOPI20_LN_5BLN) {
                this.imageOffset += 4;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid first length byte").fillInStackTrace();
            }
        }
    }

    public int readLength(boolean exclude) throws SQLException {
        int len = this.image[this.imageOffset] & 0xFF;
        if (len > KOPI20_LN_MAXV) {
            len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            if (exclude) {
                len -= 5;
            }
            this.imageOffset += 5;
        } else {
            if (exclude) {
                --len;
            }
            ++this.imageOffset;
        }
        return len;
    }

    public byte[] readPrefixSegment() throws SQLException {
        byte[] b = new byte[this.readLength()];
        System.arraycopy(this.image, this.imageOffset, b, 0, b.length);
        this.imageOffset += b.length;
        return b;
    }

    public byte[] readDataValue() throws SQLException {
        int len = this.image[this.imageOffset] & 0xFF;
        if (len == KOPI20_LN_ELNL) {
            ++this.imageOffset;
            return null;
        }
        if (len > KOPI20_LN_MAXV) {
            len = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        byte[] b = new byte[len];
        System.arraycopy(this.image, this.imageOffset, b, 0, b.length);
        this.imageOffset += b.length;
        return b;
    }

    public byte[] readBytes(int length) throws SQLException {
        byte[] b = new byte[length];
        System.arraycopy(this.image, this.imageOffset, b, 0, length);
        this.imageOffset += length;
        return b;
    }

    public byte[] read1ByteDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] b = new byte[this.image[this.imageOffset] & 0xFF];
        System.arraycopy(this.image, this.imageOffset + 1, b, 0, b.length);
        this.imageOffset += b.length + 1;
        return b;
    }

    public byte[] readDataValue(byte byte1) throws SQLException {
        byte[] b = new byte[this.readRestOfLength(byte1)];
        System.arraycopy(this.image, this.imageOffset, b, 0, b.length);
        this.imageOffset += b.length;
        return b;
    }

    public byte[] readDataValue(int len) throws SQLException {
        byte[] b = new byte[len];
        System.arraycopy(this.image, this.imageOffset, b, 0, len);
        this.imageOffset += len;
        return b;
    }

    public long readUB4() throws SQLException {
        long ret = (long)this.image[this.imageOffset++] << 24 & 0xFFFFFFFFFF000000L | (long)this.image[this.imageOffset++] << 16 & 0xFF0000L | (long)this.image[this.imageOffset++] << 8 & 0xFF00L | (long)this.image[this.imageOffset++] & 0xFFL;
        return ret;
    }

    public int readUB2() throws SQLException {
        int ret = this.image[this.imageOffset++] << 8 & 0xFF00 | this.image[this.imageOffset++] & 0xFF;
        return ret;
    }

    public void skipDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.imageOffset;
        } else {
            this.skipBytes(this.readLength());
        }
    }

    public void skipDataValue(byte b) throws SQLException {
        this.skipBytes(this.readRestOfLength(b));
    }

    public void skipBytes(int b) throws SQLException {
        if (b > 0) {
            this.imageOffset += b;
        }
    }

    public int offset() throws SQLException {
        if (this.outStream != null) {
            return this.outStream.offset();
        }
        return this.imageOffset;
    }

    public int absoluteOffset() throws SQLException {
        return this.imageOffset;
    }

    public void skipTo(long offset) throws SQLException {
        if (offset > (long)this.imageOffset) {
            this.imageOffset = (int)offset;
        }
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    public static boolean is81format(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix(byte flag) throws SQLException {
        return (flag & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmediatelyEmbeddedNull(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull(byte flag) throws SQLException {
        return (flag & 0xFF) == KOPI20_LN_ELNL;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    void setCollectionUserCode(int userCode) {
        this.userCode = userCode;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

