/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class OracleTypeTIMESTAMPLTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1615519855865602397L;
    int precision = 0;
    transient oracle.jdbc.internal.OracleConnection connection;

    protected OracleTypeTIMESTAMPLTZ() {
    }

    public OracleTypeTIMESTAMPLTZ(oracle.jdbc.internal.OracleConnection _connection) {
        this.connection = _connection;
    }

    @Override
    public int getTypeCode() {
        return -102;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        this.precision = tdsReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.precision = in.readByte();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.precision);
    }

    @Override
    protected Object toObject(byte[] bytes, int otype, Map map2) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (otype) {
            case 1: {
                return new TIMESTAMPLTZ(bytes);
            }
            case 2: {
                return JavaToJavaConverter.convert(new TIMESTAMPLTZ(bytes), OffsetDateTime.class, (OracleConnection)this.connection.getPhysicalConnection(), null, null);
            }
            case 3: {
                return bytes;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
    }

    @Override
    public Datum toDatum(Object value, oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        Datum datum = null;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (value != null) {
                try {
                    datum = value instanceof TIMESTAMPLTZ ? (TIMESTAMPLTZ)value : (value instanceof byte[] ? new TIMESTAMPLTZ((byte[])value) : (value instanceof Timestamp ? new TIMESTAMPLTZ((Connection)conn, (Timestamp)value) : (value instanceof DATE ? new TIMESTAMPLTZ((Connection)conn, (DATE)value) : (value instanceof String ? new TIMESTAMPLTZ((Connection)conn, (String)value) : (value instanceof Date ? new TIMESTAMPLTZ((Connection)conn, (Date)value) : (value instanceof Time ? new TIMESTAMPLTZ((Connection)conn, (Time)value) : (Datum)JavaToJavaConverter.convert(value, TIMESTAMPLTZ.class, (OracleConnection)this.connection.getPhysicalConnection(), null, null)))))));
                }
                catch (Exception ea) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = datum;
            return tIMESTAMPLTZ;
        }
    }

    protected Object unpickle81rec(UnpickleContext context, int format, int otype, Map map2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

