/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;
import oracle.sql.RAW;

public class OracleTypeRAW
extends OracleType
implements Serializable {
    static final long serialVersionUID = -6083664758336974576L;
    int length;

    public OracleTypeRAW() {
    }

    public OracleTypeRAW(int typecode) {
        super(typecode);
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        RAW datum = null;
        if (value != null) {
            try {
                datum = value instanceof RAW ? (RAW)value : new RAW(value);
            }
            catch (SQLException e) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
            }
        }
        return datum;
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count2) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof char[][]) {
                char[][] strArray = (char[][])obj;
                int length = (int)(count2 == -1 ? (long)strArray.length : Math.min((long)strArray.length - beginIdx + 1L, (long)count2));
                datumArray = new Datum[length];
                for (int i = 0; i < length; ++i) {
                    datumArray[i] = this.toDatum(new String(strArray[(int)beginIdx + i - 1]), conn);
                }
            } else {
                if (obj instanceof Object[]) {
                    return super.toDatumArray(obj, conn, beginIdx, count2);
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return -2;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        super.parseTDSrec(tdsReader);
        this.length = tdsReader.readUB2();
    }

    @Override
    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        if (data.getLength() > (long)this.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, this).fillInStackTrace();
        }
        int len = ctx.writeLength((int)data.getLength());
        return len += ctx.writeData(data.shareBytes());
    }

    public int getLength() {
        return this.length;
    }

    @Override
    protected Object toObject(byte[] val, int style, Map map2) throws SQLException {
        if (val == null || val.length == 0) {
            return null;
        }
        switch (style) {
            case 1: {
                return new RAW(val);
            }
            case 2: 
            case 3: {
                return val;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, val).fillInStackTrace();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
    }
}

