/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.CHAR;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;

public class OracleTypeINTERVAL
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1394800182554224957L;
    static final int LDIINTYEARMONTH = 7;
    static final int LDIINTDAYSECOND = 10;
    static final int SIZE_INTERVAL_YM = 5;
    static final int SIZE_INTERVAL_DS = 11;
    byte typeId = 0;
    int scale = 0;
    int precision = 0;

    protected OracleTypeINTERVAL() {
    }

    public OracleTypeINTERVAL(OracleConnection connection) {
    }

    @Override
    public int getTypeCode() {
        if (this.typeId == 7) {
            return -103;
        }
        if (this.typeId == 10) {
            return -104;
        }
        return 1111;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        this.typeId = tdsReader.readByte();
        this.precision = tdsReader.readByte();
        this.scale = tdsReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return this.scale;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.typeId = in.readByte();
        this.precision = in.readByte();
        this.scale = in.readByte();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.typeId);
        out.writeByte(this.precision);
        out.writeByte(this.scale);
    }

    @Override
    protected Object toObject(byte[] bytes, int otype, Map map2) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (otype) {
            case 1: 
            case 2: {
                if (bytes.length == 5) {
                    return new INTERVALYM(bytes);
                }
                if (bytes.length != 11) break;
                return new INTERVALDS(bytes);
            }
            case 3: {
                return bytes;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
            }
        }
        return null;
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        Object srcValue = value;
        if (srcValue != null) {
            if (srcValue instanceof INTERVALYM || srcValue instanceof INTERVALDS) {
                return (Datum)srcValue;
            }
            if (srcValue instanceof CHAR) {
                srcValue = ((CHAR)srcValue).toString();
            } else {
                if (srcValue instanceof String) {
                    try {
                        return new INTERVALDS((String)srcValue);
                    }
                    catch (StringIndexOutOfBoundsException ea) {
                        return new INTERVALYM((String)srcValue);
                    }
                }
                if (srcValue instanceof Duration) {
                    return INTERVALDS.toIntervalds((Duration)srcValue);
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
            }
        }
        return null;
    }

    protected Object unpickle81rec(UnpickleContext context, int format, int otype, Map map2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
    }
}

