/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.Datum;

public class OracleTypeFLOAT
extends OracleType
implements Serializable {
    static final long serialVersionUID = 4088841548269771109L;
    int precision;

    protected OracleTypeFLOAT() {
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(value, conn);
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count2);
    }

    @Override
    public int getTypeCode() {
        return 6;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        this.precision = tdsReader.readUnsignedByte();
    }

    @Override
    public int getScale() {
        return -127;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    protected static Object unpickle81NativeArray(PickleContext context, long beginIdx, int size, int type) throws SQLException {
        return OracleTypeNUMBER.unpickle81NativeArray(context, beginIdx, size, type);
    }

    @Override
    protected Object toObject(byte[] bytes, int type, Map map2) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(bytes, type, map2);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.precision = in.readInt();
    }
}

