/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;

public class OracleTypeBINARY_DOUBLE
extends OracleType
implements Serializable {
    protected OracleTypeBINARY_DOUBLE() {
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        BINARY_DOUBLE datum = null;
        if (value != null) {
            if (value instanceof BINARY_DOUBLE) {
                datum = (BINARY_DOUBLE)value;
            } else if (value instanceof Double) {
                datum = new BINARY_DOUBLE((Double)value);
            } else if (value instanceof byte[]) {
                datum = new BINARY_DOUBLE((byte[])value);
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
            }
        }
        return datum;
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count2) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null && obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int length = (int)(count2 == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count2));
            datumArray = new Datum[length];
            for (int i = 0; i < length; ++i) {
                Object o = objArray[(int)beginIdx + i - 1];
                if (o != null) {
                    if (o instanceof Double) {
                        datumArray[i] = new BINARY_DOUBLE((double)((Double)o));
                        continue;
                    }
                    if (o instanceof BINARY_DOUBLE) {
                        datumArray[i] = (BINARY_DOUBLE)o;
                        continue;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                datumArray[i] = null;
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 101;
    }

    @Override
    protected Object toObject(byte[] bytes, int type, Map map2) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (type == 1) {
            return new BINARY_DOUBLE(bytes);
        }
        if (type == 2) {
            return new BINARY_DOUBLE(bytes).toJdbc();
        }
        if (type == 3) {
            return bytes;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes).fillInStackTrace();
    }
}

