/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.util.Service;

public class UnifiedRules {
    private static final String fname = "allRules.txt";
    private static final String path = "/oracle/jdbc/driver/parser/";

    private UnifiedRules() {
    }

    public static RuleTuple[] getRules(URL url2) throws IOException {
        InputStream is = url2.openStream();
        String[] lines = Service.readFile(is).split("\n");
        is.close();
        RuleTuple[] rules = new RuleTuple[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String token = lines[i].trim();
            int colonPos = token.indexOf(": ");
            String head = token.substring(0, colonPos);
            String[] rhs = token.substring(colonPos + ": ".length()).split(" ");
            rules[i] = new RuleTuple(head, rhs);
        }
        return rules;
    }

    public static RuleTuple[] getRules() throws IOException {
        return UnifiedRules.getSQLRules();
    }

    public static RuleTuple[] getSQLRules() throws IOException {
        Class<UnifiedRules> refClass = UnifiedRules.class;
        URL u = refClass.getResource("/oracle/jdbc/driver/parser/allRules.txt");
        return UnifiedRules.getRules(u);
    }
}

