/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.Parser;
import oracle.jdbc.driver.parser.util.Array;

public class ParseNode
implements Comparable<ParseNode> {
    public int from;
    public int to;
    public ParseNode parent;
    ParseNode lft = null;
    ParseNode rgt = null;
    int[] symbols = new int[0];
    public Set<ParseNode> topLevel = null;
    public Parser parser;
    public static String ignoreMarkers = null;

    public boolean contains(int symbol) {
        return this.symbols[Array.indexOf(this.symbols, symbol)] == symbol;
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> ret = new ArrayList<ParseNode>();
        ret.add(this);
        for (ParseNode n : this.children()) {
            ret.addAll(n.descendants());
        }
        return ret;
    }

    @Override
    public int compareTo(ParseNode obj) {
        ParseNode src = obj;
        if (this.from != src.from) {
            return this.from - src.from;
        }
        return this.to - src.to;
    }

    public ParseNode next() {
        Iterator<ParseNode> iterator2;
        if (this.lft != null) {
            if (this.lft.isAuxiliary()) {
                return this.lft.next();
            }
            return this.lft;
        }
        ParseNode prt = this.parent;
        while (prt != null) {
            ParseNode nextSibling = prt.rgt;
            if (nextSibling == null && prt.topLevel != null) {
                for (ParseNode p : prt.topLevel) {
                    if (this.to > p.from) continue;
                    if (p.isAuxiliary()) {
                        return p.next();
                    }
                    return p;
                }
            }
            if (nextSibling != null && this.to == nextSibling.from) {
                if (nextSibling.isAuxiliary()) {
                    return nextSibling.next();
                }
                return nextSibling;
            }
            prt = prt.parent;
        }
        if (this.topLevel != null && (iterator2 = this.topLevel.iterator()).hasNext()) {
            ParseNode child = iterator2.next();
            return child;
        }
        return null;
    }

    public int[] content() {
        return this.symbols;
    }

    public void addContent(int symbol) {
        this.symbols = Array.insert(this.symbols, symbol);
    }

    public void deleteContent(int symbol) {
        this.symbols = Array.delete(this.symbols, symbol);
    }

    public void addTopLevel(ParseNode child) {
        if (this.topLevel == null) {
            this.topLevel = new TreeSet<ParseNode>();
        }
        this.topLevel.add(child);
        child.parent = this;
    }

    public ParseNode coveredByOnTopLevel(int pos) {
        if (this.topLevel == null) {
            return null;
        }
        for (ParseNode node : this.topLevel) {
            if (node.from > pos || pos >= node.to) continue;
            return node;
        }
        return null;
    }

    public ParseNode(int begin, int end, int symbol, int dummy, Parser p) {
        this(begin, end, symbol, p);
    }

    public ParseNode(int begin, int end, int symbol, Parser p) {
        this.from = begin;
        this.to = end;
        this.addContent(symbol);
        this.parser = p;
    }

    public String toString() {
        return this.toString(0, false);
    }

    protected String toString(int depth, boolean isCut) {
        if (ignoreMarkers != null) {
            return this.toString(depth, ignoreMarkers, isCut);
        }
        return this.toString(depth, "", isCut);
    }

    protected String toString(int depth, String auxMarker, boolean isCut) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        if (isCut) {
            sb.append("...");
            return sb.toString();
        }
        sb.append(this.interval() + " ");
        int[] nArray = this.content();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            if (i2 == -1) continue;
            Object symbol = this.parser == null || this.parser.allSymbols == null || i2 < 0 || i2 > this.parser.allSymbols.length ? "!" + i2 : this.parser.allSymbols[i2];
            if (0 < auxMarker.length() && 0 <= ((String)symbol).indexOf(auxMarker)) continue;
            sb.append("  " + (String)symbol);
        }
        return sb.toString();
    }

    public String interval() {
        return "[" + this.from + "," + this.to + ")";
    }

    public boolean isAuxiliary() {
        if (this.symbols[0] == -1) {
            return true;
        }
        return this.parser.isAuxNode(this.symbols[0]) && this.symbols.length == 1;
    }

    public SortedSet<ParseNode> children() {
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode child : this.topLevel) {
                if (child.isAuxiliary()) {
                    ret.addAll(child.children());
                    continue;
                }
                ret.add(child);
            }
            return ret;
        }
        if (this.lft == null) {
            return ret;
        }
        if (this.lft.isAuxiliary()) {
            ret.addAll(this.lft.children());
        } else {
            ret.add(this.lft);
        }
        if (this.rgt == null) {
            return ret;
        }
        if (this.rgt.isAuxiliary()) {
            ret.addAll(this.rgt.children());
        } else {
            ret.add(this.rgt);
        }
        return ret;
    }
}

