/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.jdbc.driver.parser.Token;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;
    public static boolean isSqlPlusCmd = false;
    public static String[] customLineCommentPrefixes = new String[0];
    public static final int QuotedStrings = 1;
    public static final int SqlPlusComments = 2;
    public static final int PlSqlMacros = 4;
    public static final int JavaLineComments = 8;
    public static final int SqlLineComments = 16;
    public static final int JavaSqlMultilineComments = 32;
    public static final int HtmlComments = 64;
    public static final int JsonStrings = 128;
    public static final int PoundComments = 256;
    public static final int RegExp = 512;
    public static final int SQL = 63;
    public static final int GRAMMAR = 49;
    public static final int ARBORI = 57;
    public static final int TEST = 49;
    public static final int JAVA = 41;
    public static final int JS = 937;

    public LexerToken(CharSequence text, int from, int to, Token t) {
        this.content = text.toString();
        this.begin = from;
        this.end = to;
        this.type = t;
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + String.valueOf((Object)this.type) + ">";
    }

    private static LinkedList<LexerToken> tokenize(String sourceExpr, int flags, String extraOper, InterruptedException interrupted) throws InterruptedException {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        Object operation = "(){}[]^-|!*+.><='\",;:%@?/\\~" + extraOper;
        if ((flags & 0x40) == 64) {
            operation = "></-=\"!";
        }
        if ((flags & 0x100) == 256) {
            operation = (String)operation + "#";
        }
        String ws = " \n\r\t";
        StringTokenizer st = new StringTokenizer(sourceExpr, (String)operation + " \n\r\t", true);
        int pos = 0;
        boolean isWrapped = false;
        int contextualFlags = flags;
        block0: while (st.hasMoreTokens()) {
            int context;
            int lineEnd;
            int nextSlash;
            if (interrupted != null && Thread.interrupted()) {
                throw interrupted;
            }
            String token = st.nextToken();
            pos += token.length();
            LexerToken last2 = null;
            if (ret.size() > 0) {
                last2 = ret.getLast();
            }
            if (isWrapped) {
                if ("/".equals(token) && last2 != null && "\n".equals(last2.content)) {
                    String marker = "\"/\"";
                    ret.add(new LexerToken("\"/\"", pos - "\"/\"".length(), pos, Token.IDENTIFIER));
                    isWrapped = false;
                    continue;
                }
                if ("\n".equals(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.WS));
                    continue;
                }
                if (!"\n".equals(last2.content)) continue;
                last2.content = "?";
                continue;
            }
            if (last2 != null && last2.type == Token.COMMENT && (contextualFlags & 0x20) == 32 && (!last2.content.endsWith("*/") || last2.content.equals("/*/"))) {
                last2.content = "*".equals(token) || "/".equals(token) ? last2.content + token : "/* ... ";
                last2.end = pos;
                if (last2 == null || last2.type != Token.COMMENT || !last2.content.endsWith("*/") || last2.content.equals("/*/")) continue;
                last2.content = sourceExpr.substring(last2.begin, last2.end);
                continue;
            }
            if (last2 != null && last2.type == Token.COMMENT && (contextualFlags & 0x40) == 64 && !last2.content.endsWith(">")) {
                String abbr = "<! ...";
                if ("-".equals(token)) {
                    last2.content = last2.content + token;
                } else if (">".equals(token) && (last2.content.length() <= 2 || last2.content.charAt(2) != '-')) {
                    last2.content = last2.content + token;
                } else if (">".equals(token) && (last2.content.length() <= 2 || last2.content.charAt(last2.content.length() - 2) == '-' && last2.content.charAt(last2.content.length() - 3) == '-')) {
                    last2.content = last2.content + token;
                }
                last2.end = pos;
                if (last2 == null || last2.type != Token.COMMENT || !last2.content.endsWith(">")) continue;
                last2.content = sourceExpr.substring(last2.begin, last2.end);
                continue;
            }
            if (!(last2 == null || last2.type != Token.LINE_COMMENT && last2.type != Token.DBTOOLS_COMMAND && last2.type != Token.SQLPLUS_COMMAND || "\n".equals(token) || "\r".equals(token))) {
                last2.content = last2.content + token;
                last2.end += token.length();
                continue;
            }
            if (last2 != null && (last2.type == Token.LINE_COMMENT || last2.type == Token.DBTOOLS_COMMAND || last2.type == Token.SQLPLUS_COMMAND) && ("\n".equals(token) || "\r".equals(token))) {
                last2.end = last2.begin + last2.content.length();
            }
            if (last2 != null && last2.type == Token.QUOTED_STRING && !last2.isStandardLiteral(contextualFlags) && !last2.isAltLiteral()) {
                last2.content = last2.content + token;
                last2.end = last2.begin + last2.content.length();
                continue;
            }
            if (last2 != null && last2.type == Token.DQUOTED_STRING && ("\"" != token || last2.content.endsWith("\\")) && (!last2.content.endsWith("\"") || (contextualFlags & 0x80) == 128 && last2.content.endsWith("\\\"") || last2.content.length() == 1)) {
                last2.content = last2.content + token;
                last2.end = last2.begin + last2.content.length();
                continue;
            }
            if (last2 != null && last2.type == Token.DQUOTED_STRING && "\"".equals(token)) {
                last2.end = pos;
                last2.content = sourceExpr.substring(last2.begin, last2.end);
                continue;
            }
            if (last2 != null && last2.type == Token.BQUOTED_STRING && !"`".equals(token) && (!last2.content.endsWith("`") || last2.content.length() <= 1)) continue;
            if (last2 != null && last2.type == Token.BQUOTED_STRING && "`".equals(token)) {
                if (LexerToken.insideTemplateVar(sourceExpr.substring(last2.begin + 1, pos)) || sourceExpr.charAt(pos - 2) == '\\' && (pos - 3 < 0 || sourceExpr.charAt(pos - 3) != '\\')) continue;
                last2.end = pos;
                last2.content = sourceExpr.substring(last2.begin, last2.end);
                continue;
            }
            if (last2 != null && last2.type == Token.REGEXP && pos <= last2.end) {
                if (!"/".equals(token) || last2.end != pos) continue;
                last2.content = sourceExpr.substring(last2.begin, last2.end);
                continue;
            }
            if ((contextualFlags & 0x20) == 32 && "*".equals(token) && last2 != null && "/".equals(last2.content)) {
                last2.content = last2.content + token;
                last2.end = last2.begin + last2.content.length();
                last2.type = Token.COMMENT;
                continue;
            }
            if (!((contextualFlags & 0x200) != 512 || "*".equals(token) || "/".equals(token) || last2 == null || !"/".equals(last2.content) || 0 >= (nextSlash = LexerToken.terminatingSlash(sourceExpr, last2.end, lineEnd = sourceExpr.indexOf(10, last2.end))) || nextSlash >= lineEnd && lineEnd != -1)) {
                last2.content = last2.content + token;
                last2.end = nextSlash + 1;
                last2.type = Token.REGEXP;
                continue;
            }
            if ((contextualFlags & 0x10) == 16 && "-".equals(token) && last2 != null && "-".equals(last2.content) || (contextualFlags & 8) == 8 && "/".equals(token) && last2 != null && "/".equals(last2.content)) {
                boolean isHttp = false;
                if ("/".equals(token)) {
                    int start = last2.begin - "http:".length();
                    if (0 <= start && "http:".equalsIgnoreCase(sourceExpr.substring(start, last2.begin))) {
                        isHttp = true;
                    }
                    if (0 <= (start = last2.begin - "https:".length()) && "https:".equalsIgnoreCase(sourceExpr.substring(start, last2.begin))) {
                        isHttp = true;
                    }
                }
                if (!isHttp) {
                    last2.content = last2.content + token;
                    last2.type = Token.LINE_COMMENT;
                    last2.end += token.length();
                    continue;
                }
            }
            if ((contextualFlags & 0x40) == 64 && "!".equals(token) && last2 != null && "<".equals(last2.content)) {
                last2.content = last2.content + token;
                last2.end = last2.begin + last2.content.length();
                last2.type = Token.COMMENT;
                continue;
            }
            if ((contextualFlags & 2) == 2 && ("rem".equalsIgnoreCase(token) || "rema".equalsIgnoreCase(token) || "remar".equalsIgnoreCase(token) || "remark".equalsIgnoreCase(token) || "pro".equalsIgnoreCase(token) || "prom".equalsIgnoreCase(token) || "promp".equalsIgnoreCase(token) || "prompt".equalsIgnoreCase(token)) && (last2 == null || "\n".equals(last2.content) || "\r".equals(last2.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                continue;
            }
            for (String pref : customLineCommentPrefixes) {
                if (pref.equalsIgnoreCase(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                    continue block0;
                }
                if (last2 == null || !pref.equalsIgnoreCase(last2.content)) continue;
                last2.content = last2.content + token;
                last2.end = last2.begin + last2.content.length() + token.length();
                last2.type = Token.LINE_COMMENT;
                continue block0;
            }
            if ((contextualFlags & 0x100) == 256 && "#".equals(token)) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                continue;
            }
            if ("soda".equalsIgnoreCase(token) && (last2 == null || "\n".equals(last2.content) || "\r".equals(last2.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.DBTOOLS_COMMAND));
                continue;
            }
            if ((contextualFlags & 2) == 2 && LexerToken.isSqlPlusPrefix(token) && (last2 == null || "\n".equals(last2.content) || "\r".equals(last2.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.SQLPLUS_COMMAND));
                continue;
            }
            if (isSqlPlusCmd && last2 != null && "-".equals(last2.content) && ("\n".equals(token) || "\r".equals(token))) {
                last2.type = Token.SQLPLUSLINECONTINUE_SKIP;
            }
            String lastUpper = "N/A";
            if (last2 != null) {
                lastUpper = last2.content.toUpperCase();
            }
            if ((contextualFlags & 4) == 4 && ("$IF".equalsIgnoreCase(token) || "$ELSIF".equalsIgnoreCase(token) || "$ELSE".equalsIgnoreCase(token) || "$END".equalsIgnoreCase(token) || "$ERROR".equalsIgnoreCase(token))) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            if (last2 != null && last2.type == Token.MACRO_SKIP && lastUpper.startsWith("$IF") && lastUpper.endsWith("$THEN")) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            if (last2 != null && last2.type == Token.MACRO_SKIP && (lastUpper.startsWith("$IF") || lastUpper.startsWith("$ELSIF") || lastUpper.startsWith("$ELSE") || lastUpper.startsWith("$ERROR"))) {
                last2.content = last2.content + token;
                last2.end += token.length();
                continue;
            }
            if (last2 != null && last2.type == Token.IDENTIFIER && last2.end == -11 && last2.content.startsWith("@") && !"\n".equals(token) && !"\r".equals(token)) {
                last2.content = last2.content + token;
                continue;
            }
            if (last2 != null && last2.type == Token.IDENTIFIER && last2.end == -11 && last2.content.startsWith("@") && ("\n".equals(token) || "\r".equals(token))) {
                last2.end = pos - 1;
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if ((contextualFlags & 1) == 1 && "'".equals(token)) {
                if (last2 != null && ("q".equalsIgnoreCase(last2.content) || "N".equalsIgnoreCase(last2.content) || "u".equalsIgnoreCase(last2.content) || "nq".equalsIgnoreCase(last2.content) || "uq".equalsIgnoreCase(last2.content))) {
                    last2.content = last2.content + token;
                    last2.type = Token.QUOTED_STRING;
                    continue;
                }
                ret.add(new LexerToken(token, pos - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if ((contextualFlags & 1) == 1 && "\"".equals(token)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("`".equals(token) && 0 <= ((String)operation).indexOf(96)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.BQUOTED_STRING));
                continue;
            }
            if (token.length() == 1 && 0 <= " \n\r\t".indexOf(token.charAt(0))) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if (token.length() == 1 && 0 <= ((String)operation).indexOf(token.charAt(0))) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.OPERATION));
                continue;
            }
            if (!('0' > token.charAt(0) || token.charAt(0) > '9' || last2 != null && "#".equals(last2.content))) {
                if (LexerToken.isHexLiteral(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                    continue;
                }
                if (LexerToken.fixedExponent(token, ret, pos - token.length())) continue;
                if (token.charAt(token.length() - 1) == 'K' || token.charAt(token.length() - 1) == 'k' || token.charAt(token.length() - 1) == 'M' || token.charAt(token.length() - 1) == 'm' || token.charAt(token.length() - 1) == 'G' || token.charAt(token.length() - 1) == 'g' || token.charAt(token.length() - 1) == 'T' || token.charAt(token.length() - 1) == 't' || token.charAt(token.length() - 1) == 'P' || token.charAt(token.length() - 1) == 'p' || token.charAt(token.length() - 1) == 'E' || token.charAt(token.length() - 1) == 'e') {
                    ret.add(new LexerToken(token.substring(0, token.length() - 1), pos - token.length(), pos - 1, Token.DIGITS));
                    ret.add(new LexerToken(token.substring(token.length() - 1), pos - 1, pos, Token.DIGITS));
                    continue;
                }
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            if ("WRAPPED".equalsIgnoreCase(token) && last2 != null) {
                Iterator<LexerToken> descIter = ret.descendingIterator();
                boolean sawId = false;
                while (descIter.hasNext()) {
                    LexerToken t = descIter.next();
                    if (sawId && ".".equalsIgnoreCase(t.content)) {
                        sawId = false;
                        continue;
                    }
                    if (sawId && ("PROCEDURE".equalsIgnoreCase(t.content) || "FUNCTION".equalsIgnoreCase(t.content) || "TRIGGER".equalsIgnoreCase(t.content) || "TYPE".equalsIgnoreCase(t.content) || "PACKAGE".equalsIgnoreCase(t.content) || "BODY".equalsIgnoreCase(t.content))) {
                        isWrapped = true;
                        break;
                    }
                    if (t.type == Token.WS || t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) continue;
                    if (t.type != Token.IDENTIFIER && t.type != Token.DQUOTED_STRING) break;
                    sawId = true;
                }
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
            if (contextualFlags != flags || (context = LexerToken.inferContext(token)) == -1) continue;
            contextualFlags |= context;
        }
        if (ret.size() > 0) {
            LexerToken last3 = (LexerToken)ret.getLast();
            last3.end = sourceExpr.length();
        }
        return ret;
    }

    private static int inferContext(String token) {
        if ("var".equals(token)) {
            return 937;
        }
        if ("const".equals(token)) {
            return 937;
        }
        if ("let".equals(token)) {
            return 937;
        }
        return -1;
    }

    private static boolean insideTemplateVar(String str) {
        StringTokenizer st = new StringTokenizer(str, "${}", true);
        int nesting = 0;
        String prior = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("{".equals(token) && "$".equals(prior)) {
                ++nesting;
            } else if ("}".equals(token)) {
                --nesting;
            }
            prior = token;
        }
        return 0 < nesting;
    }

    private static int terminatingSlash(String sourceExpr, int start, int end) {
        String input = null;
        input = end < 0 ? sourceExpr.substring(start) : sourceExpr.substring(start, end);
        StringTokenizer st = new StringTokenizer(input, "\\/ ()[]", true);
        String prior = null;
        String current = null;
        int pos = start;
        int parenBalance = 0;
        while (st.hasMoreTokens()) {
            current = st.nextToken();
            if ("[".equals(prior) && "]".equals(current)) {
                prior = null;
                pos += current.length();
                continue;
            }
            if ("[".equals(prior)) {
                pos += current.length();
                continue;
            }
            if ("\\".equals(prior)) {
                prior = null;
                pos += current.length();
                continue;
            }
            if (")".equals(prior)) {
                --parenBalance;
            }
            if ("(".equals(prior)) {
                ++parenBalance;
            }
            if ("/".equals(current)) {
                if (parenBalance != 0) {
                    return -1;
                }
                if (" ".equals(prior) && input.charAt(0) == ' ') {
                    if ("g".equalsIgnoreCase(st.nextToken())) {
                        return pos + 1;
                    }
                    return -1;
                }
                return pos;
            }
            prior = current;
            pos += current.length();
        }
        return -1;
    }

    private static boolean isSqlPlusPrefix(String token) {
        if ("@".equals(token)) {
            return true;
        }
        if ("INPUT".equalsIgnoreCase(token)) {
            return true;
        }
        if ("HOST".equalsIgnoreCase(token)) {
            return true;
        }
        return "PAUSE".equalsIgnoreCase(token);
    }

    private static boolean fixedExponent(String input, List<LexerToken> ret, int pos) {
        String test = input.toLowerCase();
        if (!(test.contains("e") || test.contains("f") || test.contains("d"))) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(test, "efd", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pos += token.length();
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
        }
        return true;
    }

    private static boolean isHexLiteral(String iNput) {
        if (iNput.length() < 3) {
            return false;
        }
        if (iNput.charAt(0) != '0') {
            return false;
        }
        String input = iNput.toLowerCase();
        if (input.charAt(1) != 'x') {
            return false;
        }
        for (int i = 2; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i)) || input.charAt(i) == 'a' || input.charAt(i) == 'b' || input.charAt(i) == 'c' || input.charAt(i) == 'd' || input.charAt(i) == 'e' || input.charAt(i) == 'f') continue;
            return false;
        }
        return true;
    }

    public static List<LexerToken> parse(String input) {
        return LexerToken.parse(input, false);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return LexerToken.parse(input, keepWSandCOMMENTS, 63);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags) {
        try {
            return LexerToken.parse(input, keepWSandCOMMENTS, flags, null);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags, InterruptedException interrupted) throws InterruptedException {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        LexerToken.parse(input, keepWSandCOMMENTS, flags, "", ret, interrupted);
        return ret;
    }

    private static void parse(String input, boolean keepWSandCOMMENTS, int flags, String extraOper, ArrayList<LexerToken> ret, InterruptedException interrupted) throws InterruptedException {
        LexerToken last2 = null;
        for (LexerToken token : LexerToken.tokenize(input, flags, extraOper, interrupted)) {
            if (token.type == Token.IDENTIFIER && last2 != null && last2.type == Token.DQUOTED_STRING && token.content.startsWith("___")) {
                last2.content = last2.content + token.content;
                last2.end = token.end;
                continue;
            }
            if (token.type == Token.QUOTED_STRING) {
                if (last2 != null && last2.type == Token.QUOTED_STRING) {
                    last2.content = last2.content + token.content;
                    last2.end = token.end;
                    continue;
                }
                if (last2 != null && last2.type == Token.IDENTIFIER && "n".equalsIgnoreCase(last2.content) && last2.end == token.begin) {
                    last2.begin = token.begin;
                    last2.end = token.end;
                    last2.type = token.type;
                    last2.content = token.content;
                    continue;
                }
            }
            if (token.content.startsWith("@")) {
                token.end = token.begin + token.content.length();
            }
            if ("#".equals(token.content) && last2 != null && last2.type == Token.IDENTIFIER) {
                ++last2.end;
                last2.content = last2.content + "#";
                continue;
            }
            if ((token.type == Token.IDENTIFIER || token.type == Token.DIGITS) && last2 != null && last2.content.endsWith("#") && last2.type == Token.IDENTIFIER) {
                last2.end += token.content.length();
                last2.content = last2.content + token.content;
                continue;
            }
            if (keepWSandCOMMENTS || token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT && token.type != Token.MACRO_SKIP && token.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                ret.add(token);
            }
            last2 = token;
        }
    }

    private static char matchingDelimiter(char ch) {
        if ('<' == ch) {
            return '>';
        }
        if ('[' == ch) {
            return ']';
        }
        if ('{' == ch) {
            return '}';
        }
        if ('(' == ch) {
            return ')';
        }
        return ch;
    }

    boolean isStandardLiteral(int flags) {
        if (this.content.length() < 2) {
            return false;
        }
        if (this.content.charAt(0) != '\'' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U') {
            return false;
        }
        String text = this.content;
        if (text.charAt(0) == 'n' || text.charAt(0) == 'N' || text.charAt(0) == 'u' || text.charAt(0) == 'U') {
            if (text.length() < 3) {
                return false;
            }
            text = text.substring(1);
        }
        if (text.length() < 2) {
            return false;
        }
        return text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'' && (flags != 937 || text.charAt(text.length() - 2) != '\\' || text.length() < 3 || text.charAt(text.length() - 3) == '\\');
    }

    boolean isAltLiteral() {
        if (this.content.length() < 5) {
            return false;
        }
        if (this.content.charAt(0) != 'q' && this.content.charAt(0) != 'Q' && this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U') {
            return false;
        }
        String text = this.content;
        if (!(this.content.charAt(0) != 'n' && this.content.charAt(0) != 'N' && this.content.charAt(0) != 'u' && this.content.charAt(0) != 'U' || this.content.charAt(1) != 'q' && this.content.charAt(1) != 'Q')) {
            if (text.length() < 6) {
                return false;
            }
            text = text.substring(2);
        } else if (this.content.charAt(0) == 'q' || this.content.charAt(0) == 'Q' || this.content.charAt(0) == 'u' || this.content.charAt(0) == 'U') {
            text = text.substring(1);
        } else {
            return false;
        }
        if (text.charAt(0) != '\'' || text.charAt(text.length() - 1) != '\'') {
            return false;
        }
        text = text.substring(1, text.length() - 1);
        return LexerToken.matchingDelimiter(text.charAt(0)) == text.charAt(text.length() - 1);
    }
}

