/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonConstants;

public class OsonHeader {
    private static byte[][] UTF8_MAPPING = new byte[2048][];
    int version;
    short flags;
    short flags2;
    private int uniqueFields;
    private int[] hashIdArray;
    private String[] fieldNames;
    private int fieldHeapSize;
    private int uniqueFields2;
    private int[] hashIdArray2;
    private String[] fieldNames2;
    private int fieldHeapSize2;
    int ubFieldId;
    int treeSegmentSize;
    int treeSegmentOffset;
    int tinyNodeCount;
    int updateFlags;
    int extendedTreeSegmentOffset;
    Map<Integer, Integer> forwardingAddress;

    public OsonHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f2) {
        this.readHeader(b, f2);
        this.treeSegmentOffset = b.position();
        if (this.isScalar()) {
            return;
        }
        if (this.uniqueFields > 0) {
            this.readDictionary(b);
        }
        if (this.uniqueFields2 > 0) {
            this.readDictionary2(b);
        }
        if (!this.isSet(4) || !this.isSet(2)) {
            throw new UnsupportedOperationException();
        }
        int updateHeaderOffset = this.treeSegmentOffset + this.treeSegmentSize;
        if (updateHeaderOffset < b.buffer().limit()) {
            b.position(updateHeaderOffset);
            this.readUpdateHeader(b, f2);
        }
    }

    public void readHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f2) {
        if (b.buffer().remaining() <= 6) {
            throw OracleJsonExceptions.CORRUPT2.create(f2, b.buffer().remaining());
        }
        int magicAndVersion = b.getInt();
        if ((magicAndVersion & 0xFFFFFF00) != -11904512) {
            throw OracleJsonExceptions.CORRUPT.create(f2, new Object[0]);
        }
        this.version = magicAndVersion & 0xFF;
        if (this.version < 1 || this.version > 4) {
            throw OracleJsonExceptions.UNSUPPORTED_VERSION.create(f2, this.version);
        }
        this.flags = (short)b.getUB2();
        if (!this.isSet(16)) {
            if (this.isSet(8)) {
                this.ubFieldId = 4;
                this.uniqueFields = b.getUB4int();
            } else if (this.isSet(1024)) {
                this.ubFieldId = 2;
                this.uniqueFields = b.getUB2();
            } else {
                this.ubFieldId = 1;
                this.uniqueFields = b.getUB1();
            }
            int n = this.fieldHeapSize = this.isSet(2048) ? b.getUB4int() : b.getUB2();
            if (this.version >= 3) {
                this.flags2 = (short)b.getUB2();
                this.uniqueFields2 = b.getUB4int();
                this.fieldHeapSize2 = b.getUB4int();
            }
            this.treeSegmentSize = this.isSet(4096) ? b.getUB4int() : b.getUB2();
            this.tinyNodeCount = b.getUB2();
        } else {
            this.treeSegmentSize = this.isSet(4096) ? b.getUB4int() : b.getUB2();
        }
    }

    private void readDictionary(OsonBuffer b) {
        int[] fieldNameOffsets = new int[this.uniqueFields];
        this.hashIdArray = new int[this.uniqueFields];
        this.fieldNames = new String[this.uniqueFields];
        this.ub1(b, this.hashIdArray);
        if (this.isSet(2048)) {
            this.ub4int(b, fieldNameOffsets);
        } else {
            this.ub2(b, fieldNameOffsets);
        }
        int offset = b.position();
        this.treeSegmentOffset = b.position() + this.fieldHeapSize;
        for (int i = 0; i < fieldNameOffsets.length; ++i) {
            b.position(fieldNameOffsets[i] + offset);
            int len = b.getUB1();
            this.fieldNames[i] = b.readString(len);
        }
        b.position(this.treeSegmentOffset);
    }

    private void readDictionary2(OsonBuffer b) {
        int[] fieldNameOffsets2 = new int[this.uniqueFields2];
        this.hashIdArray2 = new int[this.uniqueFields2];
        this.fieldNames2 = new String[this.uniqueFields2];
        this.ub2(b, this.hashIdArray2);
        if (this.isSet2(256)) {
            this.ub2(b, fieldNameOffsets2);
        } else {
            this.ub4int(b, fieldNameOffsets2);
        }
        int offset = b.position();
        this.treeSegmentOffset = b.position() + this.fieldHeapSize2;
        for (int i = 0; i < fieldNameOffsets2.length; ++i) {
            b.position(fieldNameOffsets2[i] + offset);
            int len = b.getUB2();
            this.fieldNames2[i] = b.readString(len);
        }
        b.position(this.treeSegmentOffset);
    }

    public String getFieldName(int fid) {
        return fid < this.uniqueFields ? this.fieldNames[fid] : this.fieldNames2[fid - this.uniqueFields];
    }

    private void readUpdateHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f2) {
        this.updateFlags = b.getUB2();
        int numOverflowAddrSeg = b.getUB2();
        b.getUB4int();
        int overflowMappingSize = b.getUB4int();
        b.getUB4int();
        this.extendedTreeSegmentOffset = b.position() + overflowMappingSize;
        this.forwardingAddress = new HashMap<Integer, Integer>();
        if (this.isSetUpd(256)) {
            for (int i = 0; i < numOverflowAddrSeg; ++i) {
                this.forwardingAddress.put(b.getUB2(), b.getUB2());
            }
        } else {
            for (int i = 0; i < numOverflowAddrSeg; ++i) {
                this.forwardingAddress.put(b.getUB4int(), b.getUB4int());
            }
        }
    }

    public boolean isScalar() {
        return this.isSet(16);
    }

    public boolean isTinyNodeCount() {
        return this.isSet(8192);
    }

    private void ub1(OsonBuffer s2, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s2.getUB1();
        }
    }

    private void ub2(OsonBuffer s2, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s2.getUB2();
        }
    }

    private void ub4int(OsonBuffer s2, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s2.getUB4int();
        }
    }

    public int getTreeSegmentOffset() {
        return this.treeSegmentOffset;
    }

    public int getFieldHeapSize() {
        return this.fieldHeapSize;
    }

    public String[] getFields() {
        return this.fieldNames;
    }

    public int[] hashIds() {
        return this.hashIdArray;
    }

    private boolean isSet(int f2) {
        return (this.flags & f2) != 0;
    }

    private boolean isSet2(int f2) {
        return (this.flags2 & f2) != 0;
    }

    private boolean isSetUpd(int f2) {
        return (this.updateFlags & f2) != 0;
    }

    public boolean fieldsSorted() {
        return !this.isSet(32768);
    }

    public boolean relativeOffsets() {
        return this.isSet(1);
    }

    public int getFieldId(String key) {
        int utf8len = OsonHeader.utf8len(key);
        if (utf8len <= OsonConstants.MAX_SMALL_KEY_LENGTH && this.uniqueFields > 0) {
            return this.getFieldId(key, this.hashIdArray, this.fieldNames);
        }
        if (utf8len <= OsonConstants.MAX_BIG_KEY_LENGTH && this.uniqueFields2 > 0) {
            return this.uniqueFields + this.getFieldId(key, this.hashIdArray2, this.fieldNames2);
        }
        return -1;
    }

    private int getFieldId(String key, int[] hashIdArray, String[] fieldNames) {
        int hash = OsonHeader.ohash(key, null);
        int idx = Arrays.binarySearch(hashIdArray, hash);
        if (idx < 0) {
            return -1;
        }
        while (idx > 0 && hashIdArray[idx - 1] == hash) {
            --idx;
        }
        do {
            if (!fieldNames[idx].equals(key)) continue;
            return idx + 1;
        } while (++idx < hashIdArray.length && hashIdArray[idx] == hash);
        return -1;
    }

    public static int ohash(String key, AtomicInteger length) {
        int result2;
        int charlen;
        int hash = -2128831035;
        int len = charlen = key.length();
        for (int i = 0; i < charlen; ++i) {
            char c = key.charAt(i);
            if (c <= '\u007f') {
                hash = (hash ^ c) * 16777619;
                continue;
            }
            if (c <= '\u07ff') {
                ++len;
                hash = (hash ^ UTF8_MAPPING[c][0] & 0xFF) * 16777619;
                hash = (hash ^ UTF8_MAPPING[c][1] & 0xFF) * 16777619;
                continue;
            }
            int cp = key.codePointAt(i);
            if (Character.charCount(cp) == 2) {
                ++i;
            }
            String s2 = new String(Character.toChars(cp));
            byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
            len += bytes.length - 1;
            hash = OsonHeader.hashUtf8(hash, bytes);
        }
        int n = result2 = len <= OsonConstants.MAX_SMALL_KEY_LENGTH ? hash & 0xFF : (hash & 0xFF) << 8 | (hash & 0xFF00) >> 8;
        if (length != null) {
            length.set(len);
        }
        return result2;
    }

    public static int ohash(byte[] key) {
        int hash = -2128831035;
        int res = OsonHeader.hashUtf8(hash, key);
        return key.length <= OsonConstants.MAX_SMALL_KEY_LENGTH ? res & 0xFF : (res & 0xFF) << 8 | (res & 0xFF00) >> 8;
    }

    static int utf8len(String key) {
        int result2 = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c <= '\u007f') {
                ++result2;
                continue;
            }
            if (c <= '\u07ff') {
                result2 += 2;
                continue;
            }
            return key.getBytes(StandardCharsets.UTF_8).length;
        }
        return result2;
    }

    private static int hashUtf8(int hash, byte[] bytes) {
        for (int j = 0; j < bytes.length; ++j) {
            hash = (hash ^ bytes[j] & 0xFF) * 16777619;
        }
        return hash;
    }

    public int numFieldIdBytes() {
        return this.ubFieldId;
    }

    static {
        for (int i = 0; i < UTF8_MAPPING.length; ++i) {
            OsonHeader.UTF8_MAPPING[i] = new String(new char[]{(char)i}).getBytes(StandardCharsets.UTF_8);
        }
    }
}

