/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public class OsonAbstractObject
extends OsonStructureImpl {
    boolean fidSorted;
    int fidArrayOffset;

    public OsonAbstractObject(OsonContext ctx) {
        super(ctx);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.OBJECT;
    }

    public OsonAbstractObject(OsonContext ctx, int pos) {
        super(ctx);
        this.init(pos);
    }

    public OsonAbstractArray getJsonArrayInternal(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return null;
        }
        return this.getArrayInternal(childOffset);
    }

    public OsonAbstractObject getJsonObjectInternal(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return null;
        }
        return this.getJsonObjectInternal(childOffset);
    }

    public String getString(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        String res = this.getStringInternal(childOffset);
        if (res == null) {
            throw new ClassCastException();
        }
        return res;
    }

    public String getString(String key, String d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        String res = this.getStringInternal(childOffset);
        if (res == null) {
            return d;
        }
        return res;
    }

    public boolean getBoolean(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        Boolean res = this.getBooleanInternal(childOffset);
        if (res == null) {
            throw new ClassCastException();
        }
        return res;
    }

    public boolean getBoolean(String key, boolean d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        Boolean res = this.getBooleanInternal(childOffset);
        if (res == null) {
            return d;
        }
        return res;
    }

    public int getInt(String key, int d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        Object json = this.getValueInternal(childOffset);
        if (!(json instanceof OracleJsonNumberImpl)) {
            return d;
        }
        return ((OracleJsonNumberImpl)json).intValue();
    }

    public int getInt(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumberImpl)this.getValueInternal(childOffset)).intValue();
    }

    public boolean isNull(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return this.isNullInternal(childOffset);
    }

    public boolean containsKey(Object key) {
        return key instanceof String && this.getChildOffset((String)key) != -1;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            Object v = this.getValueInternal(this.getChildOffset(i));
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object getInternal(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        int childOffset = this.getChildOffset((String)key);
        if (childOffset < 0) {
            return null;
        }
        return this.getValueInternal(childOffset);
    }

    public Object getInternal(int position) {
        int childOffset = this.getChildOffset(position);
        if (childOffset < 0) {
            return null;
        }
        return this.getValueInternal(childOffset);
    }

    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new OsonStructureImpl.PositionIter<String>(){

                    @Override
                    public String getValue(int pos) {
                        return OsonAbstractObject.this.getFieldName(pos);
                    }
                };
            }

            @Override
            public int size() {
                return OsonAbstractObject.this.size;
            }
        };
    }

    @Override
    protected void init(int pos) {
        super.init(pos);
        int op = this.ctx.b.getUB1(pos);
        this.initChildOffseUb(op);
        this.fidArrayOffset = pos + 1;
        int childSizeBits = op & 0x18;
        OsonHeader header = this.ctx.getHeader();
        if (childSizeBits == 0) {
            this.size = this.ctx.b.getUB1(pos + 1);
            ++this.fidArrayOffset;
            this.childArrayOffset = this.fidArrayOffset + this.size * header.numFieldIdBytes();
        } else if (childSizeBits == 8) {
            this.size = this.ctx.b.getUB2(pos + 1);
            this.fidArrayOffset += 2;
            this.childArrayOffset = this.fidArrayOffset + this.size * header.numFieldIdBytes();
        } else if (childSizeBits == 16) {
            this.size = this.ctx.b.getUB4int(pos + 1);
            this.fidArrayOffset += 4;
            this.childArrayOffset = this.fidArrayOffset + this.size * header.numFieldIdBytes();
        } else if (childSizeBits == 24) {
            int delegateObjectOffset;
            if (this.childOffsetUb == 4) {
                delegateObjectOffset = this.ctx.b.getUB4int(pos + 1) + header.getTreeSegmentOffset();
                this.childArrayOffset = pos + 1 + 4;
            } else {
                delegateObjectOffset = this.ctx.b.getUB2(pos + 1) + header.getTreeSegmentOffset();
                this.childArrayOffset = pos + 1 + 2;
            }
            int otherOp = this.ctx.b.getUB1(delegateObjectOffset);
            int otherSizeBits = otherOp & 0x18;
            this.fidArrayOffset = delegateObjectOffset + 1;
            if (otherSizeBits == 0) {
                this.size = this.ctx.b.getUB1(delegateObjectOffset + 1);
                ++this.fidArrayOffset;
            } else if (otherSizeBits == 8) {
                this.size = this.ctx.b.getUB2(delegateObjectOffset + 1);
                this.fidArrayOffset += 2;
            } else if (otherSizeBits == 16) {
                this.size = this.ctx.b.getUB4int(delegateObjectOffset + 1);
                this.fidArrayOffset += 4;
            } else {
                throw new IllegalStateException();
            }
        }
        this.fidSorted = (op & 4) == 0 && header.fieldsSorted();
    }

    @Override
    protected int getChildOffset(int fieldPos) {
        OsonHeader header = this.ctx.getHeader();
        if (header.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short relative = this.ctx.b.getShort(this.childArrayOffset + fieldPos * 2);
                relative = (short)(relative + (this.pos - header.getTreeSegmentOffset()));
                return (relative & 0xFFFF) + header.getTreeSegmentOffset();
            }
            int relative = this.ctx.b.getInt(this.childArrayOffset + fieldPos * 4);
            return ((relative += this.pos - header.getTreeSegmentOffset()) & 0xFFFFFFFF) + header.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + fieldPos * 2) + header.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + fieldPos * 4) + header.getTreeSegmentOffset();
    }

    protected int getChildOffset(String key) {
        int fieldPos = this.getChildPosition(key);
        if (fieldPos == -1) {
            return -1;
        }
        return this.getChildOffset(fieldPos);
    }

    protected int getChildPosition(String key) {
        OsonHeader header = this.ctx.getHeader();
        int id2 = header.getFieldId(key);
        if (id2 == -1) {
            return -1;
        }
        this.ctx.b.position(this.pos + 1);
        int fieldPos = header.numFieldIdBytes() == 1 ? (this.fidSorted ? this.ctx.b.binarySearchUb1(this.fidArrayOffset, this.size, id2) : this.ctx.b.linearSearchUb1(this.fidArrayOffset, this.size, id2)) : (header.numFieldIdBytes() == 2 ? (this.fidSorted ? this.ctx.b.binarySearchUb2(this.fidArrayOffset, this.size, id2) : this.ctx.b.linearSearchUb2(this.fidArrayOffset, this.size, id2)) : (this.fidSorted ? this.ctx.b.binarySearchUb4(this.fidArrayOffset, this.size, id2) : this.ctx.b.linearSearchUb4(this.fidArrayOffset, this.size, id2)));
        if (fieldPos < 0) {
            return -1;
        }
        return fieldPos;
    }

    public String getFieldName(int child) {
        OsonHeader header = this.ctx.getHeader();
        int fid = header.numFieldIdBytes() == 1 ? this.ctx.b.getUB1(this.fidArrayOffset + child) : (header.numFieldIdBytes() == 2 ? this.ctx.b.getUB2(this.fidArrayOffset + child * 2) : this.ctx.b.getUB4int(this.fidArrayOffset + child * 4));
        return header.getFieldName(fid - 1);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map m = (Map)other;
        if (m.size() != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            String key = this.getFieldName(i);
            Object value = this.getValueInternal(this.getChildOffset(i));
            if (m.containsKey(key) && value.equals(m.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (Map.Entry e : new OsonEntrySet()) {
            hc += e.hashCode();
        }
        return hc;
    }

    protected class OsonObjectValues<T>
    extends AbstractCollection<T> {
        protected OsonObjectValues() {
        }

        @Override
        public Iterator<T> iterator() {
            return new OsonStructureImpl.PositionIter<T>(){

                @Override
                public T getValue(int pos) {
                    return OsonAbstractObject.this.getValueInternal(OsonAbstractObject.this.getChildOffset(pos++));
                }
            };
        }

        @Override
        public int size() {
            return OsonAbstractObject.this.size;
        }
    }

    protected class OsonEntrySet<T>
    extends AbstractSet<Map.Entry<String, T>> {
        protected OsonEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, T>> iterator() {
            return new OsonStructureImpl.PositionIter<Map.Entry<String, T>>(){

                @Override
                public Map.Entry<String, T> getValue(final int pos) {
                    return new Map.Entry<String, T>(){

                        @Override
                        public String getKey() {
                            return OsonAbstractObject.this.getFieldName(pos);
                        }

                        @Override
                        public T getValue() {
                            return OsonAbstractObject.this.getValueInternal(OsonAbstractObject.this.getChildOffset(pos));
                        }

                        @Override
                        public T setValue(T value) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int hashCode() {
                            return this.getKey().hashCode() ^ this.getValue().hashCode();
                        }

                        @Override
                        public boolean equals(Object other) {
                            if (other == this) {
                                return true;
                            }
                            if (!(other instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry o = (Map.Entry)other;
                            return this.getKey().equals(o.getKey()) && this.getValue().equals(o.getValue());
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return OsonAbstractObject.this.size;
        }
    }
}

