/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import oracle.jdbc.OracleType;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.AbstractGenerator;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.StreamContext;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.VECTOR;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonVector;

public class JsonSerializerImpl
extends AbstractGenerator {
    private static final byte[] CHAR_TYPES;
    private static final byte CHAR_OTHER = 0;
    private static final byte CHAR_CONTROL = 1;
    private static final byte CHAR_LF = 2;
    private static final byte CHAR_QUOTATION = 3;
    private static final byte CHAR_REVERSE_SOLIDUS = 4;
    private static final byte CHAR_SURROGATE = 5;
    private static final byte CHAR_BACKSPACE = 6;
    private static final byte CHAR_FORMFEED = 7;
    private static final byte CHAR_CR = 8;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_ASCII = 10;
    private static final int ASCII_MAX = 127;
    private JsonOutput writer;
    private StreamContext ctx;

    public JsonSerializerImpl(OutputStream out) {
        this.writer = new UTF8JsonOutput(out);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    public JsonSerializerImpl(Writer writer) {
        this.writer = new WriterJsonOutput(writer);
        this.ctx = new StreamContext(this.getExceptionFactory());
    }

    @Override
    public OracleJsonGenerator writeStartObject() {
        this.writeSeparator();
        this.ctx.startObject();
        this.writeAscii('{');
        return this;
    }

    @Override
    public OracleJsonGenerator writeStartArray() {
        this.writeSeparator();
        this.ctx.startArray();
        this.writeAscii('[');
        return this;
    }

    @Override
    public OracleJsonGenerator writeEnd() {
        if (this.ctx.inObject()) {
            this.ctx.end();
            this.writeAscii('}');
        } else {
            this.ctx.end();
            this.writeAscii(']');
        }
        return this;
    }

    @Override
    public OracleJsonGenerator write(String value) {
        this.primitive();
        JsonSerializerImpl.writeQuotedString(value, this.writer, this.getExceptionFactory());
        return this;
    }

    @Override
    public OracleJsonGenerator writeKey(String key) {
        this.writeSeparator();
        this.ctx.pendingKey();
        JsonSerializerImpl.writeQuotedString(key, this.writer, this.getExceptionFactory());
        this.writeAscii(':');
        return this;
    }

    private static void writeQuotedString(String value, JsonOutput writer, OracleJsonExceptions.ExceptionFactory f2) {
        try {
            writer.writeAscii((byte)34);
            JsonSerializerImpl.writeEscaped(value, writer);
            writer.writeAscii((byte)34);
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(f2, e, new Object[0]);
        }
    }

    public static String serializeString(String value) {
        StringWriter w = new StringWriter();
        WriterJsonOutput o = new WriterJsonOutput(w);
        JsonSerializerImpl.writeQuotedString(value, o, null);
        try {
            o.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return w.toString();
    }

    @Override
    public OracleJsonGenerator write(BigDecimal value) {
        this.primitive();
        this.writeBigDecimal(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(BigInteger value) {
        this.primitive();
        this.writeBigInteger(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(int value) {
        this.primitive();
        this.writeInt(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(long value) {
        this.primitive();
        this.writeLong(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(double value) {
        this.assertFinite(value);
        this.primitive();
        this.writeDouble(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(float value) {
        this.assertFinite(value);
        this.primitive();
        this.writeFloat(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(boolean value) {
        this.primitive();
        this.writeBoolean(value);
        return this;
    }

    @Override
    public OracleJsonGenerator writeNull() {
        this.primitive();
        this.writeNullInternal();
        return this;
    }

    @Override
    public void close() {
        this.ctx.close();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    protected OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    @Override
    protected OracleJsonGenerator writeBinary(OracleJsonBinary value) {
        return this.write(((OracleJsonBinaryImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeDouble(OracleJsonDouble value) {
        return this.writeNumber(value);
    }

    @Override
    protected OracleJsonGenerator writeFloat(OracleJsonFloat value) {
        return this.writeNumber(value);
    }

    @Override
    protected OracleJsonGenerator writeOraNumber(OracleJsonDecimal value) {
        return this.writeNumber(value);
    }

    private OracleJsonGenerator writeNumber(OracleJsonNumber value) {
        this.primitive();
        try {
            this.writer.writeAscii(this.numberToString(value));
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
        return this;
    }

    private String numberToString(OracleJsonNumber n) {
        if (n instanceof OracleJsonNumberImpl) {
            return ((OracleJsonNumberImpl)((Object)n)).getString();
        }
        return n.toString();
    }

    @Override
    protected OracleJsonGenerator writeTimestamp(OracleJsonTimestamp value) {
        return this.write(((OracleJsonTimestampImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeTimestampTZ(OracleJsonTimestampTZ value) {
        return this.write(((OracleJsonTimestampTZImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeDate(OracleJsonDate value) {
        return this.write(((OracleJsonDateImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS value) {
        return this.write(((OracleJsonIntervalDSImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM value) {
        return this.write(((OracleJsonIntervalYMImpl)value).getString());
    }

    @Override
    protected OracleJsonGenerator writeVector(OracleJsonVector value) {
        this.writeStartArray();
        VECTOR v = value.getVECTOR();
        try {
            OracleType type = v.getType();
            if (type == OracleType.VECTOR_INT8) {
                int[] ints;
                for (int i : ints = v.toIntArray()) {
                    this.primitive();
                    this.writeInt(i);
                }
            } else if (type == OracleType.VECTOR_FLOAT32) {
                float[] dbls;
                for (float f2 : dbls = value.getFloatArray()) {
                    this.primitive();
                    this.writeFloat(f2);
                }
            } else {
                double[] dbls;
                for (double d : dbls = value.getDoubleArray()) {
                    this.primitive();
                    this.writeDouble(d);
                }
            }
            this.writeEnd();
        }
        catch (SQLException e) {
            throw new OracleJsonException(e);
        }
        return this;
    }

    @Override
    protected OracleJsonGenerator writeString(OracleJsonString value) {
        return this.write(value.getString());
    }

    private void writeAscii(CharSequence s2) {
        try {
            this.writer.writeAscii(s2);
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    private void writeBigDecimal(BigDecimal value) {
        this.writeAscii(value.toString());
    }

    private void writeBigInteger(BigInteger value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeInt(int value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeLong(long value) {
        this.writeAscii(new BigDecimal(value).toString());
    }

    private void writeFloat(float value) {
        this.writeAscii(Float.toString(value));
    }

    private void writeDouble(double value) {
        this.writeAscii(Double.toString(value));
    }

    private void writeBoolean(boolean value) {
        this.writeAscii(String.valueOf(value));
    }

    private void writeNullInternal() {
        this.writeAscii("null");
    }

    private void writeAscii(char c) {
        try {
            this.writer.writeAscii((byte)c);
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    private void primitive() {
        this.writeSeparator();
        this.ctx.primitive();
    }

    private void writeSeparator() {
        if (this.ctx.hasChildren() && !this.ctx.pendingKey) {
            this.writeAscii(',');
        }
    }

    private static void writeEscaped(String value, JsonOutput writer) throws IOException {
        int length = value.length();
        block13: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (CHAR_TYPES[c]) {
                case 10: {
                    writer.writeAscii((byte)c);
                    continue block13;
                }
                case 0: {
                    writer.write(c);
                    continue block13;
                }
                case 2: {
                    writer.writeAscii("\\n");
                    continue block13;
                }
                case 6: {
                    writer.writeAscii("\\b");
                    continue block13;
                }
                case 7: {
                    writer.writeAscii("\\f");
                    continue block13;
                }
                case 8: {
                    writer.writeAscii("\\r");
                    continue block13;
                }
                case 9: {
                    writer.writeAscii("\\t");
                    continue block13;
                }
                case 3: {
                    writer.writeAscii("\\\"");
                    continue block13;
                }
                case 4: {
                    writer.writeAscii("\\\\");
                    continue block13;
                }
                case 1: {
                    JsonSerializerImpl.escape(c, writer);
                    continue block13;
                }
                case 5: {
                    writer.writeSurrogates(value.charAt(i), value.charAt(i + 1));
                    ++i;
                }
            }
        }
    }

    private void assertFinite(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException(Double.toString(value));
        }
    }

    private static void escape(int cp, JsonOutput writer) throws IOException {
        for (char c : Character.toChars(cp)) {
            String hex = Integer.toHexString(c).toUpperCase();
            writer.writeAscii("\\u");
            for (int i = 0; i < 4 - hex.length(); ++i) {
                writer.writeAscii((byte)48);
            }
            writer.writeAscii(hex);
        }
    }

    @Override
    public OracleJsonGenerator write(LocalDateTime local) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestamp(this.getExceptionFactory(), local);
        this.write(OsonPrimitiveConversions.timestampToString(this.getExceptionFactory(), bytes));
        return this;
    }

    @Override
    public OracleJsonGenerator write(OffsetDateTime off) {
        byte[] bytes = OsonPrimitiveConversions.toOracleTimestampTZ(this.getExceptionFactory(), off);
        this.write(OsonPrimitiveConversions.timestampTZToString(this.getExceptionFactory(), bytes));
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, LocalDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, OffsetDateTime value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(String key, byte[] value) {
        this.writeKey(key);
        this.write(value);
        return this;
    }

    @Override
    public OracleJsonGenerator write(byte[] value) {
        return this.write(OracleJsonBinaryImpl.getString(value, false));
    }

    @Override
    public OracleJsonGenerator writeId(byte[] value) {
        return this.write(OracleJsonBinaryImpl.getString(value, true));
    }

    @Override
    public OracleJsonGenerator write(Period value) {
        return this.write(OracleJsonIntervalYMImpl.serializePeriod(value, this.getExceptionFactory()));
    }

    @Override
    public OracleJsonGenerator write(Duration value) {
        return this.write(OracleJsonIntervalDSImpl.serializeDuration(value, this.getExceptionFactory()));
    }

    @Override
    protected void writeStringFromParser(OracleJsonParser parser) {
        if (!this.writer.utf8() || !(parser instanceof OsonParserImpl)) {
            this.write(parser.getString());
            return;
        }
        this.primitive();
        OsonParserImpl oparser = (OsonParserImpl)parser;
        byte[] arr = oparser.getContext().b.buffer.array();
        this.writeQuotedUTF8String(arr, oparser.getCurrentStringPos(), oparser.getCurrentStringLen());
    }

    private void writeQuotedUTF8String(byte[] array, int offset, int len) {
        try {
            this.writeAscii('\"');
            int end = offset + len;
            block13: for (int i = offset; i < end; ++i) {
                byte b = array[i];
                switch (CHAR_TYPES[b & 0xFF]) {
                    case 10: {
                        this.writer.writeAscii(b);
                        continue block13;
                    }
                    case 2: {
                        this.writer.writeAscii("\\n");
                        continue block13;
                    }
                    case 6: {
                        this.writer.writeAscii("\\b");
                        continue block13;
                    }
                    case 7: {
                        this.writer.writeAscii("\\f");
                        continue block13;
                    }
                    case 8: {
                        this.writer.writeAscii("\\r");
                        continue block13;
                    }
                    case 9: {
                        this.writer.writeAscii("\\t");
                        continue block13;
                    }
                    case 3: {
                        this.writer.writeAscii("\\\"");
                        continue block13;
                    }
                    case 4: {
                        this.writer.writeAscii("\\\\");
                        continue block13;
                    }
                    case 1: {
                        JsonSerializerImpl.escape(b, this.writer);
                        continue block13;
                    }
                    default: {
                        if ((b & 0xE0) == 192) {
                            this.writer.utf8(array, i, 2);
                            ++i;
                            continue block13;
                        }
                        if ((b & 0xF0) == 224) {
                            this.writer.utf8(array, i, 3);
                            i += 2;
                            continue block13;
                        }
                        this.writer.utf8(array, i, 4);
                        i += 3;
                    }
                }
            }
            this.writeAscii('\"');
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    @Override
    protected void writeDecimalFromParser(OracleJsonParser parser) {
        this.primitive();
        try {
            this.writer.writeAscii(parser.getString());
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), e, new Object[0]);
        }
    }

    static {
        int i;
        CHAR_TYPES = new byte[65536];
        for (i = 0; i <= 127; ++i) {
            JsonSerializerImpl.CHAR_TYPES[i] = 10;
        }
        for (i = 0; i <= 31; i = (int)((char)(i + 1))) {
            JsonSerializerImpl.CHAR_TYPES[i] = 1;
        }
        JsonSerializerImpl.CHAR_TYPES[127] = 1;
        JsonSerializerImpl.CHAR_TYPES[10] = 2;
        JsonSerializerImpl.CHAR_TYPES[92] = 4;
        JsonSerializerImpl.CHAR_TYPES[34] = 3;
        JsonSerializerImpl.CHAR_TYPES[8] = 6;
        JsonSerializerImpl.CHAR_TYPES[12] = 7;
        JsonSerializerImpl.CHAR_TYPES[13] = 8;
        JsonSerializerImpl.CHAR_TYPES[9] = 9;
        for (int c = 55296; c <= 56319; c = (int)((char)(c + 1))) {
            JsonSerializerImpl.CHAR_TYPES[c] = 5;
        }
    }

    private static class UTF8JsonOutput
    implements JsonOutput {
        byte[] buffer = new byte[1024];
        OutputStream out;
        int pos = 0;
        CharsetEncoder encoder;
        CharBuffer cbuffer;

        public UTF8JsonOutput(OutputStream out) {
            this.out = out;
        }

        private void initEncoder() {
            if (this.encoder == null) {
                this.encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.cbuffer = CharBuffer.allocate(2);
            }
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.out.close();
            this.buffer = null;
        }

        @Override
        public void writeAscii(CharSequence value) throws IOException {
            for (int i = 0; i < value.length(); ++i) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = (byte)value.charAt(i);
            }
        }

        @Override
        public void writeAscii(byte value) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = value;
        }

        @Override
        public void flush() throws IOException {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void write(char c) throws IOException {
            if (c <= '\u007f') {
                this.writeAscii((byte)c);
            } else {
                this.flush();
                this.initEncoder();
                this.cbuffer.clear();
                this.cbuffer.append(c);
                this.cbuffer.flip();
                this.encodeChars();
            }
        }

        @Override
        public void writeSurrogates(char c1, char c2) throws IOException {
            this.flush();
            this.initEncoder();
            this.cbuffer.clear();
            this.cbuffer.append(c1);
            this.cbuffer.append(c2);
            this.cbuffer.flip();
            this.encodeChars();
        }

        @Override
        public boolean utf8() {
            return true;
        }

        private void encodeChars() {
            ByteBuffer b = ByteBuffer.wrap(this.buffer);
            this.encoder.encode(this.cbuffer, b, false);
            this.pos = b.position();
        }

        @Override
        public void utf8(byte[] array, int offset, int len) throws IOException {
            this.flush();
            this.out.write(array, offset, len);
        }
    }

    private static final class WriterJsonOutput
    implements JsonOutput {
        char[] buffer = new char[1024];
        int pos = 0;
        Writer writer;

        WriterJsonOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.writer.close();
            this.buffer = null;
        }

        @Override
        public void flush() throws IOException {
            this.writer.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }

        @Override
        public void writeAscii(CharSequence value) throws IOException {
            for (int i = 0; i < value.length(); ++i) {
                if (this.pos >= this.buffer.length) {
                    this.flush();
                }
                this.buffer[this.pos++] = value.charAt(i);
            }
        }

        @Override
        public void writeAscii(byte value) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (char)value;
        }

        @Override
        public void write(char c) throws IOException {
            if (this.pos >= this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = c;
        }

        @Override
        public void writeSurrogates(char c1, char c2) throws IOException {
            this.write(c1);
            this.write(c2);
        }

        @Override
        public boolean utf8() {
            return false;
        }

        @Override
        public void utf8(byte[] array, int offset, int len) throws IOException {
            this.flush();
            this.writer.write(new String(array, offset, len, StandardCharsets.UTF_8));
        }
    }

    private static interface JsonOutput
    extends Closeable {
        public void flush() throws IOException;

        public void write(char var1) throws IOException;

        public void writeAscii(CharSequence var1) throws IOException;

        public void writeAscii(byte var1) throws IOException;

        public void writeSurrogates(char var1, char var2) throws IOException;

        public boolean utf8();

        public void utf8(byte[] var1, int var2, int var3) throws IOException;
    }
}

