/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.configuration;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.spi.OracleConfigurationParser;
import oracle.jdbc.spi.OracleConfigurationSecretProvider;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class JsonParser
implements OracleConfigurationParser {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final Map<String, OracleConfigurationSecretProvider> secretProviders = new HashMap<String, OracleConfigurationSecretProvider>();
    private static final String WALLET_LOCATION_JSON_OBJECT_NAME = "wallet_location";
    private static final String CONFIG_TTL_JSON_OBJECT_NAME = "config_time_to_live";

    @Override
    public Properties parse(InputStream source, Map<String, String> options) throws SQLException {
        OracleConfigurationSecretProvider provider;
        String secretType;
        OracleJsonObject json = JSON_FACTORY.createJsonTextValue(source).asJsonObject();
        String key = options.get("key");
        if (key != null) {
            if (!json.containsKey(key)) {
                throw new IllegalArgumentException(key + " key appears in URL but is missing in JSON.");
            }
            json = ((OracleJsonValue)json.get(key)).asJsonObject();
        }
        Properties properties = new Properties();
        if (json.containsKey("user")) {
            properties.setProperty("user", json.getString("user"));
        }
        if (!json.containsKey("connect_descriptor")) {
            throw new SQLException("'connect_descriptor' attribute missing in JSON.");
        }
        properties.setProperty("URL", "jdbc:oracle:thin:@" + json.getString("connect_descriptor"));
        if (json.containsKey("jdbc")) {
            OracleJsonObject jdbc = ((OracleJsonValue)json.get("jdbc")).asJsonObject();
            jdbc.forEach((k, v) -> {
                if (v.getOracleJsonType().equals((Object)OracleJsonValue.OracleJsonType.STRING)) {
                    properties.setProperty((String)k, v.asJsonString().getString());
                } else {
                    properties.setProperty((String)k, v.toString());
                }
            });
        }
        if (json.containsKey("password")) {
            OracleJsonObject passwordObject = ((OracleJsonValue)json.get("password")).asJsonObject();
            Map<String, String> passwordMap = this.convertToMap(passwordObject);
            secretType = passwordObject.getString("type");
            provider = null;
            if (secretProviders.containsKey(secretType)) {
                provider = secretProviders.get(secretType);
            } else {
                provider = OracleConfigurationSecretProvider.find(secretType);
                secretProviders.put(secretType, provider);
            }
            properties.setProperty("password", new String(Base64.getDecoder().decode(new String(provider.getSecret(passwordMap)))));
        }
        if (json.containsKey(WALLET_LOCATION_JSON_OBJECT_NAME)) {
            OracleJsonObject walletObject = ((OracleJsonValue)json.get(WALLET_LOCATION_JSON_OBJECT_NAME)).asJsonObject();
            Map<String, String> walletMap = this.convertToMap(walletObject);
            secretType = walletObject.getString("type");
            provider = null;
            if (secretProviders.containsKey(secretType)) {
                provider = secretProviders.get(secretType);
            } else {
                provider = OracleConfigurationSecretProvider.find(secretType);
                secretProviders.put(secretType, provider);
            }
            properties.setProperty("oracle.net.wallet_location", "data:;base64," + new String(provider.getSecret(walletMap)));
        }
        if (json.containsKey(CONFIG_TTL_JSON_OBJECT_NAME)) {
            properties.setProperty(CONFIG_TTL_JSON_OBJECT_NAME, String.valueOf(json.getLong(CONFIG_TTL_JSON_OBJECT_NAME)));
        }
        return properties;
    }

    @Override
    public String getType() {
        return "json";
    }

    private Map<String, String> convertToMap(OracleJsonObject jsonObject) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        jsonObject.keySet().forEach(key -> {
            OracleJsonValue jsonValue = (OracleJsonValue)jsonObject.get(key);
            if (key.equals("authentication")) {
                OracleJsonObject authObject = jsonValue.asJsonObject();
                authObject.keySet().forEach(k -> {
                    String v = authObject.getString((String)k);
                    if (k.equals("method")) {
                        map2.put("AUTHENTICATION", v);
                    } else {
                        map2.put((String)k, v);
                    }
                });
            } else {
                map2.put((String)key, jsonValue.asJsonString().getString());
            }
        });
        return map2;
    }
}

