/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.oracore.OracleType;

abstract class TypeAccessor
extends Accessor {
    TypeAccessor(Representation _representation, OracleStatement _statement, int _representationLengthMax, boolean isStoredInBindData) {
        super(_representation, _statement, _representationLengthMax, isStoredInBindData);
    }

    abstract OracleType otypeFromName(String var1) throws SQLException;

    abstract CompletionStage<OracleType> otypeFromNameAsync(String var1);

    @Override
    void initForDescribe(int type, int max_length, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        this.describeTypeName = typeName;
        this.initForDescribe(type, max_length, nullable2, precision, scale, flags, contflag, total_elems, form);
    }

    byte[] pickledBytes(int currentRow) throws SQLException {
        return this.getBytesInternal(currentRow);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeName = typeName;
    }

    @Override
    void initMetadata() throws SQLException {
        if (this.describeOtype == null && this.describeTypeName != null) {
            this.describeOtype = this.otypeFromName(this.describeTypeName);
        }
        if (this.internalOtype == null && this.internalTypeName != null) {
            this.internalOtype = this.otypeFromName(this.internalTypeName);
        }
    }

    @Override
    final CompletionStage<Void> initMetadataAsync() {
        CompletionStage<Void> describeOtypeStage = this.describeOtype == null && this.describeTypeName != null ? this.otypeFromNameAsync(this.describeTypeName).thenAccept(describeOtype -> {
            this.describeOtype = describeOtype;
        }) : CompletionStageUtil.VOID_COMPLETED_FUTURE;
        return describeOtypeStage.thenCompose(nil -> {
            if (this.internalOtype == null && this.internalTypeName != null) {
                return this.otypeFromNameAsync(this.internalTypeName).thenAccept(internalOtype -> {
                    this.internalOtype = internalOtype;
                });
            }
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        });
    }

    @Override
    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        byte[] data = this.pickledBytes(currentRow);
        _checkSum = data == null || data.length == 0 ? CRC64.updateChecksum(_checkSum, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length) : CRC64.updateChecksum(_checkSum, data, 0, data.length);
        return _checkSum;
    }
}

