/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;

    TimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.TIMESTAMPLTZ, stmt, 11, isStoredInBindData);
        this.init(stmt, 231, 231, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    TimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMPLTZ, stmt, 11, false);
        this.init(stmt, 231, 231, form, false);
        this.initForDescribe(231, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        TimeZone zone = TimeZone.getTimeZone(sessTzStr);
        Calendar sessTzCal = Calendar.getInstance(zone);
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year2 = TimestampltzAccessor.oracleYear(this.tmpBytes);
        dbTzCal.set(1, year2);
        dbTzCal.set(2, TimestampltzAccessor.oracleMonth(this.tmpBytes));
        dbTzCal.set(5, TimestampltzAccessor.oracleDay(this.tmpBytes));
        dbTzCal.set(11, TimestampltzAccessor.oracleHour(this.tmpBytes));
        dbTzCal.set(12, TimestampltzAccessor.oracleMin(this.tmpBytes));
        dbTzCal.set(13, TimestampltzAccessor.oracleSec(this.tmpBytes));
        dbTzCal.set(14, 0);
        oracle.sql.TIMESTAMPLTZ.TimeZoneAdjust(this.statement.connection, dbTzCal, sessTzCal);
        year2 = sessTzCal.get(1);
        int month2 = sessTzCal.get(2) + 1;
        int date = sessTzCal.get(5);
        int hour2 = sessTzCal.get(11);
        int minute2 = sessTzCal.get(12);
        int second2 = sessTzCal.get(13);
        int nanos = 0;
        boolean am = hour2 < 12;
        String regname = sessTzCal.getTimeZone().getID();
        if (regname.length() > 3 && regname.startsWith("GMT")) {
            regname = regname.substring(3);
        }
        if (this.getLength(currentRow) == 11) {
            nanos = TimestampltzAccessor.oracleNanos(this.tmpBytes);
        }
        return this.toText(year2, month2, date, hour2, minute2, second2, nanos, am, regname);
    }

    @Override
    Date getDate(int currentRow, Calendar cal) throws SQLException {
        return this.getDate(currentRow);
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year2 = TimestampltzAccessor.oracleYear(this.tmpBytes);
        dbTzCal.set(1, year2);
        dbTzCal.set(2, TimestampltzAccessor.oracleMonth(this.tmpBytes));
        dbTzCal.set(5, TimestampltzAccessor.oracleDay(this.tmpBytes));
        dbTzCal.set(11, TimestampltzAccessor.oracleHour(this.tmpBytes));
        dbTzCal.set(12, TimestampltzAccessor.oracleMin(this.tmpBytes));
        dbTzCal.set(13, TimestampltzAccessor.oracleSec(this.tmpBytes));
        dbTzCal.set(14, 0);
        long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
        return new Date(millis);
    }

    @Override
    Time getTime(int currentRow, Calendar cal) throws SQLException {
        return this.getTime(currentRow);
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year2 = TimestampltzAccessor.oracleYear(this.tmpBytes);
        dbTzCal.set(1, year2);
        dbTzCal.set(2, TimestampltzAccessor.oracleMonth(this.tmpBytes));
        dbTzCal.set(5, TimestampltzAccessor.oracleDay(this.tmpBytes));
        dbTzCal.set(11, TimestampltzAccessor.oracleHour(this.tmpBytes));
        dbTzCal.set(12, TimestampltzAccessor.oracleMin(this.tmpBytes));
        dbTzCal.set(13, TimestampltzAccessor.oracleSec(this.tmpBytes));
        dbTzCal.set(14, 0);
        long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
        return new Time(millis);
    }

    @Override
    Timestamp getTimestamp(int currentRow, Calendar cal) throws SQLException {
        return this.getTimestamp(currentRow);
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        Calendar dbTzCal = this.statement.connection.getDbTzCalendar();
        String sessTzStr = this.statement.connection.getSessionTimeZone();
        if (sessTzStr == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int year2 = TimestampltzAccessor.oracleYear(this.tmpBytes);
        dbTzCal.set(1, year2);
        dbTzCal.set(2, TimestampltzAccessor.oracleMonth(this.tmpBytes));
        dbTzCal.set(5, TimestampltzAccessor.oracleDay(this.tmpBytes));
        dbTzCal.set(11, TimestampltzAccessor.oracleHour(this.tmpBytes));
        dbTzCal.set(12, TimestampltzAccessor.oracleMin(this.tmpBytes));
        dbTzCal.set(13, TimestampltzAccessor.oracleSec(this.tmpBytes));
        dbTzCal.set(14, 0);
        long millis = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, dbTzCal);
        Timestamp result2 = new Timestamp(millis);
        if (this.getLength(currentRow) == 11) {
            result2.setNanos(TimestampltzAccessor.oracleNanos(this.tmpBytes));
        }
        return result2;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getTIMESTAMPLTZ(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getTIMESTAMPLTZ(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getTIMESTAMPLTZ(currentRow);
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return new TIMESTAMPLTZ(this.getBytesInternal(currentRow));
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        return oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, this.getBytesInternal(currentRow));
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tmtz.getBytes());
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        TIMESTAMPTZ tmtz = this.getTIMESTAMPTZ(currentRow);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tmtz.getBytes());
    }

    @Override
    Calendar getCalendar(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), Calendar.class, this.statement.connection, null, null);
    }

    @Override
    LocalDate getLocalDate(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), LocalDate.class, this.statement.connection, null, null);
    }

    @Override
    LocalDateTime getLocalDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), LocalDateTime.class, this.statement.connection, null, null);
    }

    @Override
    LocalTime getLocalTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), LocalTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetDateTime getOffsetDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), OffsetDateTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetTime getOffsetTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), OffsetTime.class, this.statement.connection, null, null);
    }

    @Override
    ZonedDateTime getZonedDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMPLTZ(this.getBytesInternal(currentRow)), ZonedDateTime.class, this.statement.connection, null, null);
    }
}

