/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;

    TimestampAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.TIMESTAMP, stmt, 11, isStoredInBindData);
        this.init(stmt, 180, 180, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    TimestampAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMP, stmt, 11, false);
        this.init(stmt, 180, 180, form, false);
        this.initForDescribe(180, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        this.getBytesInternal(currentRow, this.tmpBytes);
        int len = this.getLength(currentRow);
        int year2 = TimestampAccessor.oracleYear(this.tmpBytes);
        int nanos = -1;
        if (len == 11) {
            nanos = TimestampAccessor.oracleNanos(this.tmpBytes);
        }
        int hour2 = TimestampAccessor.oracleHour(this.tmpBytes);
        String result2 = this.toText(year2, TimestampAccessor.oracleMonth(this.tmpBytes) + 1, TimestampAccessor.oracleDay(this.tmpBytes), hour2, TimestampAccessor.oracleMin(this.tmpBytes), TimestampAccessor.oracleSec(this.tmpBytes), nanos, hour2 < 12, null);
        return result2;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isUseLess || this.isNull(currentRow)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.j2ee13Compliant) {
                return this.getTimestamp(currentRow);
            }
            return this.getTIMESTAMP(currentRow);
        }
        switch (this.externalType) {
            case 93: {
                return this.getTimestamp(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getTIMESTAMP(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getObject(currentRow);
    }

    @Override
    LocalDate getLocalDate(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMP(this.getBytesInternal(currentRow)), LocalDate.class, this.statement.connection, null, null);
    }

    @Override
    LocalDateTime getLocalDateTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMP(this.getBytesInternal(currentRow)), LocalDateTime.class, this.statement.connection, null, null);
    }

    @Override
    LocalTime getLocalTime(int currentRow) throws SQLException {
        return JavaToJavaConverter.convert(new TIMESTAMP(this.getBytesInternal(currentRow)), LocalTime.class, this.statement.connection, null, null);
    }

    @Override
    OffsetDateTime getOffsetDateTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }

    @Override
    OffsetTime getOffsetTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }

    @Override
    ZonedDateTime getZonedDateTime(int currentRow) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1716, null, null, "DATE").fillInStackTrace();
    }
}

