/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CCharAccessor
extends CharAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    boolean underlyingLong = false;
    private T4CMarshaller marshaller = null;

    T4CCharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, isOutBind, false);
        this.mare = _mare;
        this.calculateSizeTmpByteArray();
    }

    T4CCharAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form, int maxCodePointLen, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, maxCodePointLen);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
        this.calculateSizeTmpByteArray();
        this.oacmxl = _oacmxl;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] buffer, int offset, int length, int[] escapeSequenceArr, boolean[] readHeaderArr, boolean[] readAsNonStreamArr, T4CMAREngine mare, T4CTTIoer11 oer) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(buffer, offset, length, escapeSequenceArr, readHeaderArr, readAsNonStreamArr, mare, oer);
    }

    @Override
    NUMBER getNUMBER(int currentRow) throws SQLException {
        NUMBER result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getNUMBER(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                return T4CVarcharAccessor.StringToNUMBER(s2.trim());
            }
        }
        return result2;
    }

    @Override
    DATE getDATE(int currentRow) throws SQLException {
        DATE result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getDATE(currentRow);
        } else {
            Date d = this.getDate(currentRow);
            if (d != null) {
                result2 = new DATE(d);
            }
        }
        return result2;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMP result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getTIMESTAMP(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result2 = new TIMESTAMP(ts);
            }
        }
        return result2;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getTIMESTAMPTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result2 = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result2;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getTIMESTAMPLTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result2 = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result2;
    }

    @Override
    RAW getRAW(int currentRow) throws SQLException {
        RAW result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getRAW(currentRow);
        } else if (!this.rowNull[currentRow]) {
            result2 = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(currentRow)) : new RAW(super.getBytes(currentRow));
        }
        return result2;
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(currentRow);
        }
        Datum result2 = null;
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(21).fillInStackTrace();
        }
        if (!this.rowNull[currentRow]) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(currentRow);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(currentRow);
                }
                case 91: {
                    return this.getDATE(currentRow);
                }
                case 92: {
                    return this.getDATE(currentRow);
                }
                case 93: {
                    return this.getTIMESTAMP(currentRow);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(currentRow);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(currentRow);
                }
                case -8: {
                    return this.getROWID(currentRow);
                }
            }
            throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
        }
        return result2;
    }

    @Override
    byte getByte(int currentRow) throws SQLException {
        byte result2 = 0;
        if (this.definedColumnType == 0) {
            result2 = super.getByte(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.byteValue();
            }
        }
        return result2;
    }

    @Override
    int getInt(int currentRow) throws SQLException {
        int result2 = 0;
        if (this.definedColumnType == 0) {
            result2 = super.getInt(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.intValue();
            }
        }
        return result2;
    }

    @Override
    short getShort(int currentRow) throws SQLException {
        short result2 = 0;
        if (this.definedColumnType == 0) {
            result2 = super.getShort(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.shortValue();
            }
        }
        return result2;
    }

    @Override
    long getLong(int currentRow) throws SQLException {
        long result2 = 0L;
        if (this.definedColumnType == 0) {
            result2 = super.getLong(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.longValue();
            }
        }
        return result2;
    }

    @Override
    float getFloat(int currentRow) throws SQLException {
        float result2 = 0.0f;
        if (this.definedColumnType == 0) {
            result2 = super.getFloat(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.floatValue();
            }
        }
        return result2;
    }

    @Override
    double getDouble(int currentRow) throws SQLException {
        double result2 = 0.0;
        if (this.definedColumnType == 0) {
            result2 = super.getDouble(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result2 = tmp.doubleValue();
            }
        }
        return result2;
    }

    @Override
    Date getDate(int currentRow) throws SQLException {
        Date result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getDate(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    result2 = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result2;
    }

    @Override
    Timestamp getTimestamp(int currentRow) throws SQLException {
        Timestamp result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getTimestamp(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                    result2 = new Timestamp(cal.getTimeInMillis());
                    result2.setNanos(nanos[0]);
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result2;
    }

    @Override
    Time getTime(int currentRow) throws SQLException {
        Time result2 = null;
        if (this.definedColumnType == 0) {
            result2 = super.getTime(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                try {
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                    result2 = new Time(cal.getTimeInMillis());
                }
                catch (NumberFormatException ex) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                }
            }
        }
        return result2;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.CHAR;
        }
        return this.marshaller;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isUnexpected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(currentRow);
            }
            case 4: {
                return this.getInt(currentRow);
            }
            case -6: {
                return this.getByte(currentRow);
            }
            case 5: {
                return this.getShort(currentRow);
            }
            case -7: 
            case 16: {
                return this.getBoolean(currentRow);
            }
            case -5: {
                return this.getLong(currentRow);
            }
            case 7: {
                return Float.valueOf(this.getFloat(currentRow));
            }
            case 6: 
            case 8: {
                return this.getDouble(currentRow);
            }
            case 91: {
                return this.getDate(currentRow);
            }
            case 92: {
                return this.getTime(currentRow);
            }
            case 93: {
                return this.getTimestamp(currentRow);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesFromHexChars(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        final VectorMetaData vectorMetaData = this.getVectorMetaData();
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CCharAccessor acc = new T4CCharAccessor(stmt, T4CCharAccessor.this.describeMaxLength, T4CCharAccessor.this.nullable, -1, T4CCharAccessor.this.precision, T4CCharAccessor.this.scale, T4CCharAccessor.this.contflag, -1, T4CCharAccessor.this.formOfUse, T4CCharAccessor.this.describeMaxLengthChars, T4CCharAccessor.this.oacmxl, T4CCharAccessor.this.definedColumnType, T4CCharAccessor.this.definedColumnSize, null);
                acc.setVectorMetaData(vectorMetaData);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

