/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class T2CPlsqlIndexTableAccessor
extends PlsqlIndexTableAccessor {
    int ibtMetaIndex;

    T2CPlsqlIndexTableAccessor(OracleStatement stmt, PlsqlIbtBindInfo ibtBindInfo_, short form) throws SQLException {
        super(stmt, ibtBindInfo_, form);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        this.unimpl("initForDataAccess");
    }

    @Override
    Object[] getPlsqlIndexTable(int currentRow) throws SQLException {
        Object[] result2;
        short[] ibtBindIndicators = this.statement.ibtBindIndicators;
        int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
        long offset = this.getOffset(currentRow);
        int maxLength = this.ibtBindInfo.elemMaxLen;
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                int[] out_lengthInChars = new int[1];
                result2 = new String[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    this.rowData.setPosition(offset);
                    char[] c = this.rowData.getChars(offset, 1, this.statement.connection.conversion.getCharacterSet((short)1), out_lengthInChars);
                    int len = c[0] / 2;
                    this.rowData.setPosition(offset + 1L);
                    result2[i] = len == 0 ? null : this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                    offset += (long)maxLength;
                }
                break;
            }
            case 6: {
                result2 = new BigDecimal[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    this.rowData.setPosition(offset);
                    int len = this.rowData.get() & 0xFF;
                    result2[i] = len == 0 ? null : oracle.sql.NUMBER.toBigDecimal(this.rowData.getBytes(len));
                    offset += (long)maxLength;
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        return result2;
    }

    @Override
    Datum[] getOraclePlsqlIndexTable(int currentRow) throws SQLException {
        short[] ibtBindIndicators = this.statement.ibtBindIndicators;
        int actualElements = ((ibtBindIndicators[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (ibtBindIndicators[this.ibtMetaIndex + 5] & 0xFFFF);
        long offset = this.getOffset(currentRow);
        int maxLength = this.ibtBindInfo.elemMaxLen;
        Datum[] result2 = null;
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                int[] out_lengthInChars = new int[1];
                result2 = new CHAR[actualElements];
                CharacterSet charset = this.statement.connection.conversion.getDriverCharSetObj();
                for (int i = 0; i < actualElements; ++i) {
                    this.rowData.setPosition(offset);
                    char[] c = this.rowData.getChars(offset, 1, this.statement.connection.conversion.getCharacterSet((short)1), out_lengthInChars);
                    int len = c[0] / 2;
                    this.rowData.setPosition(offset + 1L);
                    if (len == 0) {
                        result2[i] = null;
                    } else {
                        String s2 = this.rowData.getString(len, this.statement.connection.conversion.getCharacterSet((short)1));
                        result2[i] = new CHAR(s2, charset);
                    }
                    offset += (long)maxLength;
                }
                break;
            }
            case 6: {
                result2 = new NUMBER[actualElements];
                for (int i = 0; i < actualElements; ++i) {
                    this.rowData.setPosition(offset);
                    int len = this.rowData.get() & 0xFF;
                    result2[i] = len == 0 ? null : new NUMBER(this.rowData.getBytes(len));
                    offset += (long)maxLength;
                }
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97).fillInStackTrace();
            }
        }
        return result2;
    }
}

