/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    T2CDriverExtension() {
    }

    @Override
    final T2CConnection getConnection(String url2, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        if (builder.getTokenSupplier() != null) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Type 2 driver does not support token-based authentication").fillInStackTrace();
        }
        T2CConnection t2Conn = null;
        t2Conn = info.getProperty("is_connection_pooling") == "true" ? new OracleOCIConnection(url2, info, (Object)this) : new T2CConnection(url2, info, this);
        try (Monitor.CloseableLock lock = t2Conn.acquireCloseableLock();){
            t2Conn.connect(builder);
        }
        return t2Conn;
    }

    final CompletionStage<Connection> getConnectionAsync(String url2, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the Type 2 OCI driver"));
    }

    @Override
    T2CStatement allocateStatement(OracleConnection connection, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T2CStatement((T2CConnection)connection, resultSetType);
    }

    @Override
    T2CPreparedStatement allocatePreparedStatement(OracleConnection connection, String sql2, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T2CPreparedStatement((T2CConnection)connection, sql2, resultSetType);
    }

    @Override
    T2CPreparedStatement allocatePreparedStatement(OracleConnection connection, String sql2, AutoKeyInfo autoKeyInfo) throws SQLException {
        return new T2CPreparedStatement((T2CConnection)connection, sql2, autoKeyInfo);
    }

    @Override
    T2CCallableStatement allocateCallableStatement(OracleConnection conn, String sql2, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T2CCallableStatement((T2CConnection)conn, sql2, resultSetType);
    }

    @Override
    T2CInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        return new T2CInputStream(stmt, index, accessor);
    }
}

