/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;
import oracle.sql.ROWID;

class RowidAccessor
extends Accessor {
    static final int MAXLENGTH = 4000;
    static final int EXTENDED_ROWID_MAX_LENGTH = 18;

    RowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        this(stmt, max_len, form, external_type, isOutBind, isOutBind ? stmt.areOutBindsStoredInBindData() : false);
    }

    RowidAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.ROWID, stmt, 4000, isStoredInBindData);
        this.init(stmt, 104, 9, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    RowidAccessor(OracleStatement stmt, int max_len, boolean nullable2, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.ROWID, stmt, 4000, false);
        this.init(stmt, 104, 9, form, false);
        this.initForDescribe(104, max_len, nullable2, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.byteLength = this.representationMaxLength + 2;
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.rowData.getString(this.getOffset(currentRow), this.getLength(currentRow), this.statement.connection.conversion.getCharacterSet((short)1));
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getROWID(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getROWID(currentRow);
    }

    @Override
    ROWID getROWID(int currentRow) throws SQLException {
        byte[] b = this.getBytes(currentRow);
        return b == null ? null : new ROWID(b);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map2) throws SQLException {
        return this.getROWID(currentRow);
    }
}

